/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.ColumnHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.sort.ColumnSortCallback;
import com.evrencoskun.tableview.sort.ColumnSortComparator;
import com.evrencoskun.tableview.sort.ISortableModel;
import com.evrencoskun.tableview.sort.SortState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ColumnSortHandler {
    private CellRecyclerViewAdapter mCellRecyclerViewAdapter;
    private RowHeaderRecyclerViewAdapter mRowHeaderRecyclerViewAdapter;
    private ColumnHeaderRecyclerViewAdapter mColumnHeaderRecyclerViewAdapter;

    public ColumnSortHandler(ITableView p_iTableView) {
        this.mCellRecyclerViewAdapter = (CellRecyclerViewAdapter)p_iTableView.getCellRecyclerView().getAdapter();
        this.mRowHeaderRecyclerViewAdapter = (RowHeaderRecyclerViewAdapter)p_iTableView.getRowHeaderRecyclerView().getAdapter();
        this.mColumnHeaderRecyclerViewAdapter = (ColumnHeaderRecyclerViewAdapter)p_iTableView.getColumnHeaderRecyclerView().getAdapter();
    }

    public void sort(int p_nXPosition, SortState p_nSortState) {
        List<List<ISortableModel>> m_jOriginalList = this.mCellRecyclerViewAdapter.getItems();
        ArrayList<List<ISortableModel>> m_jSortedList = new ArrayList<List<ISortableModel>>(m_jOriginalList);
        if (p_nSortState != SortState.UNSORTED) {
            Collections.sort(m_jSortedList, new ColumnSortComparator(p_nXPosition, p_nSortState));
        }
        this.mColumnHeaderRecyclerViewAdapter.getColumnSortHelper().setSortingStatus(p_nXPosition, p_nSortState);
        this.swapItems(m_jOriginalList, m_jSortedList, p_nXPosition);
    }

    private void swapItems(List<List<ISortableModel>> m_jOldItems, List<List<ISortableModel>> m_jNewItems, int p_nXPosition) {
        ColumnSortCallback diffCallback = new ColumnSortCallback(m_jOldItems, m_jNewItems, p_nXPosition);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        this.mCellRecyclerViewAdapter.setItems(m_jNewItems, false);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mCellRecyclerViewAdapter);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mRowHeaderRecyclerViewAdapter);
    }

    public void swapItems(List<List<ISortableModel>> m_jNewItems, int p_nXPosition) {
        List<List<ISortableModel>> m_jOldItems = this.mCellRecyclerViewAdapter.getItems();
        ColumnSortCallback diffCallback = new ColumnSortCallback(m_jOldItems, m_jNewItems, p_nXPosition);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        this.mCellRecyclerViewAdapter.setItems(m_jNewItems, false);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mCellRecyclerViewAdapter);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mRowHeaderRecyclerViewAdapter);
    }

    public SortState getSortingStatus(int column) {
        return this.mColumnHeaderRecyclerViewAdapter.getColumnSortHelper().getSortingStatus(column);
    }
}

