/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import java.util.List;

public class CellRowRecyclerViewAdapter<C>
extends AbstractRecyclerViewAdapter<C> {
    private static final String LOG_TAG = CellRowRecyclerViewAdapter.class.getSimpleName();
    private int m_nYPosition;
    private ITableAdapter m_iTableAdapter;

    public CellRowRecyclerViewAdapter(Context context, List p_jItemList, ITableAdapter p_iTableAdapter, int p_nYPosition) {
        super(context, p_jItemList);
        this.m_nYPosition = p_nYPosition;
        this.m_iTableAdapter = p_iTableAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.m_iTableAdapter != null) {
            AbstractViewHolder viewHolder = (AbstractViewHolder)this.m_iTableAdapter.onCreateCellViewHolder(parent, viewType);
            return viewHolder;
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int p_nXPosition) {
        if (this.m_iTableAdapter != null) {
            AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
            Object value = this.getItem(p_nXPosition);
            this.m_iTableAdapter.onBindCellViewHolder(viewHolder, value, p_nXPosition, this.m_nYPosition);
        }
    }

    public int getYPosition() {
        return this.m_nYPosition;
    }

    @Override
    public int getItemViewType(int position) {
        return this.m_iTableAdapter.getCellItemViewType(position);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        AbstractViewHolder.SelectionState selectionState = this.m_iTableAdapter.getTableView().getSelectionHandler().getCellSelectionState(holder.getAdapterPosition(), this.m_nYPosition);
        if (!this.m_iTableAdapter.getTableView().isIgnoreSelectionColors()) {
            if (selectionState == AbstractViewHolder.SelectionState.SELECTED) {
                viewHolder.setBackgroundColor(this.m_iTableAdapter.getTableView().getSelectedColor());
            } else {
                viewHolder.setBackgroundColor(this.m_iTableAdapter.getTableView().getUnSelectedColor());
            }
        }
        viewHolder.setSelected(selectionState);
    }
}

