/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRowRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnLayoutManager;
import com.evrencoskun.tableview.listener.itemclick.CellRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import java.util.ArrayList;
import java.util.List;

public class CellRecyclerViewAdapter<C>
extends AbstractRecyclerViewAdapter<C> {
    private static final String LOG_TAG = CellRecyclerViewAdapter.class.getSimpleName();
    private ITableAdapter m_iTableAdapter;
    private HorizontalRecyclerViewListener m_iHorizontalListener;
    private int m_nRecyclerViewId = 0;

    public CellRecyclerViewAdapter(Context context, List<C> p_jItemList, ITableAdapter p_iTableAdapter) {
        super(context, p_jItemList);
        this.m_iTableAdapter = p_iTableAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ITableView iTableView = this.m_iTableAdapter.getTableView();
        CellRecyclerView jRecyclerView = new CellRecyclerView(this.mContext);
        if (iTableView.isShowHorizontalSeparators()) {
            jRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)iTableView.getHorizontalItemDecoration());
        }
        if (iTableView != null) {
            jRecyclerView.setHasFixedSize(iTableView.hasFixedWidth());
            if (this.m_iHorizontalListener == null) {
                this.m_iHorizontalListener = iTableView.getHorizontalRecyclerViewListener();
            }
            jRecyclerView.addOnItemTouchListener(this.m_iHorizontalListener);
            jRecyclerView.addOnItemTouchListener(new CellRecyclerViewItemClickListener(jRecyclerView, iTableView));
            ColumnLayoutManager layoutManager = new ColumnLayoutManager(this.mContext, iTableView, jRecyclerView);
            jRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            jRecyclerView.setId(this.m_nRecyclerViewId);
            ++this.m_nRecyclerViewId;
        }
        return new CellRowViewHolder((View)jRecyclerView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int p_nYPosition) {
        if (!(holder instanceof CellRowViewHolder)) {
            return;
        }
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        List rowList = (List)this.mItemList.get(p_nYPosition);
        CellRowRecyclerViewAdapter viewAdapter = new CellRowRecyclerViewAdapter(this.mContext, rowList, this.m_iTableAdapter, p_nYPosition);
        viewHolder.m_jRecyclerView.setAdapter(viewAdapter);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        ((ColumnLayoutManager)viewHolder.m_jRecyclerView.getLayoutManager()).scrollToPositionWithOffset(this.m_iHorizontalListener.getScrollPosition(), this.m_iHorizontalListener.getScrollPositionOffset());
        SelectionHandler selectionHandler = this.m_iTableAdapter.getTableView().getSelectionHandler();
        if (selectionHandler.isAnyColumnSelected()) {
            AbstractViewHolder cellViewHolder = (AbstractViewHolder)((CellRowViewHolder)holder).m_jRecyclerView.findViewHolderForAdapterPosition(selectionHandler.getSelectedColumnPosition());
            if (cellViewHolder != null) {
                if (!this.m_iTableAdapter.getTableView().isIgnoreSelectionColors()) {
                    cellViewHolder.setBackgroundColor(this.m_iTableAdapter.getTableView().getSelectedColor());
                }
                cellViewHolder.setSelected(AbstractViewHolder.SelectionState.SELECTED);
            }
        } else if (selectionHandler.isRowSelected(holder.getAdapterPosition())) {
            viewHolder.m_jRecyclerView.setSelected(AbstractViewHolder.SelectionState.SELECTED, this.m_iTableAdapter.getTableView().getSelectedColor(), this.m_iTableAdapter.getTableView().isIgnoreSelectionColors());
        }
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        ((CellRowViewHolder)holder).m_jRecyclerView.setSelected(AbstractViewHolder.SelectionState.UNSELECTED, this.m_iTableAdapter.getTableView().getUnSelectedColor(), this.m_iTableAdapter.getTableView().isIgnoreSelectionColors());
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        super.onViewRecycled(holder);
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        viewHolder.m_jRecyclerView.clearScrolledX();
    }

    public void notifyCellDataSetChanged() {
        CellRecyclerView[] visibleRecyclerViews = this.m_iTableAdapter.getTableView().getCellLayoutManager().getVisibleCellRowRecyclerViews();
        if (visibleRecyclerViews.length > 0) {
            for (CellRecyclerView cellRowRecyclerView : visibleRecyclerViews) {
                cellRowRecyclerView.getAdapter().notifyDataSetChanged();
            }
        } else {
            this.notifyDataSetChanged();
        }
    }

    public List<C> getColumnItems(int columnPosition) {
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            List rowList = (List)this.mItemList.get(i);
            if (rowList.size() <= columnPosition) continue;
            cellItems.add(rowList.get(columnPosition));
        }
        return cellItems;
    }

    public void removeColumnItems(int column) {
        CellRecyclerView[] visibleRecyclerViews;
        for (CellRecyclerView cellRowRecyclerView : visibleRecyclerViews = this.m_iTableAdapter.getTableView().getCellLayoutManager().getVisibleCellRowRecyclerViews()) {
            ((AbstractRecyclerViewAdapter)cellRowRecyclerView.getAdapter()).deleteItem(column);
        }
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            ArrayList rowList = new ArrayList((List)this.mItemList.get(i));
            if (rowList.size() > column) {
                rowList.remove(column);
            }
            cellItems.add(rowList);
        }
        this.setItems(cellItems, false);
    }

    public void addColumnItems(int column, List<C> pCellItems) {
        if (pCellItems.size() != this.mItemList.size() || pCellItems.contains(null)) {
            return;
        }
        CellLayoutManager layoutManager = this.m_iTableAdapter.getTableView().getCellLayoutManager();
        for (int i = layoutManager.findFirstVisibleItemPosition(); i < layoutManager.findLastVisibleItemPosition() + 1; ++i) {
            RecyclerView cellRowRecyclerView = (RecyclerView)layoutManager.findViewByPosition(i);
            ((AbstractRecyclerViewAdapter)cellRowRecyclerView.getAdapter()).addItem(column, pCellItems.get(i));
        }
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            ArrayList<C> rowList = new ArrayList<C>((List)this.mItemList.get(i));
            if (rowList.size() > column) {
                rowList.add(column, pCellItems.get(i));
            }
            cellItems.add(rowList);
        }
        this.setItems(cellItems, false);
    }

    static class CellRowViewHolder
    extends RecyclerView.ViewHolder {
        final CellRecyclerView m_jRecyclerView;

        CellRowViewHolder(View itemView) {
            super(itemView);
            this.m_jRecyclerView = (CellRecyclerView)itemView;
        }
    }
}

