/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.layoutmanager;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.util.SparseArray;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.util.TableViewUtils;

public class ColumnHeaderLayoutManager
extends LinearLayoutManager {
    private SparseArray<Integer> m_aWidthList = new SparseArray();
    private ITableView m_iTableView;

    public ColumnHeaderLayoutManager(Context context, ITableView p_iTableView) {
        super(context);
        this.m_iTableView = p_iTableView;
        this.setOrientation(0);
    }

    public void measureChildWithMargins(View child, int widthUsed, int heightUsed) {
        super.measureChildWithMargins(child, widthUsed, heightUsed);
        if (this.m_iTableView.hasFixedWidth()) {
            return;
        }
        this.measureChild(child, widthUsed, heightUsed);
    }

    public void measureChild(View child, int widthUsed, int heightUsed) {
        if (this.m_iTableView.hasFixedWidth()) {
            super.measureChild(child, widthUsed, heightUsed);
            return;
        }
        int nPosition = this.getPosition(child);
        int nCacheWidth = this.getCacheWidth(nPosition);
        if (nCacheWidth != -1) {
            TableViewUtils.setWidth(child, nCacheWidth);
        } else {
            super.measureChild(child, widthUsed, heightUsed);
        }
    }

    public void setCacheWidth(int p_nPosition, int p_nWidth) {
        this.m_aWidthList.put(p_nPosition, (Object)p_nWidth);
    }

    public int getCacheWidth(int p_nPosition) {
        Integer nCachedWidth = (Integer)this.m_aWidthList.get(p_nPosition);
        if (nCachedWidth != null) {
            return (Integer)this.m_aWidthList.get(p_nPosition);
        }
        return -1;
    }

    public int getFirstItemLeft() {
        View firstColumnHeader = this.findViewByPosition(this.findFirstVisibleItemPosition());
        return firstColumnHeader.getLeft();
    }

    public void removeCachedWidth(int p_nPosition) {
        this.m_aWidthList.remove(p_nPosition);
    }

    public void customRequestLayout() {
        int nLeft = this.getFirstItemLeft();
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            int nRight = nLeft + this.getCacheWidth(i);
            View columnHeader = this.findViewByPosition(i);
            columnHeader.setLeft(nLeft);
            columnHeader.setRight(nRight);
            this.layoutDecoratedWithMargins(columnHeader, columnHeader.getLeft(), columnHeader.getTop(), columnHeader.getRight(), columnHeader.getBottom());
            nLeft = nRight + 1;
        }
    }
}

