/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.sort.ColumnSortCallback;
import com.evrencoskun.tableview.sort.ColumnSortComparator;
import com.evrencoskun.tableview.sort.ITableViewComparator;
import com.evrencoskun.tableview.sort.SortOrder;
import java.util.Collections;
import java.util.List;

public class ColumnSortHandler {
    private CellRecyclerViewAdapter m_iCellRecyclerViewAdapter;
    private RowHeaderRecyclerViewAdapter m_iRowHeaderRecyclerViewAdapter;

    public ColumnSortHandler(ITableView p_iTableView) {
        this.m_iCellRecyclerViewAdapter = (CellRecyclerViewAdapter)p_iTableView.getCellRecyclerView().getAdapter();
        this.m_iRowHeaderRecyclerViewAdapter = (RowHeaderRecyclerViewAdapter)p_iTableView.getRowHeaderRecyclerView().getAdapter();
    }

    public void sort(int p_nXPosition, SortOrder p_nSortOrder) {
        List<List<ITableViewComparator>> m_jOriginalList;
        List<List<ITableViewComparator>> m_jSortedList = m_jOriginalList = this.m_iCellRecyclerViewAdapter.getItems();
        if (p_nSortOrder != SortOrder.UNSORTED) {
            Collections.sort(m_jSortedList, new ColumnSortComparator(p_nXPosition, p_nSortOrder));
        }
        this.swapItems(m_jSortedList, p_nXPosition);
    }

    public void swapItems(List<List<ITableViewComparator>> m_jNewItems, int p_nXPosition) {
        ColumnSortCallback diffCallback = new ColumnSortCallback(this.m_iCellRecyclerViewAdapter.getItems(), m_jNewItems, p_nXPosition);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
        this.m_iCellRecyclerViewAdapter.setItems(m_jNewItems, false);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.m_iCellRecyclerViewAdapter);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.m_iRowHeaderRecyclerViewAdapter);
    }
}

