/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import java.util.List;

public class RowHeaderRecyclerViewAdapter<RH>
extends AbstractRecyclerViewAdapter<RH> {
    private ITableAdapter m_iTableAdapter;

    public RowHeaderRecyclerViewAdapter(Context context, List<RH> p_jItemList, ITableAdapter p_iTableAdapter) {
        super(context, p_jItemList);
        this.m_iTableAdapter = p_iTableAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.m_iTableAdapter.onCreateRowHeaderViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        Object value = this.getItem(position);
        this.m_iTableAdapter.onBindRowHeaderViewHolder(viewHolder, value, position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.m_iTableAdapter.getRowHeaderItemViewType(position);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        boolean isSelected = this.m_iTableAdapter.getTableView().getSelectionHandler().isRowSelected(holder.getAdapterPosition());
        if (!this.m_iTableAdapter.getTableView().IsIgnoreSelectionColors()) {
            this.m_iTableAdapter.getTableView().getSelectionHandler().changeRowBackgroundColorBySelectionStatus(holder.getAdapterPosition(), viewHolder);
        }
        viewHolder.setSelected(isSelected);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        if (!this.m_iTableAdapter.getTableView().IsIgnoreSelectionColors()) {
            viewHolder.setBackgroundColor(this.m_iTableAdapter.getTableView().getUnSelectedColor());
        }
        viewHolder.setSelected(false);
    }
}

