/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.sort;

import androidx.annotation.NonNull;
import com.evrencoskun.tableview.sort.ColumnSortComparator;
import com.evrencoskun.tableview.sort.ISortableModel;
import com.evrencoskun.tableview.sort.SortState;
import java.util.Comparator;
import java.util.List;

public class ColumnForRowHeaderSortComparator
implements Comparator<ISortableModel> {
    @NonNull
    private List<ISortableModel> mRowHeaderList;
    @NonNull
    private List<List<ISortableModel>> mReferenceList;
    private int column;
    @NonNull
    private SortState mSortState;
    @NonNull
    private ColumnSortComparator mColumnSortComparator;

    public ColumnForRowHeaderSortComparator(@NonNull List<ISortableModel> rowHeader, @NonNull List<List<ISortableModel>> referenceList, int column, @NonNull SortState sortState) {
        this.mRowHeaderList = rowHeader;
        this.mReferenceList = referenceList;
        this.column = column;
        this.mSortState = sortState;
        this.mColumnSortComparator = new ColumnSortComparator(column, sortState);
    }

    @Override
    public int compare(ISortableModel o, ISortableModel t1) {
        Object o1 = this.mReferenceList.get(this.mRowHeaderList.indexOf(o)).get(this.column).getContent();
        Object o2 = this.mReferenceList.get(this.mRowHeaderList.indexOf(t1)).get(this.column).getContent();
        if (this.mSortState == SortState.DESCENDING) {
            return this.mColumnSortComparator.compareContent(o2, o1);
        }
        return this.mColumnSortComparator.compareContent(o1, o2);
    }
}

