/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.listener.itemclick.AbstractItemClickListener;

public class ColumnHeaderRecyclerViewItemClickListener
extends AbstractItemClickListener {
    public ColumnHeaderRecyclerViewItemClickListener(@NonNull CellRecyclerView recyclerView, @NonNull ITableView tableView) {
        super(recyclerView, tableView);
    }

    @Override
    protected boolean clickAction(@NonNull RecyclerView view, @NonNull MotionEvent e) {
        View childView = view.findChildViewUnder(e.getX(), e.getY());
        if (childView != null) {
            AbstractViewHolder holder = (AbstractViewHolder)this.mRecyclerView.getChildViewHolder(childView);
            int column = holder.getAdapterPosition();
            if (!this.mTableView.isIgnoreSelectionColors()) {
                this.mSelectionHandler.setSelectedColumnPosition(holder, column);
            }
            this.getTableViewListener().onColumnHeaderClicked(holder, column);
            return true;
        }
        return false;
    }

    @Override
    protected void longPressAction(@NonNull MotionEvent e) {
        if (this.mRecyclerView.getScrollState() != 0) {
            return;
        }
        View child = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
        if (child != null) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(child);
            this.getTableViewListener().onColumnHeaderLongPressed(holder, holder.getAdapterPosition());
        }
    }
}

