/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.evrencoskun.tableview.ITableView;
import java.util.List;

public class VisibilityHandler {
    private static final String LOG_TAG = VisibilityHandler.class.getSimpleName();
    @NonNull
    private ITableView mTableView;
    @NonNull
    private SparseArray<Row> mHideRowList = new SparseArray();
    @NonNull
    private SparseArray<Column> mHideColumnList = new SparseArray();

    public VisibilityHandler(@NonNull ITableView tableView) {
        this.mTableView = tableView;
    }

    public void hideRow(int row) {
        this.mHideRowList.put(row, (Object)this.getRowValueFromPosition(row));
        this.mTableView.getAdapter().removeRow(row);
    }

    public void showRow(int row) {
        this.showRow(row, true);
    }

    private void showRow(int row, boolean removeFromList) {
        Row hiddenRow = (Row)this.mHideRowList.get(row);
        if (hiddenRow != null) {
            this.mTableView.getAdapter().addRow(row, hiddenRow.getRowHeaderModel(), hiddenRow.getCellModelList());
        } else {
            Log.e((String)LOG_TAG, (String)"This row is already visible.");
        }
        if (removeFromList) {
            this.mHideRowList.remove(row);
        }
    }

    public void clearHideRowList() {
        this.mHideRowList.clear();
    }

    public void showAllHiddenRows() {
        for (int i = 0; i < this.mHideRowList.size(); ++i) {
            int row = this.mHideRowList.keyAt(i);
            this.showRow(row, false);
        }
        this.clearHideRowList();
    }

    public boolean isRowVisible(int row) {
        return this.mHideRowList.get(row) == null;
    }

    public void hideColumn(int column) {
        this.mHideColumnList.put(column, (Object)this.getColumnValueFromPosition(column));
        this.mTableView.getAdapter().removeColumn(column);
    }

    public void showColumn(int column) {
        this.showColumn(column, true);
    }

    private void showColumn(int column, boolean removeFromList) {
        Column hiddenColumn = (Column)this.mHideColumnList.get(column);
        if (hiddenColumn != null) {
            this.mTableView.getAdapter().addColumn(column, hiddenColumn.getColumnHeaderModel(), hiddenColumn.getCellModelList());
        } else {
            Log.e((String)LOG_TAG, (String)"This column is already visible.");
        }
        if (removeFromList) {
            this.mHideColumnList.remove(column);
        }
    }

    public void clearHideColumnList() {
        this.mHideColumnList.clear();
    }

    public void showAllHiddenColumns() {
        for (int i = 0; i < this.mHideColumnList.size(); ++i) {
            int column = this.mHideColumnList.keyAt(i);
            this.showColumn(column, false);
        }
        this.clearHideColumnList();
    }

    public boolean isColumnVisible(int column) {
        return this.mHideColumnList.get(column) == null;
    }

    @NonNull
    private Row getRowValueFromPosition(int row) {
        Object rowHeaderModel = this.mTableView.getAdapter().getRowHeaderItem(row);
        List<Object> cellModelList = this.mTableView.getAdapter().getCellRowItems(row);
        return new Row(row, rowHeaderModel, cellModelList);
    }

    @NonNull
    private Column getColumnValueFromPosition(int column) {
        Object columnHeaderModel = this.mTableView.getAdapter().getColumnHeaderItem(column);
        List<Object> cellModelList = this.mTableView.getAdapter().getCellColumnItems(column);
        return new Column(column, columnHeaderModel, cellModelList);
    }

    @NonNull
    public SparseArray<Row> getHideRowList() {
        return this.mHideRowList;
    }

    @NonNull
    public SparseArray<Column> getHideColumnList() {
        return this.mHideColumnList;
    }

    public void setHideRowList(@NonNull SparseArray<Row> rowList) {
        this.mHideRowList = rowList;
    }

    public void setHideColumnList(@NonNull SparseArray<Column> columnList) {
        this.mHideColumnList = columnList;
    }

    static class Column {
        private int mYPosition;
        @Nullable
        private Object mColumnHeaderModel;
        @NonNull
        private List<Object> mCellModelList;

        public Column(int yPosition, @Nullable Object columnHeaderModel, @NonNull List<Object> cellModelList) {
            this.mYPosition = yPosition;
            this.mColumnHeaderModel = columnHeaderModel;
            this.mCellModelList = cellModelList;
        }

        public int getYPosition() {
            return this.mYPosition;
        }

        @Nullable
        public Object getColumnHeaderModel() {
            return this.mColumnHeaderModel;
        }

        @NonNull
        public List<Object> getCellModelList() {
            return this.mCellModelList;
        }
    }

    static class Row {
        private int mYPosition;
        @Nullable
        private Object mRowHeaderModel;
        @Nullable
        private List<Object> mCellModelList;

        public Row(int row, @Nullable Object rowHeaderModel, @Nullable List<Object> cellModelList) {
            this.mYPosition = row;
            this.mRowHeaderModel = rowHeaderModel;
            this.mCellModelList = cellModelList;
        }

        public int getYPosition() {
            return this.mYPosition;
        }

        @Nullable
        public Object getRowHeaderModel() {
            return this.mRowHeaderModel;
        }

        @Nullable
        public List<Object> getCellModelList() {
            return this.mCellModelList;
        }
    }
}

