/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.ColumnHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.sort.ColumnForRowHeaderSortComparator;
import com.evrencoskun.tableview.sort.ColumnSortCallback;
import com.evrencoskun.tableview.sort.ColumnSortComparator;
import com.evrencoskun.tableview.sort.ColumnSortStateChangedListener;
import com.evrencoskun.tableview.sort.ISortableModel;
import com.evrencoskun.tableview.sort.RowHeaderForCellSortComparator;
import com.evrencoskun.tableview.sort.RowHeaderSortCallback;
import com.evrencoskun.tableview.sort.RowHeaderSortComparator;
import com.evrencoskun.tableview.sort.SortState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ColumnSortHandler {
    private CellRecyclerViewAdapter<List<ISortableModel>> mCellRecyclerViewAdapter;
    private RowHeaderRecyclerViewAdapter<ISortableModel> mRowHeaderRecyclerViewAdapter;
    private ColumnHeaderRecyclerViewAdapter mColumnHeaderRecyclerViewAdapter;
    private List<ColumnSortStateChangedListener> columnSortStateChangedListeners = new ArrayList<ColumnSortStateChangedListener>();
    private boolean mEnableAnimation = true;

    public boolean isEnableAnimation() {
        return this.mEnableAnimation;
    }

    public void setEnableAnimation(boolean mEnableAnimation) {
        this.mEnableAnimation = mEnableAnimation;
    }

    public ColumnSortHandler(@NonNull ITableView tableView) {
        this.mCellRecyclerViewAdapter = (CellRecyclerViewAdapter)tableView.getCellRecyclerView().getAdapter();
        this.mRowHeaderRecyclerViewAdapter = (RowHeaderRecyclerViewAdapter)tableView.getRowHeaderRecyclerView().getAdapter();
        this.mColumnHeaderRecyclerViewAdapter = (ColumnHeaderRecyclerViewAdapter)tableView.getColumnHeaderRecyclerView().getAdapter();
    }

    public void sortByRowHeader(@NonNull SortState sortState) {
        List<ISortableModel> originalRowHeaderList = this.mRowHeaderRecyclerViewAdapter.getItems();
        ArrayList<ISortableModel> sortedRowHeaderList = new ArrayList<ISortableModel>(originalRowHeaderList);
        List<List<ISortableModel>> originalList = this.mCellRecyclerViewAdapter.getItems();
        ArrayList<List<ISortableModel>> sortedList = new ArrayList<List<ISortableModel>>(originalList);
        if (sortState != SortState.UNSORTED) {
            Collections.sort(sortedRowHeaderList, new RowHeaderSortComparator(sortState));
            RowHeaderForCellSortComparator rowHeaderForCellSortComparator = new RowHeaderForCellSortComparator(originalRowHeaderList, originalList, sortState);
            Collections.sort(sortedList, rowHeaderForCellSortComparator);
        }
        this.mRowHeaderRecyclerViewAdapter.getRowHeaderSortHelper().setSortingStatus(sortState);
        this.swapItems(originalRowHeaderList, sortedRowHeaderList, sortedList, sortState);
    }

    public void sort(int column, @NonNull SortState sortState) {
        List<List<ISortableModel>> originalList = this.mCellRecyclerViewAdapter.getItems();
        ArrayList<List<ISortableModel>> sortedList = new ArrayList<List<ISortableModel>>(originalList);
        List<ISortableModel> originalRowHeaderList = this.mRowHeaderRecyclerViewAdapter.getItems();
        ArrayList<ISortableModel> sortedRowHeaderList = new ArrayList<ISortableModel>(originalRowHeaderList);
        if (sortState != SortState.UNSORTED) {
            Collections.sort(sortedList, new ColumnSortComparator(column, sortState));
            ColumnForRowHeaderSortComparator columnForRowHeaderSortComparator = new ColumnForRowHeaderSortComparator(originalRowHeaderList, originalList, column, sortState);
            Collections.sort(sortedRowHeaderList, columnForRowHeaderSortComparator);
        }
        this.mColumnHeaderRecyclerViewAdapter.getColumnSortHelper().setSortingStatus(column, sortState);
        this.swapItems(originalList, sortedList, column, sortedRowHeaderList, sortState);
    }

    private void swapItems(@NonNull List<ISortableModel> oldRowHeader, @NonNull List<ISortableModel> newRowHeader, @NonNull List<List<ISortableModel>> newColumnItems, @NonNull SortState sortState) {
        this.mRowHeaderRecyclerViewAdapter.setItems(newRowHeader, !this.mEnableAnimation);
        this.mCellRecyclerViewAdapter.setItems(newColumnItems, !this.mEnableAnimation);
        if (this.mEnableAnimation) {
            RowHeaderSortCallback diffCallback = new RowHeaderSortCallback(oldRowHeader, newRowHeader);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
            diffResult.dispatchUpdatesTo(this.mRowHeaderRecyclerViewAdapter);
            diffResult.dispatchUpdatesTo(this.mCellRecyclerViewAdapter);
        }
        for (ColumnSortStateChangedListener listener : this.columnSortStateChangedListeners) {
            listener.onRowHeaderSortStatusChanged(sortState);
        }
    }

    private void swapItems(@NonNull List<List<ISortableModel>> oldItems, @NonNull List<List<ISortableModel>> newItems, int column, @NonNull List<ISortableModel> newRowHeader, @NonNull SortState sortState) {
        this.mCellRecyclerViewAdapter.setItems(newItems, !this.mEnableAnimation);
        this.mRowHeaderRecyclerViewAdapter.setItems(newRowHeader, !this.mEnableAnimation);
        if (this.mEnableAnimation) {
            ColumnSortCallback diffCallback = new ColumnSortCallback(oldItems, newItems, column);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
            diffResult.dispatchUpdatesTo(this.mCellRecyclerViewAdapter);
            diffResult.dispatchUpdatesTo(this.mRowHeaderRecyclerViewAdapter);
        }
        for (ColumnSortStateChangedListener listener : this.columnSortStateChangedListeners) {
            listener.onColumnSortStatusChanged(column, sortState);
        }
    }

    public void swapItems(@NonNull List<List<ISortableModel>> newItems, int column) {
        List<List<ISortableModel>> oldItems = this.mCellRecyclerViewAdapter.getItems();
        this.mCellRecyclerViewAdapter.setItems(newItems, !this.mEnableAnimation);
        if (this.mEnableAnimation) {
            ColumnSortCallback diffCallback = new ColumnSortCallback(oldItems, newItems, column);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
            diffResult.dispatchUpdatesTo(this.mCellRecyclerViewAdapter);
            diffResult.dispatchUpdatesTo(this.mRowHeaderRecyclerViewAdapter);
        }
    }

    @NonNull
    public SortState getSortingStatus(int column) {
        return this.mColumnHeaderRecyclerViewAdapter.getColumnSortHelper().getSortingStatus(column);
    }

    @Nullable
    public SortState getRowHeaderSortingStatus() {
        return this.mRowHeaderRecyclerViewAdapter.getRowHeaderSortHelper().getSortingStatus();
    }

    public void addColumnSortStateChangedListener(@NonNull ColumnSortStateChangedListener listener) {
        if (this.columnSortStateChangedListeners == null) {
            this.columnSortStateChangedListeners = new ArrayList<ColumnSortStateChangedListener>();
        }
        this.columnSortStateChangedListeners.add(listener);
    }
}

