/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.sort;

import android.support.v7.util.DiffUtil;
import com.evrencoskun.tableview.sort.ISortableModel;
import java.util.List;

public class RowHeaderSortCallback
extends DiffUtil.Callback {
    private static final String LOG_TAG = RowHeaderSortCallback.class.getSimpleName();
    private List<ISortableModel> mOldCellItems;
    private List<ISortableModel> mNewCellItems;

    public RowHeaderSortCallback(List<ISortableModel> oldCellItems, List<ISortableModel> newCellItems) {
        this.mOldCellItems = oldCellItems;
        this.mNewCellItems = newCellItems;
    }

    public int getOldListSize() {
        return this.mOldCellItems.size();
    }

    public int getNewListSize() {
        return this.mNewCellItems.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        if (this.mOldCellItems.size() > oldItemPosition && this.mNewCellItems.size() > newItemPosition) {
            String oldId = this.mOldCellItems.get(oldItemPosition).getId();
            String newId = this.mNewCellItems.get(newItemPosition).getId();
            return oldId.equals(newId);
        }
        return false;
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        if (this.mOldCellItems.size() > oldItemPosition && this.mNewCellItems.size() > newItemPosition) {
            Object oldContent = this.mOldCellItems.get(oldItemPosition).getContent();
            Object newContent = this.mNewCellItems.get(newItemPosition).getContent();
            return oldContent.equals(newContent);
        }
        return false;
    }
}

