/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.sort.RowHeaderSortHelper;
import java.util.List;

public class RowHeaderRecyclerViewAdapter<RH>
extends AbstractRecyclerViewAdapter<RH> {
    private ITableAdapter mTableAdapter;
    private ITableView mTableView;
    private RowHeaderSortHelper mRowHeaderSortHelper;

    public RowHeaderRecyclerViewAdapter(Context context, List<RH> itemList, ITableAdapter tableAdapter) {
        super(context, itemList);
        this.mTableAdapter = tableAdapter;
        this.mTableView = tableAdapter.getTableView();
    }

    public AbstractViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.mTableAdapter.onCreateRowHeaderViewHolder(parent, viewType);
    }

    public void onBindViewHolder(AbstractViewHolder holder, int position) {
        this.mTableAdapter.onBindRowHeaderViewHolder(holder, this.getItem(position), position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.mTableAdapter.getRowHeaderItemViewType(position);
    }

    public void onViewAttachedToWindow(AbstractViewHolder viewHolder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)viewHolder);
        AbstractViewHolder.SelectionState selectionState = this.mTableView.getSelectionHandler().getRowSelectionState(viewHolder.getAdapterPosition());
        if (!this.mTableView.isIgnoreSelectionColors()) {
            this.mTableView.getSelectionHandler().changeRowBackgroundColorBySelectionStatus(viewHolder, selectionState);
        }
        viewHolder.setSelected(selectionState);
    }

    public RowHeaderSortHelper getRowHeaderSortHelper() {
        if (this.mRowHeaderSortHelper == null) {
            this.mRowHeaderSortHelper = new RowHeaderSortHelper();
        }
        return this.mRowHeaderSortHelper;
    }
}

