/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.scroll;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.MotionEvent;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.listener.scroll.VerticalRecyclerViewListener;

public class HorizontalRecyclerViewListener
extends RecyclerView.OnScrollListener
implements RecyclerView.OnItemTouchListener {
    private static final String LOG_TAG = HorizontalRecyclerViewListener.class.getSimpleName();
    private CellRecyclerView mColumnHeaderRecyclerView;
    private RecyclerView.LayoutManager mCellLayoutManager;
    private RecyclerView mLastTouchedRecyclerView;
    private int mXPosition;
    private boolean mIsMoved;
    private int mScrollPosition;
    private int mScrollPositionOffset = 0;
    private VerticalRecyclerViewListener mVerticalRecyclerViewListener;

    public HorizontalRecyclerViewListener(ITableView tableView) {
        this.mColumnHeaderRecyclerView = tableView.getColumnHeaderRecyclerView();
        this.mCellLayoutManager = tableView.getCellRecyclerView().getLayoutManager();
        this.mVerticalRecyclerViewListener = tableView.getVerticalRecyclerViewListener();
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
        if (e.getAction() == 0) {
            if (rv.getScrollState() == 0) {
                if (this.mLastTouchedRecyclerView != null && rv != this.mLastTouchedRecyclerView) {
                    if (this.mLastTouchedRecyclerView == this.mColumnHeaderRecyclerView) {
                        this.mColumnHeaderRecyclerView.removeOnScrollListener(this);
                        this.mColumnHeaderRecyclerView.stopScroll();
                        Log.d((String)LOG_TAG, (String)"Scroll listener  has been removed to mColumnHeaderRecyclerView at last touch control");
                    } else {
                        int lastTouchedIndex = this.getIndex(this.mLastTouchedRecyclerView);
                        if (lastTouchedIndex >= 0 && lastTouchedIndex < this.mCellLayoutManager.getChildCount() && !((CellRecyclerView)this.mLastTouchedRecyclerView).isHorizontalScrollListenerRemoved()) {
                            ((RecyclerView)this.mCellLayoutManager.getChildAt(lastTouchedIndex)).removeOnScrollListener((RecyclerView.OnScrollListener)this);
                            Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + this.mLastTouchedRecyclerView.getId() + " CellRecyclerView at last touch control"));
                            ((RecyclerView)this.mCellLayoutManager.getChildAt(lastTouchedIndex)).stopScroll();
                        }
                    }
                }
                this.mXPosition = ((CellRecyclerView)rv).getScrolledX();
                rv.addOnScrollListener((RecyclerView.OnScrollListener)this);
                Log.d((String)LOG_TAG, (String)("Scroll listener  has been added to " + rv.getId() + " at action down"));
            }
        } else if (e.getAction() == 2) {
            this.mIsMoved = true;
        } else if (e.getAction() == 1) {
            int nScrollX = ((CellRecyclerView)rv).getScrolledX();
            if (this.mXPosition == nScrollX && !this.mIsMoved) {
                rv.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + rv.getId() + " at action up"));
            }
            this.mLastTouchedRecyclerView = rv;
        } else if (e.getAction() == 3) {
            this.renewScrollPosition(rv);
            rv.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            Log.d((String)LOG_TAG, (String)("Scroll listener  has been removed to " + rv.getId() + " at action cancel"));
            this.mIsMoved = false;
            this.mLastTouchedRecyclerView = rv;
        }
        return false;
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent e) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        if (recyclerView == this.mColumnHeaderRecyclerView) {
            super.onScrolled(recyclerView, dx, dy);
            for (int i = 0; i < this.mCellLayoutManager.getChildCount(); ++i) {
                CellRecyclerView child = (CellRecyclerView)this.mCellLayoutManager.getChildAt(i);
                child.scrollBy(dx, 0);
            }
        } else {
            super.onScrolled(recyclerView, dx, dy);
            for (int i = 0; i < this.mCellLayoutManager.getChildCount(); ++i) {
                CellRecyclerView child = (CellRecyclerView)this.mCellLayoutManager.getChildAt(i);
                if (child == recyclerView) continue;
                child.scrollBy(dx, 0);
            }
        }
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        if (newState == 0) {
            this.renewScrollPosition(recyclerView);
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            Log.d((String)LOG_TAG, (String)("Scroll listener has been removed to " + recyclerView.getId() + " at onScrollStateChanged"));
            this.mIsMoved = false;
            boolean isNeeded = this.mLastTouchedRecyclerView != this.mColumnHeaderRecyclerView;
            this.mVerticalRecyclerViewListener.removeLastTouchedRecyclerViewScrollListener(isNeeded);
        }
    }

    private int getIndex(RecyclerView rv) {
        for (int i = 0; i < this.mCellLayoutManager.getChildCount(); ++i) {
            RecyclerView child = (RecyclerView)this.mCellLayoutManager.getChildAt(i);
            if (child != rv) continue;
            return i;
        }
        return -1;
    }

    private void renewScrollPosition(RecyclerView recyclerView) {
        LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
        this.mScrollPosition = layoutManager.findFirstCompletelyVisibleItemPosition();
        if (this.mScrollPosition == -1) {
            this.mScrollPosition = layoutManager.findFirstVisibleItemPosition();
            if (layoutManager.findFirstVisibleItemPosition() != layoutManager.findLastVisibleItemPosition()) {
                ++this.mScrollPosition;
            }
        }
        this.mScrollPositionOffset = recyclerView.getLayoutManager().findViewByPosition(this.mScrollPosition).getLeft();
    }

    public int getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionOffset() {
        return this.mScrollPositionOffset;
    }

    public void setScrollPositionOffset(int offset) {
        this.mScrollPositionOffset = offset;
    }

    public void setScrollPosition(int position) {
        this.mScrollPosition = position;
    }
}

