/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java8.util.Objects;
import java8.util.Optional;
import java8.util.function.Consumer;
import java8.util.function.Function;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonObjectIterator;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.ProjectedJsonObject$$Lambda$1;
import org.everit.json.schema.loader.ProjectedJsonObject$$Lambda$2;

class ProjectedJsonObject
extends JsonObject {
    private final JsonObject original;
    private final Set<String> hiddenKeys;

    ProjectedJsonObject(JsonObject original, Set<String> hiddenKeys) {
        super(Collections.<String, Object>emptyMap());
        this.ls = original.ls;
        this.original = (JsonObject)Objects.requireNonNull((Object)original, (String)"original cannot be null");
        this.hiddenKeys = (Set)Objects.requireNonNull(hiddenKeys, (String)"hiddenKeys cannot be null");
    }

    @Override
    JsonValue childFor(String key) {
        return this.original.childFor(key);
    }

    @Override
    boolean containsKey(String key) {
        return this.isVisibleKey(key) && this.original.containsKey(key);
    }

    private boolean isVisibleKey(String key) {
        return !this.hiddenKeys.contains(key);
    }

    @Override
    void require(String key, Consumer<JsonValue> consumer) {
        this.throwExceptionIfNotVisible(key);
        this.original.require(key, consumer);
    }

    private void throwExceptionIfNotVisible(String key) {
        if (!this.isVisibleKey(key)) {
            throw this.ls.createSchemaException(String.format("required key [%s] not found", key));
        }
    }

    @Override
    JsonValue require(String key) {
        this.throwExceptionIfNotVisible(key);
        return this.original.require(key);
    }

    @Override
    <R> R requireMapping(String key, Function<JsonValue, R> fn) {
        this.throwExceptionIfNotVisible(key);
        return this.original.requireMapping(key, fn);
    }

    @Override
    void maybe(String key, Consumer<JsonValue> consumer) {
        if (this.isVisibleKey(key)) {
            this.original.maybe(key, consumer);
        }
    }

    @Override
    Optional<JsonValue> maybe(String key) {
        if (this.isVisibleKey(key)) {
            return this.original.maybe(key);
        }
        return Optional.empty();
    }

    @Override
    <R> Optional<R> maybeMapping(String key, Function<JsonValue, R> fn) {
        if (this.isVisibleKey(key)) {
            return this.original.maybeMapping(key, fn);
        }
        return Optional.empty();
    }

    @Override
    void forEach(JsonObjectIterator iterator) {
        this.original.forEach(ProjectedJsonObject$$Lambda$1.lambdaFactory$(this, iterator));
    }

    @Override
    protected Object unwrap() {
        HashMap<String, Object> storage = new HashMap<String, Object>(this.original.storage);
        this.removeHiddenKeysFrom(storage);
        return storage;
    }

    @Override
    Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.original.toMap());
        this.removeHiddenKeysFrom(map);
        return map;
    }

    private void removeHiddenKeysFrom(Map<String, Object> map) {
        Map<String, Object> map2 = map;
        map2.getClass();
        this.hiddenKeys.forEach(ProjectedJsonObject$$Lambda$2.lambdaFactory$(map2));
    }

    @Override
    boolean isEmpty() {
        Set<String> origKeys = this.original.keySet();
        return this.original.isEmpty() || origKeys.containsAll(this.hiddenKeys) && origKeys.size() == this.hiddenKeys.size();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.original.keySet());
        keys.removeAll(this.hiddenKeys);
        return keys;
    }

    @Override
    public Object get(String name) {
        return super.get(name);
    }

    static /* synthetic */ void lambda$forEach$0(ProjectedJsonObject this_, JsonObjectIterator iterator, String key, JsonValue value) {
        if (this_.isVisibleKey(key)) {
            iterator.apply(key, value);
        }
    }
}

