/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.animation.LinearInterpolator;
import androidx.annotation.RequiresApi;
import androidx.appcompat.widget.AppCompatImageView;
import com.jiangdg.ausbc.utils.Logger;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 U2\u00020\u0001:\u0003STUB\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\b\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\nH\u0002J\u0018\u00106\u001a\u0002022\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\nH\u0002J(\u00107\u001a\u0002022\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\nH\u0014J\u0010\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020<H\u0015J\u0012\u0010=\u001a\u0002022\b\u0010;\u001a\u0004\u0018\u00010<H\u0002J\u0012\u0010>\u001a\u0002022\b\u0010;\u001a\u0004\u0018\u00010<H\u0002J\b\u0010?\u001a\u000202H\u0014J\u0012\u0010@\u001a\u0002022\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\u0006\u0010C\u001a\u000202J\u000e\u0010D\u001a\u0002022\u0006\u0010E\u001a\u00020\rJ\u0010\u0010F\u001a\u0002022\b\b\u0002\u0010G\u001a\u00020\rJ\u0010\u0010H\u001a\u0002022\b\u0010I\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010J\u001a\u0002022\u0006\u0010K\u001a\u00020\u001eJ\b\u0010L\u001a\u000202H\u0002J\b\u0010M\u001a\u00020\rH\u0002J\u0010\u0010N\u001a\u0002022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010O\u001a\u00020\u001aH\u0002J\b\u0010P\u001a\u000202H\u0002J\u0010\u0010Q\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020\u001aH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010,\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006V"}, d2={"Lcom/jiangdg/ausbc/widget/PreviewImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isNewImageLoading", "", "mProgressAnim", "Landroid/animation/ValueAnimator;", "mProgressPath", "Landroid/graphics/Path;", "mProgressPathMeasure", "Landroid/graphics/PathMeasure;", "mProgressDstPath", "mBreathAnimation", "Landroid/animation/ObjectAnimator;", "mPaint", "Landroid/graphics/Paint;", "progress", "", "mListener", "Lcom/jiangdg/ausbc/widget/PreviewImageView$OnLoadingFinishListener;", "mTheme", "Lcom/jiangdg/ausbc/widget/PreviewImageView$Theme;", "mSrcRadii", "", "mBorderRadii", "mBorderRectF", "Landroid/graphics/RectF;", "mSrcRectF", "mTmpPath", "mClipPath", "mXfermode", "Landroid/graphics/PorterDuffXfermode;", "cornerRadius", "borderWidth", "value", "canShowImageBorder", "getCanShowImageBorder", "()Z", "setCanShowImageBorder", "(Z)V", "init", "", "initBorderPath", "w", "h", "initProgressPath", "onSizeChanged", "oldw", "oldh", "onDraw", "canvas", "Landroid/graphics/Canvas;", "drawBorders", "drawBorderProgress", "onDetachedFromWindow", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "cancelAnimation", "setNewImageFlag", "isNewImage", "showImageLoadProgress", "isShowFakeProgress", "setOnLoadingFinishListener", "listener", "setTheme", "theme", "showBreathAnimation", "isAnimationRunning", "setProgress", "getProgress", "updateBorderProgress", "dp2px", "dpValue", "Theme", "OnLoadingFinishListener", "Companion", "libausbc_release"})
public final class PreviewImageView
extends AppCompatImageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isNewImageLoading;
    @Nullable
    private ValueAnimator mProgressAnim;
    private Path mProgressPath;
    private PathMeasure mProgressPathMeasure;
    @Nullable
    private Path mProgressDstPath;
    @Nullable
    private ObjectAnimator mBreathAnimation;
    @NotNull
    private final Paint mPaint;
    private float progress;
    @Nullable
    private OnLoadingFinishListener mListener;
    @NotNull
    private Theme mTheme;
    @NotNull
    private final float[] mSrcRadii;
    @NotNull
    private final float[] mBorderRadii;
    @NotNull
    private final RectF mBorderRectF;
    @NotNull
    private final RectF mSrcRectF;
    @NotNull
    private Path mTmpPath;
    @NotNull
    private final Path mClipPath;
    private PorterDuffXfermode mXfermode;
    private final float cornerRadius;
    private final float borderWidth;
    private boolean canShowImageBorder;
    @NotNull
    private static final String TAG = "PreviewImageView";

    public final boolean getCanShowImageBorder() {
        return this.canShowImageBorder;
    }

    public final void setCanShowImageBorder(boolean value) {
        this.canShowImageBorder = value;
        this.postInvalidate();
    }

    public PreviewImageView(@Nullable Context context) {
        this(context, null);
    }

    public PreviewImageView(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PreviewImageView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        super(context2, attrs, defStyleAttr);
        this.mPaint = new Paint();
        this.mTheme = Theme.LIGHT;
        this.mSrcRadii = new float[8];
        this.mBorderRadii = new float[8];
        this.mBorderRectF = new RectF();
        this.mSrcRectF = new RectF();
        this.mTmpPath = new Path();
        this.mClipPath = new Path();
        this.cornerRadius = this.dp2px(5.0f);
        this.borderWidth = this.dp2px(1.0f);
        this.init();
    }

    private final void init() {
        this.mXfermode = Build.VERSION.SDK_INT <= 27 ? new PorterDuffXfermode(PorterDuff.Mode.DST_IN) : new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
        int n = this.mBorderRadii.length;
        for (int i = 0; i < n; ++i) {
            this.mBorderRadii[i] = this.cornerRadius;
            this.mSrcRadii[i] = this.cornerRadius - this.borderWidth / 2.0f;
        }
    }

    private final void initBorderPath(int w, int h) {
        this.mBorderRectF.set(this.borderWidth / 2.0f, this.borderWidth / 2.0f, (float)w - this.borderWidth / 2.0f, (float)h - this.borderWidth / 2.0f);
        this.mSrcRectF.set(0.0f, 0.0f, (float)w, (float)h);
    }

    /*
     * WARNING - void declaration
     */
    private final void initProgressPath(int w, int h) {
        void $this$initProgressPath_u24lambda_u240;
        Path path;
        float radius = this.cornerRadius;
        float p = this.borderWidth / 2.0f;
        RectF rectFLeftTop = new RectF(p, p, p + (float)2 * radius, p + (float)2 * radius);
        RectF rectFRightTop = new RectF((float)w - p - (float)2 * radius, p, (float)w - p, (float)2 * radius + p);
        RectF rectFLeftBottom = new RectF(p, (float)h - p - (float)2 * radius, p + (float)2 * radius, (float)h - p);
        RectF rectFRightBottom = new RectF((float)w - p - (float)2 * radius, (float)h - p - (float)2 * radius, (float)w - p, (float)h - p);
        Path path2 = path = new Path();
        PreviewImageView previewImageView = this;
        boolean bl = false;
        $this$initProgressPath_u24lambda_u240.moveTo((float)w / 2.0f - p, p);
        $this$initProgressPath_u24lambda_u240.lineTo((float)w - radius - p, p);
        $this$initProgressPath_u24lambda_u240.arcTo(rectFRightTop, 270.0f, 90.0f);
        $this$initProgressPath_u24lambda_u240.lineTo((float)w - p, (float)h - p - radius);
        $this$initProgressPath_u24lambda_u240.arcTo(rectFRightBottom, 0.0f, 90.0f);
        $this$initProgressPath_u24lambda_u240.lineTo(p + radius, (float)h - p);
        $this$initProgressPath_u24lambda_u240.arcTo(rectFLeftBottom, 90.0f, 90.0f);
        $this$initProgressPath_u24lambda_u240.lineTo(p, p + radius);
        $this$initProgressPath_u24lambda_u240.arcTo(rectFLeftTop, 180.0f, 90.0f);
        $this$initProgressPath_u24lambda_u240.lineTo((float)w / 2.0f - p, p);
        previewImageView.mProgressPath = path;
        this.mProgressDstPath = new Path();
        Path path3 = this.mProgressPath;
        if (path3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mProgressPath");
            path3 = null;
        }
        this.mProgressPathMeasure = new PathMeasure(path3, true);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initProgressPath(w, h);
        this.initBorderPath(w, h);
    }

    @RequiresApi(value=21)
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        try {
            canvas.saveLayer(this.mSrcRectF, null);
            super.onDraw(canvas);
            this.mPaint.reset();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(Color.parseColor((String)"#FFFFFF"));
            PorterDuffXfermode porterDuffXfermode = this.mXfermode;
            if (porterDuffXfermode == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mXfermode");
                porterDuffXfermode = null;
            }
            this.mPaint.setXfermode((Xfermode)porterDuffXfermode);
            this.mClipPath.reset();
            this.mClipPath.addRoundRect(this.mSrcRectF, this.mSrcRadii, Path.Direction.CCW);
            if (Build.VERSION.SDK_INT <= 27) {
                canvas.drawPath(this.mClipPath, this.mPaint);
            } else {
                this.mTmpPath.reset();
                this.mTmpPath.addRect(this.mSrcRectF, Path.Direction.CCW);
                this.mTmpPath.op(this.mClipPath, Path.Op.DIFFERENCE);
                canvas.drawPath(this.mTmpPath, this.mPaint);
            }
            this.mPaint.setXfermode(null);
            canvas.restore();
            this.drawBorders(canvas);
            this.drawBorderProgress(canvas);
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "draw preview image view failed", e);
            e.printStackTrace();
        }
    }

    private final void drawBorders(Canvas canvas) {
        block1: {
            if (this.mTheme == Theme.LIGHT || !this.canShowImageBorder) {
                return;
            }
            this.mClipPath.reset();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStrokeWidth(this.borderWidth);
            this.mPaint.setColor(Color.parseColor((String)"#FFFFFF"));
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mClipPath.addRoundRect(this.mBorderRectF, this.mBorderRadii, Path.Direction.CCW);
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block1;
            canvas2.drawPath(this.mClipPath, this.mPaint);
        }
    }

    private final void drawBorderProgress(Canvas canvas) {
        block2: {
            this.mPaint.reset();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStrokeWidth(this.borderWidth);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setColor(Color.parseColor((String)"#2E5BFF"));
            Path path = this.mProgressDstPath;
            if (path == null) break block2;
            Path it = path;
            boolean bl = false;
            if (!it.isEmpty()) {
                Canvas canvas2 = canvas;
                if (canvas2 != null) {
                    canvas2.drawPath(it, this.mPaint);
                }
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelAnimation();
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        block2: {
            block3: {
                super.setImageDrawable(drawable2);
                Drawable drawable3 = drawable2;
                if (drawable3 == null) break block2;
                Drawable it = drawable3;
                boolean bl = false;
                if (this.isAnimationRunning()) {
                    ValueAnimator valueAnimator = this.mProgressAnim;
                    if (valueAnimator != null) {
                        valueAnimator.cancel();
                    }
                    this.mProgressAnim = null;
                }
                if (!this.isNewImageLoading && this.getProgress() == 0.0f) break block2;
                if (this.mBreathAnimation == null) break block3;
                ObjectAnimator objectAnimator = this.mBreathAnimation;
                boolean bl2 = objectAnimator != null ? !objectAnimator.isRunning() : false;
                if (!bl2) break block2;
            }
            this.showBreathAnimation();
        }
    }

    public final void cancelAnimation() {
        block2: {
            ObjectAnimator objectAnimator = this.mBreathAnimation;
            if (objectAnimator != null) {
                objectAnimator.cancel();
            }
            this.mBreathAnimation = null;
            ValueAnimator valueAnimator = this.mProgressAnim;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            this.mProgressAnim = null;
            this.setProgress(0.0f);
            this.isNewImageLoading = false;
            OnLoadingFinishListener onLoadingFinishListener = this.mListener;
            if (onLoadingFinishListener == null) break block2;
            onLoadingFinishListener.onLoadingFinish();
        }
    }

    public final void setNewImageFlag(boolean isNewImage) {
        this.isNewImageLoading = isNewImage;
    }

    public final void showImageLoadProgress(boolean isShowFakeProgress) {
        block5: {
            if (this.isAnimationRunning()) {
                return;
            }
            if (!isShowFakeProgress) {
                this.showBreathAnimation();
                return;
            }
            float[] fArray = new float[]{0.0f, 0.7f};
            ValueAnimator valueAnimator = this.mProgressAnim = ValueAnimator.ofFloat((float[])fArray);
            if (valueAnimator != null) {
                valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            }
            ValueAnimator valueAnimator2 = this.mProgressAnim;
            if (valueAnimator2 != null) {
                valueAnimator2.setDuration(3000L);
            }
            ValueAnimator valueAnimator3 = this.mProgressAnim;
            if (valueAnimator3 != null) {
                valueAnimator3.addUpdateListener(arg_0 -> PreviewImageView.showImageLoadProgress$lambda$3(this, arg_0));
            }
            ValueAnimator valueAnimator4 = this.mProgressAnim;
            if (valueAnimator4 == null) break block5;
            valueAnimator4.start();
        }
    }

    public static /* synthetic */ void showImageLoadProgress$default(PreviewImageView previewImageView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        previewImageView.showImageLoadProgress(bl);
    }

    public final void setOnLoadingFinishListener(@Nullable OnLoadingFinishListener listener2) {
        this.mListener = listener2;
    }

    public final void setTheme(@NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)theme), (String)"theme");
        this.mTheme = theme;
    }

    /*
     * WARNING - void declaration
     */
    private final void showBreathAnimation() {
        void $this$showBreathAnimation_u24lambda_u244;
        if (this.isAnimationRunning()) {
            return;
        }
        float[] fArray = new float[]{1.0f, 1.2f, 1.0f};
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])fArray);
        float[] fArray2 = new float[]{1.0f, 1.2f, 1.0f};
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])fArray2);
        Object object = new float[]{this.getProgress(), 1.0f};
        PropertyValuesHolder progress = PropertyValuesHolder.ofFloat((String)"progress", (float[])object);
        object = new PropertyValuesHolder[3];
        object[0] = (float)scaleX;
        object[1] = (float)scaleY;
        object[2] = (float)progress;
        Object object2 = object = (Object)ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])object);
        PreviewImageView previewImageView = this;
        boolean bl = false;
        $this$showBreathAnimation_u24lambda_u244.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ PreviewImageView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(Animator animation) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    super.onAnimationEnd(animation);
                    PreviewImageView.access$setNewImageLoading$p(this.this$0, false);
                    PreviewImageView.access$setProgress(this.this$0, 0.0f);
                    PreviewImageView.access$setMBreathAnimation$p(this.this$0, null);
                    OnLoadingFinishListener onLoadingFinishListener = PreviewImageView.access$getMListener$p(this.this$0);
                    if (onLoadingFinishListener == null) break block0;
                    onLoadingFinishListener.onLoadingFinish();
                }
            }
        });
        $this$showBreathAnimation_u24lambda_u244.setDuration(150L);
        $this$showBreathAnimation_u24lambda_u244.setInterpolator((TimeInterpolator)new LinearInterpolator());
        $this$showBreathAnimation_u24lambda_u244.start();
        previewImageView.mBreathAnimation = (ObjectAnimator)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAnimationRunning() {
        boolean bl;
        ValueAnimator valueAnimator = this.mProgressAnim;
        if (valueAnimator != null) {
            if (valueAnimator.isRunning()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        ObjectAnimator objectAnimator = this.mBreathAnimation;
        if (objectAnimator == null) return false;
        if (!objectAnimator.isRunning()) return false;
        return true;
    }

    private final void setProgress(float progress) {
        this.progress = progress;
        this.updateBorderProgress();
    }

    private final float getProgress() {
        return this.progress;
    }

    private final void updateBorderProgress() {
        block2: {
            PathMeasure pathMeasure;
            Path path = this.mProgressDstPath;
            if (path == null) break block2;
            Path it = path;
            boolean bl = false;
            it.reset();
            PathMeasure pathMeasure2 = this.mProgressPathMeasure;
            if (pathMeasure2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mProgressPathMeasure");
                pathMeasure2 = null;
            }
            if ((pathMeasure = this.mProgressPathMeasure) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mProgressPathMeasure");
                pathMeasure = null;
            }
            pathMeasure2.getSegment(0.0f, pathMeasure.getLength() * this.progress, it, true);
            this.invalidate();
        }
    }

    private final float dp2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return dpValue * scale + 0.5f;
    }

    private static final void showImageLoadProgress$lambda$3(PreviewImageView this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object value = it.getAnimatedValue();
        if (value instanceof Float) {
            this$0.setProgress(((Number)value).floatValue());
        }
    }

    public static final /* synthetic */ void access$setNewImageLoading$p(PreviewImageView $this, boolean bl) {
        $this.isNewImageLoading = bl;
    }

    public static final /* synthetic */ void access$setProgress(PreviewImageView $this, float progress) {
        $this.setProgress(progress);
    }

    public static final /* synthetic */ void access$setMBreathAnimation$p(PreviewImageView $this, ObjectAnimator objectAnimator) {
        $this.mBreathAnimation = objectAnimator;
    }

    public static final /* synthetic */ OnLoadingFinishListener access$getMListener$p(PreviewImageView $this) {
        return $this.mListener;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/widget/PreviewImageView$Companion;", "", "<init>", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/jiangdg/ausbc/widget/PreviewImageView$OnLoadingFinishListener;", "", "onLoadingFinish", "", "libausbc_release"})
    public static interface OnLoadingFinishListener {
        public void onLoadingFinish();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/widget/PreviewImageView$Theme;", "", "<init>", "(Ljava/lang/String;I)V", "LIGHT", "DARK", "libausbc_release"})
    public static final class Theme
    extends Enum<Theme> {
        public static final /* enum */ Theme LIGHT = new Theme();
        public static final /* enum */ Theme DARK = new Theme();
        private static final /* synthetic */ Theme[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Theme[] values() {
            return (Theme[])$VALUES.clone();
        }

        public static Theme valueOf(String value) {
            return Enum.valueOf(Theme.class, value);
        }

        @NotNull
        public static EnumEntries<Theme> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = themeArray = new Theme[]{Theme.LIGHT, Theme.DARK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

