/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jiangdg.ausbc.R;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 H2\u00020\u0001:\u0002GHB\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010%\u001a\u00020&2\b\u0010\"\u001a\u0004\u0018\u00010#J\u000e\u0010'\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0006\u0010(\u001a\u00020\u000eJ\u000e\u0010)\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u000eJ\u000e\u0010+\u001a\u00020&2\u0006\u0010 \u001a\u00020\nJ\u0010\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0017J\u0018\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000eH\u0014J\u0010\u00102\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000eH\u0002J\u0010\u00103\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000eH\u0002J\b\u0010$\u001a\u00020\nH\u0002J(\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u000eH\u0014J\u0010\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020;H\u0014J\u0010\u0010<\u001a\u00020&2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010=\u001a\u00020&2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010>\u001a\u00020&2\u0006\u0010:\u001a\u00020;2\u0006\u0010?\u001a\u00020\u000eH\u0002J\u0010\u0010@\u001a\u00020&2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010A\u001a\u00020&2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010B\u001a\u00020&2\u0006\u0010:\u001a\u00020;2\u0006\u0010C\u001a\u00020DH\u0002J\u000e\u0010E\u001a\u00020&2\u0006\u0010F\u001a\u00020\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/jiangdg/ausbc/widget/CircleProgressView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "isRecordVideo", "", "mPaint", "Landroid/graphics/Paint;", "mWidth", "", "mHeight", "circleX", "circleY", "radius", "state", "mSweepAngle", "isOddNumber", "outsideCircleBgColor", "progressArcBgColor", "insideCircleBgColor", "insideCircleTouchedBgColor", "insideRectangleBgColor", "tipTextSize", "", "tipTextColor", "progress", "totalSize", "isShowTextTip", "isTouched", "listener", "Lcom/jiangdg/ausbc/widget/CircleProgressView$OnViewClickListener;", "isDisabled", "setOnViewClickListener", "", "setConnectState", "getConnectState", "setProgressVaule", "setTotalSize", "setShowTextTipFlag", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "measureHeight", "measureWidth", "onSizeChanged", "w", "h", "oldw", "oldh", "onDraw", "canvas", "Landroid/graphics/Canvas;", "drawRecordVideoCircle", "drawOutSideCircle", "drawInternalCircle", "colorType", "drawInternelRectangle", "drawProgressArc", "drawTextTip", "tipText", "", "setMode", "model", "OnViewClickListener", "Companion", "libausbc_release"})
public final class CircleProgressView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isRecordVideo;
    @Nullable
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int circleX;
    private int circleY;
    private int radius;
    private int state;
    private int mSweepAngle;
    private boolean isOddNumber;
    private int outsideCircleBgColor;
    private int progressArcBgColor;
    private int insideCircleBgColor;
    private int insideCircleTouchedBgColor;
    private int insideRectangleBgColor;
    private float tipTextSize;
    private int tipTextColor;
    private int progress;
    private int totalSize;
    private boolean isShowTextTip;
    private boolean isTouched;
    @Nullable
    private OnViewClickListener listener;
    private boolean isDisabled;
    private static final int STATE_DOING = 0;
    private static final int STATE_DONE = 1;
    private static final int STATE_UNDONE = 2;
    private static final int NONE = -1;
    private static final int MODEL_PICTURE = 0;
    private static final int MODEL_VIDEO = 1;

    public CircleProgressView(@Nullable Context context) {
        super(context);
        this.mSweepAngle = 1;
        this.isOddNumber = true;
    }

    public final void setOnViewClickListener(@Nullable OnViewClickListener listener2) {
        this.listener = listener2;
    }

    public CircleProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mSweepAngle = 1;
        this.isOddNumber = true;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray ta = typedArray;
        this.outsideCircleBgColor = ta.getColor(R.styleable.CircleProgressView_outsideCircleBgColor, this.getResources().getColor(R.color.colorWhite));
        this.progressArcBgColor = ta.getColor(R.styleable.CircleProgressView_progressArcBgColor, this.getResources().getColor(R.color.colorGray));
        this.insideCircleBgColor = ta.getColor(R.styleable.CircleProgressView_insideCircleBgColor, this.getResources().getColor(R.color.colorRed));
        this.insideCircleTouchedBgColor = ta.getColor(R.styleable.CircleProgressView_insideCircleTouchedBgColor, this.getResources().getColor(R.color.colorDeepRed));
        this.insideRectangleBgColor = ta.getColor(R.styleable.CircleProgressView_insideRectangleBgColor, this.getResources().getColor(R.color.colorRed));
        this.tipTextColor = ta.getColor(R.styleable.CircleProgressView_tipTextColor, this.getResources().getColor(R.color.colorWhite));
        this.tipTextSize = ta.getDimension(R.styleable.CircleProgressView_tipTextSize, 34.0f);
        ta.recycle();
        this.mPaint = new Paint();
    }

    public final void setConnectState(int state) {
        this.state = state;
        this.invalidate();
    }

    public final int getConnectState() {
        return this.state;
    }

    public final void setProgressVaule(int progress) {
        this.progress = progress;
        this.invalidate();
    }

    public final void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public final void setShowTextTipFlag(boolean isShowTextTip) {
        this.isShowTextTip = isShowTextTip;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.listener == null || this.isDisabled()) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.isTouched = true;
                break;
            }
            case 1: {
                this.isTouched = false;
                OnViewClickListener onViewClickListener = this.listener;
                Intrinsics.checkNotNull((Object)onViewClickListener);
                onViewClickListener.onViewClick();
            }
        }
        this.invalidate();
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private final int measureHeight(int widthMeasureSpec) {
        int width = 0;
        int specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (specMode == 0x40000000) {
            width = specSize;
        } else {
            width = 200;
            if (specMode == Integer.MIN_VALUE) {
                width = RangesKt.coerceAtMost((int)width, (int)specSize);
            }
        }
        return width;
    }

    private final int measureWidth(int heightMeasureSpec) {
        int height = 0;
        int specMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (specMode == 0x40000000) {
            height = specSize;
        } else {
            height = 200;
            if (specMode == Integer.MIN_VALUE) {
                height = RangesKt.coerceAtMost((int)height, (int)specSize);
            }
        }
        return height;
    }

    private final boolean isDisabled() {
        return this.isDisabled;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.circleX = this.mWidth / 2;
        this.circleY = this.mWidth / 2;
        this.radius = this.mWidth / 2;
        this.state = 2;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawOutSideCircle(canvas);
        if (1 == this.state) {
            this.drawInternelRectangle(canvas);
        } else {
            if (this.isTouched) {
                this.drawInternalCircle(canvas, this.insideCircleTouchedBgColor);
            } else {
                this.drawInternalCircle(canvas, this.insideCircleBgColor);
            }
            if (this.state == 0) {
                this.drawProgressArc(canvas);
            }
        }
        if (this.isRecordVideo) {
            this.drawRecordVideoCircle(canvas);
        }
    }

    private final void drawRecordVideoCircle(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.0f);
        }
        Paint paint2 = this.mPaint;
        if (paint2 != null) {
            paint2.setStyle(Paint.Style.FILL);
        }
        Paint paint3 = this.mPaint;
        if (paint3 != null) {
            paint3.setColor(this.getResources().getColor(R.color.colorRed));
        }
        Paint paint4 = this.mPaint;
        if (paint4 != null) {
            paint4.setAntiAlias(true);
        }
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = (float)((double)this.radius - (double)this.radius * 0.75);
        Paint paint5 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint5);
        canvas.drawCircle(f, f2, f3, paint5);
    }

    private final void drawOutSideCircle(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.5f);
        }
        Paint paint2 = this.mPaint;
        if (paint2 != null) {
            paint2.setColor(this.outsideCircleBgColor);
        }
        Paint paint3 = this.mPaint;
        if (paint3 != null) {
            paint3.setStyle(Paint.Style.STROKE);
        }
        Paint paint4 = this.mPaint;
        if (paint4 != null) {
            paint4.setAntiAlias(true);
        }
        canvas.drawColor(0);
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = (float)this.radius - 5.0f;
        Paint paint5 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint5);
        canvas.drawCircle(f, f2, f3, paint5);
    }

    private final void drawInternalCircle(Canvas canvas, int colorType) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.0f);
        }
        Paint paint2 = this.mPaint;
        if (paint2 != null) {
            paint2.setStyle(Paint.Style.FILL);
        }
        Paint paint3 = this.mPaint;
        if (paint3 != null) {
            paint3.setColor(colorType);
        }
        Paint paint4 = this.mPaint;
        if (paint4 != null) {
            paint4.setAntiAlias(true);
        }
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = (float)((double)this.radius - (double)this.radius * 0.35);
        Paint paint5 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint5);
        canvas.drawCircle(f, f2, f3, paint5);
    }

    private final void drawInternelRectangle(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.0f);
        }
        Paint paint2 = this.mPaint;
        if (paint2 != null) {
            paint2.setColor(this.insideRectangleBgColor);
        }
        Paint paint3 = this.mPaint;
        if (paint3 != null) {
            paint3.setAntiAlias(true);
        }
        Paint paint4 = this.mPaint;
        if (paint4 != null) {
            paint4.setStyle(Paint.Style.FILL);
        }
        float f = (float)((double)this.mWidth * 0.3);
        float f2 = (float)((double)this.mWidth * 0.3);
        float f3 = (float)((double)this.mWidth - (double)this.mWidth * 0.3);
        float f4 = (float)((double)this.mWidth - (double)this.mWidth * 0.3);
        Paint paint5 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint5);
        canvas.drawRect(f, f2, f3, f4, paint5);
    }

    private final void drawProgressArc(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth((float)((int)((double)this.radius * 0.15)));
        }
        Paint paint2 = this.mPaint;
        if (paint2 != null) {
            paint2.setStyle(Paint.Style.STROKE);
        }
        Paint paint3 = this.mPaint;
        if (paint3 != null) {
            paint3.setAntiAlias(true);
        }
        Paint paint4 = this.mPaint;
        if (paint4 != null) {
            paint4.setColor(this.progressArcBgColor);
        }
        if (this.progress >= 0) {
            if (this.totalSize == 0) {
                return;
            }
            RectF rectF = new RectF((float)((double)this.radius * 0.08), (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08));
            String string = new DecimalFormat("0.00").format(Float.valueOf((float)this.progress / (float)this.totalSize));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            float f = (int)(Float.parseFloat(string) * (float)360);
            Paint paint5 = this.mPaint;
            Intrinsics.checkNotNull((Object)paint5);
            canvas.drawArc(rectF, 180.0f, f, false, paint5);
            if (this.isShowTextTip) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = new DecimalFormat("0.00").format(Float.valueOf((float)this.progress / (float)this.totalSize));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                this.drawTextTip(canvas, stringBuilder.append(Float.parseFloat(string2) * (float)100).append(" %").toString());
            }
        } else if (this.progress == -1) {
            if (this.isOddNumber) {
                RectF rectF = new RectF((float)((double)this.radius * 0.08), (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08));
                float f = this.mSweepAngle;
                Paint paint6 = this.mPaint;
                Intrinsics.checkNotNull((Object)paint6);
                canvas.drawArc(rectF, 180.0f, f, false, paint6);
                int n = this.mSweepAngle;
                this.mSweepAngle = n + 1;
                if (this.mSweepAngle >= 360) {
                    this.isOddNumber = false;
                }
            } else {
                RectF rectF = new RectF((float)((double)this.radius * 0.08), (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08), (float)(2 * this.radius) - (float)((double)this.radius * 0.08));
                float f = -this.mSweepAngle;
                Paint paint7 = this.mPaint;
                Intrinsics.checkNotNull((Object)paint7);
                canvas.drawArc(rectF, 180.0f, f, false, paint7);
                int n = this.mSweepAngle;
                this.mSweepAngle = n + -1;
                if (this.mSweepAngle == 0) {
                    this.isOddNumber = true;
                }
            }
            this.postInvalidateDelayed(5L);
        }
    }

    private final void drawTextTip(Canvas canvas, String tipText) {
        Paint paint = this.mPaint;
        if (paint != null) {
            paint.setStrokeWidth(2.0f);
        }
        Paint paint2 = this.mPaint;
        if (paint2 != null) {
            paint2.setStyle(Paint.Style.FILL);
        }
        Paint paint3 = this.mPaint;
        if (paint3 != null) {
            paint3.setAntiAlias(true);
        }
        Paint paint4 = this.mPaint;
        if (paint4 != null) {
            paint4.setTextSize(this.tipTextSize);
        }
        Paint paint5 = this.mPaint;
        if (paint5 != null) {
            paint5.setColor(this.tipTextColor);
        }
        Paint paint6 = this.mPaint;
        if (paint6 != null) {
            paint6.setTextAlign(Paint.Align.CENTER);
        }
        int xCenter = this.getMeasuredHeight() / 2;
        float f = this.getMeasuredHeight();
        Paint paint7 = this.mPaint;
        Object object = paint7 != null ? paint7.getFontMetrics() : null;
        Intrinsics.checkNotNull((Object)object);
        float f2 = f - object.bottom;
        Paint paint8 = this.mPaint;
        Object object2 = paint8 != null ? paint8.getFontMetrics() : null;
        Intrinsics.checkNotNull((Object)object2);
        float f3 = (f2 + object2.top) / (float)2;
        Paint paint9 = this.mPaint;
        Object object3 = paint9 != null ? paint9.getFontMetrics() : null;
        Intrinsics.checkNotNull((Object)object3);
        float yBaseLine = f3 - object3.top;
        float f4 = xCenter;
        Paint paint10 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint10);
        canvas.drawText(tipText, f4, yBaseLine, paint10);
    }

    public final void setMode(int model) {
        this.isRecordVideo = model == 1;
        this.invalidate();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jiangdg/ausbc/widget/CircleProgressView$Companion;", "", "<init>", "()V", "STATE_DOING", "", "STATE_DONE", "STATE_UNDONE", "NONE", "MODEL_PICTURE", "MODEL_VIDEO", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/jiangdg/ausbc/widget/CircleProgressView$OnViewClickListener;", "", "onViewClick", "", "libausbc_release"})
    public static interface OnViewClickListener {
        public void onViewClick();
    }
}

