/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jiangdg.ausbc.R;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0004IJKLB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010!\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\b\u0010#\u001a\u00020\"H\u0002J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eJ\u0010\u0010(\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\u0016J\u0010\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u0018J\u0010\u0010,\u001a\u00020\"2\b\u0010-\u001a\u0004\u0018\u00010\u0014J\u0010\u0010.\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010/\u001a\u00020\u001cH\u0002J\u0010\u00100\u001a\u00020 2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u000eH\u0014J\u0010\u00106\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000eH\u0002J\u0010\u00107\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u000eH\u0002J(\u00108\u001a\u00020\"2\u0006\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000eH\u0014J\u0010\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020?H\u0014J\b\u0010@\u001a\u00020\"H\u0014J\b\u0010A\u001a\u00020\"H\u0002J\u0010\u0010B\u001a\u00020\"2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010C\u001a\u00020\"2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010D\u001a\u00020\"2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010E\u001a\u00020\"2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010F\u001a\u00020\"2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020\u001cH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mAnimator", "Landroid/animation/ObjectAnimator;", "mPaint", "Landroid/graphics/Paint;", "mWidth", "", "mHeight", "circleX", "circleY", "radius", "mCaptureVideoState", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureVideoState;", "mCaptureModel", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureMode;", "mCaptureViewTheme", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureViewTheme;", "mCaptureVideoDuration", "mCaptureVideoProgress", "internalCirclePercent", "", "listener", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$OnViewClickListener;", "mFirstDraw", "", "setOnViewClickListener", "", "init", "setCaptureVideoProgress", "progress", "setCaptureVideoDuration", "duration", "setCaptureMode", "model", "setCaptureViewTheme", "theme", "setCaptureVideoState", "state", "setInternalCirclePercent", "getInternalCirclePercent", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "measureHeight", "measureWidth", "onSizeChanged", "w", "h", "oldw", "oldh", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onDetachedFromWindow", "showClickAnimation", "drawCapturePicture", "drawCaptureVideo", "drawCaptureVideoDoingState", "drawCaptureVideoPauseState", "drawCaptureVideoUndoState", "dp2px", "dpValue", "CaptureVideoState", "CaptureMode", "CaptureViewTheme", "OnViewClickListener", "libausbc_release"})
public final class CaptureMediaView
extends View {
    @Nullable
    private ObjectAnimator mAnimator;
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int circleX;
    private int circleY;
    private int radius;
    @Nullable
    private CaptureVideoState mCaptureVideoState;
    @Nullable
    private CaptureMode mCaptureModel;
    @Nullable
    private CaptureViewTheme mCaptureViewTheme;
    private int mCaptureVideoDuration;
    private int mCaptureVideoProgress;
    private float internalCirclePercent;
    @Nullable
    private OnViewClickListener listener;
    private boolean mFirstDraw;

    public final void setOnViewClickListener(@Nullable OnViewClickListener listener2) {
        this.listener = listener2;
    }

    public CaptureMediaView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mFirstDraw = true;
        this.init();
    }

    public CaptureMediaView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mFirstDraw = true;
        this.init();
    }

    private final void init() {
        this.mPaint = new Paint();
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint = null;
        }
        paint.setAntiAlias(true);
        this.mCaptureVideoState = CaptureVideoState.UNDO;
        this.mCaptureModel = CaptureMode.MODE_CAPTURE_PIC;
        this.mCaptureViewTheme = CaptureViewTheme.THEME_BLUE;
        this.mCaptureVideoProgress = 0;
        this.internalCirclePercent = 1.0f;
        this.mCaptureVideoDuration = 60;
    }

    public final void setCaptureVideoProgress(int progress) {
        this.mCaptureVideoProgress = progress;
        this.invalidate();
    }

    public final void setCaptureVideoDuration(int duration) {
        this.mCaptureVideoDuration = duration;
    }

    public final void setCaptureMode(@Nullable CaptureMode model) {
        this.mCaptureModel = model;
        this.invalidate();
    }

    public final void setCaptureViewTheme(@Nullable CaptureViewTheme theme) {
        this.mCaptureViewTheme = theme;
    }

    public final void setCaptureVideoState(@Nullable CaptureVideoState state) {
        this.mCaptureVideoState = state;
        this.invalidate();
    }

    private final void setInternalCirclePercent(float internalCirclePercent) {
        this.internalCirclePercent = internalCirclePercent;
        this.invalidate();
    }

    private final float getInternalCirclePercent() {
        return this.internalCirclePercent;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() == 1 && this.listener != null) {
            this.showClickAnimation();
            OnViewClickListener onViewClickListener = this.listener;
            Intrinsics.checkNotNull((Object)onViewClickListener);
            onViewClickListener.onViewClick(this.mCaptureModel);
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private final int measureHeight(int widthMeasureSpec) {
        int measureW = 0;
        int specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (specMode == 0x40000000) {
            measureW = specSize;
        } else {
            measureW = this.dp2px(80.0f);
            if (specMode == Integer.MIN_VALUE) {
                measureW = RangesKt.coerceAtMost((int)measureW, (int)specSize);
            }
        }
        return measureW;
    }

    private final int measureWidth(int heightMeasureSpec) {
        int measureH = 0;
        int specMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (specMode == 0x40000000) {
            measureH = specSize;
        } else {
            measureH = this.dp2px(80.0f);
            if (specMode == Integer.MIN_VALUE) {
                measureH = RangesKt.coerceAtMost((int)measureH, (int)specSize);
            }
        }
        return measureH;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.circleX = this.mWidth / 2;
        this.circleY = this.mHeight / 2;
        this.radius = this.mWidth / 2;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.mCaptureModel == CaptureMode.MODE_CAPTURE_VIDEO || this.mCaptureModel == CaptureMode.MODE_CAPTURE_AUDIO) {
            this.drawCaptureVideo(canvas);
        } else {
            this.drawCapturePicture(canvas);
        }
        if (this.mFirstDraw) {
            this.mFirstDraw = false;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimator != null) {
            ObjectAnimator objectAnimator = this.mAnimator;
            Intrinsics.checkNotNull((Object)objectAnimator);
            if (objectAnimator.isRunning()) {
                ObjectAnimator objectAnimator2 = this.mAnimator;
                Intrinsics.checkNotNull((Object)objectAnimator2);
                objectAnimator2.cancel();
                this.mAnimator = null;
            }
        }
    }

    private final void showClickAnimation() {
        block2: {
            if (this.mCaptureModel != CaptureMode.MODE_CAPTURE_PIC) break block2;
            float[] fArray = new float[]{1.0f, 0.85f, 1.0f};
            ObjectAnimator objectAnimator = this.mAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"internalCirclePercent", (float[])fArray);
            if (objectAnimator != null) {
                objectAnimator.setDuration(150L);
            }
            ObjectAnimator objectAnimator2 = this.mAnimator;
            if (objectAnimator2 != null) {
                objectAnimator2.start();
            }
        }
    }

    private final void drawCapturePicture(Canvas canvas) {
        if (this.mCaptureViewTheme == CaptureViewTheme.THEME_BLUE) {
            Paint paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint = null;
            }
            paint.setStyle(Paint.Style.FILL);
            Paint paint2 = this.mPaint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint2 = null;
            }
            paint2.setColor(-1);
            float f = this.circleX;
            float f2 = this.circleY;
            float f3 = this.radius;
            Paint paint3 = this.mPaint;
            if (paint3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint3 = null;
            }
            canvas.drawCircle(f, f2, f3, paint3);
            Paint paint4 = this.mPaint;
            if (paint4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint4 = null;
            }
            paint4.setStyle(Paint.Style.FILL);
            Paint paint5 = this.mPaint;
            if (paint5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint5 = null;
            }
            paint5.setStrokeWidth(2.0f);
            Paint paint6 = this.mPaint;
            if (paint6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint6 = null;
            }
            paint6.setColor(Color.parseColor((String)"#2E5BFF"));
            float f4 = this.circleX;
            float f5 = this.circleY;
            float f6 = (float)((double)this.radius - (double)this.radius * 0.2) * this.internalCirclePercent;
            Paint paint7 = this.mPaint;
            if (paint7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint7 = null;
            }
            canvas.drawCircle(f4, f5, f6, paint7);
            Paint paint8 = this.mPaint;
            if (paint8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint8 = null;
            }
            paint8.setStrokeWidth((float)((double)this.radius * 0.1));
            Paint paint9 = this.mPaint;
            if (paint9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint9 = null;
            }
            paint9.setStyle(Paint.Style.STROKE);
            Paint paint10 = this.mPaint;
            if (paint10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint10 = null;
            }
            paint10.setColor(Color.parseColor((String)"#2E5BFF"));
            float f7 = this.circleX;
            float f8 = this.circleY;
            float f9 = (float)((double)this.radius - (double)this.radius * 0.05);
            Paint paint11 = this.mPaint;
            if (paint11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint11 = null;
            }
            canvas.drawCircle(f7, f8, f9, paint11);
        } else {
            Paint paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint = null;
            }
            paint.setStyle(Paint.Style.FILL);
            Paint paint12 = this.mPaint;
            if (paint12 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint12 = null;
            }
            paint12.setColor(0);
            float f = this.circleX;
            float f10 = this.circleY;
            float f11 = this.radius;
            Paint paint13 = this.mPaint;
            if (paint13 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint13 = null;
            }
            canvas.drawCircle(f, f10, f11, paint13);
            Paint paint14 = this.mPaint;
            if (paint14 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint14 = null;
            }
            paint14.setStyle(Paint.Style.FILL);
            Paint paint15 = this.mPaint;
            if (paint15 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint15 = null;
            }
            paint15.setStrokeWidth(2.0f);
            Paint paint16 = this.mPaint;
            if (paint16 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint16 = null;
            }
            paint16.setColor(-1);
            float f12 = this.circleX;
            float f13 = this.circleY;
            float f14 = (float)((double)this.radius - (double)this.radius * 0.2) * this.internalCirclePercent;
            Paint paint17 = this.mPaint;
            if (paint17 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint17 = null;
            }
            canvas.drawCircle(f12, f13, f14, paint17);
            Paint paint18 = this.mPaint;
            if (paint18 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint18 = null;
            }
            paint18.setStrokeWidth((float)((double)this.radius * 0.1));
            Paint paint19 = this.mPaint;
            if (paint19 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint19 = null;
            }
            paint19.setStyle(Paint.Style.STROKE);
            Paint paint20 = this.mPaint;
            if (paint20 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint20 = null;
            }
            paint20.setColor(-1);
            float f15 = this.circleX;
            float f16 = this.circleY;
            float f17 = (float)((double)this.radius - (double)this.radius * 0.05);
            Paint paint21 = this.mPaint;
            if (paint21 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint21 = null;
            }
            canvas.drawCircle(f15, f16, f17, paint21);
        }
    }

    private final void drawCaptureVideo(Canvas canvas) {
        CaptureVideoState captureVideoState = this.mCaptureVideoState;
        switch (captureVideoState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[captureVideoState.ordinal()]) {
            case 1: {
                this.drawCaptureVideoDoingState(canvas);
                break;
            }
            case 2: {
                this.drawCaptureVideoPauseState(canvas);
                break;
            }
            default: {
                this.drawCaptureVideoUndoState(canvas);
            }
        }
    }

    private final void drawCaptureVideoDoingState(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint = null;
        }
        paint.setStyle(Paint.Style.FILL);
        Paint paint2 = this.mPaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint2 = null;
        }
        paint2.setColor(this.getResources().getColor(R.color.common_30_black));
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = this.radius;
        Paint paint3 = this.mPaint;
        if (paint3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint3 = null;
        }
        canvas.drawCircle(f, f2, f3, paint3);
        Paint paint4 = this.mPaint;
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint4 = null;
        }
        paint4.setStyle(Paint.Style.FILL);
        Paint paint5 = this.mPaint;
        if (paint5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint5 = null;
        }
        paint5.setColor(-1);
        float f4 = this.circleX;
        float f5 = this.circleY;
        float f6 = (float)this.radius * 0.575f;
        Paint paint6 = this.mPaint;
        if (paint6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint6 = null;
        }
        canvas.drawCircle(f4, f5, f6, paint6);
        Paint paint7 = this.mPaint;
        if (paint7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint7 = null;
        }
        paint7.setStyle(Paint.Style.FILL);
        Paint paint8 = this.mPaint;
        if (paint8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint8 = null;
        }
        paint8.setStrokeWidth(2.0f);
        Paint paint9 = this.mPaint;
        if (paint9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint9 = null;
        }
        paint9.setColor(Color.parseColor((String)"#FF0000"));
        RectF rectF = new RectF((float)((double)this.mWidth * 0.4125), (float)((double)this.mWidth * 0.3875), (float)((double)this.mWidth * 0.4625), (float)((double)this.mWidth * 0.6125));
        Paint paint10 = this.mPaint;
        if (paint10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint10 = null;
        }
        canvas.drawRoundRect(rectF, 8.0f, 8.0f, paint10);
        RectF rectF2 = new RectF((float)((double)this.mWidth * 0.5375), (float)((double)this.mWidth * 0.3875), (float)((double)this.mWidth * 0.5875), (float)((double)this.mWidth * 0.6125));
        Paint paint11 = this.mPaint;
        if (paint11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint11 = null;
        }
        canvas.drawRoundRect(rectF2, 8.0f, 8.0f, paint11);
        Paint paint12 = this.mPaint;
        if (paint12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint12 = null;
        }
        paint12.setStrokeCap(Paint.Cap.ROUND);
        Paint paint13 = this.mPaint;
        if (paint13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint13 = null;
        }
        paint13.setStrokeWidth((float)((double)this.radius * 0.08));
        Paint paint14 = this.mPaint;
        if (paint14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint14 = null;
        }
        paint14.setStyle(Paint.Style.STROKE);
        Paint paint15 = this.mPaint;
        if (paint15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint15 = null;
        }
        paint15.setColor(Color.parseColor((String)"#2E5BFF"));
        RectF rectF3 = new RectF((float)((double)this.radius * 0.03), (float)((double)this.radius * 0.03), (float)(2 * this.radius) - (float)((double)this.radius * 0.03), (float)(2 * this.radius) - (float)((double)this.radius * 0.03));
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("0.00");
        format.setDecimalFormatSymbols(dfs);
        String result = format.format((float)this.mCaptureVideoProgress / (float)this.mCaptureVideoDuration);
        Intrinsics.checkNotNull((Object)result);
        float f7 = Float.parseFloat(result) * (float)360;
        Paint paint16 = this.mPaint;
        if (paint16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint16 = null;
        }
        canvas.drawArc(rectF3, 270.0f, f7, false, paint16);
    }

    private final void drawCaptureVideoPauseState(Canvas canvas) {
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint = null;
        }
        paint.setStyle(Paint.Style.FILL);
        Paint paint2 = this.mPaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint2 = null;
        }
        paint2.setColor(this.getResources().getColor(R.color.common_30_black));
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = this.radius;
        Paint paint3 = this.mPaint;
        if (paint3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint3 = null;
        }
        canvas.drawCircle(f, f2, f3, paint3);
        Paint paint4 = this.mPaint;
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint4 = null;
        }
        paint4.setStyle(Paint.Style.FILL);
        Paint paint5 = this.mPaint;
        if (paint5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint5 = null;
        }
        paint5.setColor(-1);
        float f4 = this.circleX;
        float f5 = this.circleY;
        float f6 = (float)this.radius * 0.6f;
        Paint paint6 = this.mPaint;
        if (paint6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint6 = null;
        }
        canvas.drawCircle(f4, f5, f6, paint6);
        Paint paint7 = this.mPaint;
        if (paint7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint7 = null;
        }
        paint7.setStrokeCap(Paint.Cap.ROUND);
        Paint paint8 = this.mPaint;
        if (paint8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint8 = null;
        }
        paint8.setStrokeWidth((float)((double)this.radius * 0.08));
        Paint paint9 = this.mPaint;
        if (paint9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint9 = null;
        }
        paint9.setStyle(Paint.Style.STROKE);
        Paint paint10 = this.mPaint;
        if (paint10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint10 = null;
        }
        paint10.setColor(Color.parseColor((String)"#2E5BFF"));
        RectF rectF = new RectF((float)((double)this.radius * 0.03), (float)((double)this.radius * 0.03), (float)(2 * this.radius) - (float)((double)this.radius * 0.03), (float)(2 * this.radius) - (float)((double)this.radius * 0.03));
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("0.00");
        format.setDecimalFormatSymbols(dfs);
        String result = format.format((float)this.mCaptureVideoProgress / (float)this.mCaptureVideoDuration);
        Intrinsics.checkNotNull((Object)result);
        float f7 = Float.parseFloat(result) * (float)360;
        Paint paint11 = this.mPaint;
        if (paint11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint11 = null;
        }
        canvas.drawArc(rectF, 270.0f, f7, false, paint11);
    }

    private final void drawCaptureVideoUndoState(Canvas canvas) {
        this.mCaptureVideoProgress = 0;
        Paint paint = this.mPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint = null;
        }
        paint.setStyle(Paint.Style.FILL);
        Paint paint2 = this.mPaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint2 = null;
        }
        paint2.setColor(0);
        float f = this.circleX;
        float f2 = this.circleY;
        float f3 = this.radius;
        Paint paint3 = this.mPaint;
        if (paint3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint3 = null;
        }
        canvas.drawCircle(f, f2, f3, paint3);
        Paint paint4 = this.mPaint;
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint4 = null;
        }
        paint4.setStrokeWidth(2.0f);
        Paint paint5 = this.mPaint;
        if (paint5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint5 = null;
        }
        paint5.setStyle(Paint.Style.FILL);
        Paint paint6 = this.mPaint;
        if (paint6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint6 = null;
        }
        paint6.setColor(-1);
        float f4 = this.circleX;
        float f5 = this.circleY;
        float f6 = (float)((double)this.radius - (double)this.radius * 0.3);
        Paint paint7 = this.mPaint;
        if (paint7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint7 = null;
        }
        canvas.drawCircle(f4, f5, f6, paint7);
        canvas.save();
        Paint paint8 = this.mPaint;
        if (paint8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint8 = null;
        }
        paint8.setStrokeWidth((float)this.dp2px(2.0f));
        Paint paint9 = this.mPaint;
        if (paint9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint9 = null;
        }
        paint9.setStyle(Paint.Style.FILL);
        Paint paint10 = this.mPaint;
        if (paint10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
            paint10 = null;
        }
        paint10.setColor(-1);
        float startX = (float)this.mWidth / (float)2;
        float startY = this.mHeight / 2 - this.radius;
        int count = 30;
        for (int i = 0; i < count; ++i) {
            float f7 = startY + (float)10;
            Paint paint11 = this.mPaint;
            if (paint11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPaint");
                paint11 = null;
            }
            canvas.drawLine(startX, startY, startX, f7, paint11);
            canvas.rotate(360.0f / (float)count, (float)this.getWidth() / (float)2, (float)this.getHeight() / (float)2);
        }
        canvas.restore();
    }

    private final int dp2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureMode;", "", "<init>", "(Ljava/lang/String;I)V", "MODE_CAPTURE_PIC", "MODE_CAPTURE_VIDEO", "MODE_CAPTURE_AUDIO", "libausbc_release"})
    public static final class CaptureMode
    extends Enum<CaptureMode> {
        public static final /* enum */ CaptureMode MODE_CAPTURE_PIC = new CaptureMode();
        public static final /* enum */ CaptureMode MODE_CAPTURE_VIDEO = new CaptureMode();
        public static final /* enum */ CaptureMode MODE_CAPTURE_AUDIO = new CaptureMode();
        private static final /* synthetic */ CaptureMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CaptureMode[] values() {
            return (CaptureMode[])$VALUES.clone();
        }

        public static CaptureMode valueOf(String value) {
            return Enum.valueOf(CaptureMode.class, value);
        }

        @NotNull
        public static EnumEntries<CaptureMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = captureModeArray = new CaptureMode[]{CaptureMode.MODE_CAPTURE_PIC, CaptureMode.MODE_CAPTURE_VIDEO, CaptureMode.MODE_CAPTURE_AUDIO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureVideoState;", "", "<init>", "(Ljava/lang/String;I)V", "DOING", "UNDO", "PAUSE", "libausbc_release"})
    public static final class CaptureVideoState
    extends Enum<CaptureVideoState> {
        public static final /* enum */ CaptureVideoState DOING = new CaptureVideoState();
        public static final /* enum */ CaptureVideoState UNDO = new CaptureVideoState();
        public static final /* enum */ CaptureVideoState PAUSE = new CaptureVideoState();
        private static final /* synthetic */ CaptureVideoState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CaptureVideoState[] values() {
            return (CaptureVideoState[])$VALUES.clone();
        }

        public static CaptureVideoState valueOf(String value) {
            return Enum.valueOf(CaptureVideoState.class, value);
        }

        @NotNull
        public static EnumEntries<CaptureVideoState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = captureVideoStateArray = new CaptureVideoState[]{CaptureVideoState.DOING, CaptureVideoState.UNDO, CaptureVideoState.PAUSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureViewTheme;", "", "<init>", "(Ljava/lang/String;I)V", "THEME_BLUE", "THEME_WHITE", "libausbc_release"})
    public static final class CaptureViewTheme
    extends Enum<CaptureViewTheme> {
        public static final /* enum */ CaptureViewTheme THEME_BLUE = new CaptureViewTheme();
        public static final /* enum */ CaptureViewTheme THEME_WHITE = new CaptureViewTheme();
        private static final /* synthetic */ CaptureViewTheme[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CaptureViewTheme[] values() {
            return (CaptureViewTheme[])$VALUES.clone();
        }

        public static CaptureViewTheme valueOf(String value) {
            return Enum.valueOf(CaptureViewTheme.class, value);
        }

        @NotNull
        public static EnumEntries<CaptureViewTheme> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = captureViewThemeArray = new CaptureViewTheme[]{CaptureViewTheme.THEME_BLUE, CaptureViewTheme.THEME_WHITE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/widget/CaptureMediaView$OnViewClickListener;", "", "onViewClick", "", "mode", "Lcom/jiangdg/ausbc/widget/CaptureMediaView$CaptureMode;", "libausbc_release"})
    public static interface OnViewClickListener {
        public void onViewClick(@Nullable CaptureMode var1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CaptureVideoState.values().length];
            try {
                nArray[CaptureVideoState.DOING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaptureVideoState.PAUSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

