/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.provider.Settings;
import androidx.annotation.RawRes;
import androidx.core.content.ContextCompat;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0018\u00010\u0014R\u00020\u0015J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u001e\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lcom/jiangdg/ausbc/utils/Utils;", "", "<init>", "()V", "debugCamera", "", "getDebugCamera", "()Z", "setDebugCamera", "(Z)V", "isTargetSdkOverP", "context", "Landroid/content/Context;", "getGpsLocation", "Landroid/location/Location;", "dp2px", "", "dpValue", "", "wakeLock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "wakeUnLock", "", "getGLESVersion", "", "getScreenWidth", "getScreenHeight", "loadBitmapFromRawResource", "Landroid/graphics/Bitmap;", "id", "canDrawOverlays", "requestOverlaysPermission", "activity", "Landroid/app/Activity;", "requestCode", "libausbc_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    private static boolean debugCamera = true;

    private Utils() {
    }

    public final boolean getDebugCamera() {
        return debugCamera;
    }

    public final void setDebugCamera(boolean bl) {
        debugCamera = bl;
    }

    public final boolean isTargetSdkOverP(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"getApplicationInfo(...)");
            ApplicationInfo aInfo = applicationInfo;
            n = aInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        int targetSdkVersion = n;
        return targetSdkVersion >= 28;
    }

    @Nullable
    public final Location getGpsLocation(@Nullable Context context) {
        Context context2 = context;
        if (context2 != null) {
            Context ctx = context2;
            boolean bl = false;
            Object object = ctx.getSystemService("location");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.location.LocationManager");
            LocationManager locationManager = (LocationManager)object;
            int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.ACCESS_FINE_LOCATION");
            if (locPermission == 0) {
                return locationManager.getLastKnownLocation("passive");
            }
        }
        return null;
    }

    public final int dp2px(@NotNull Context context, float dpValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    @NotNull
    public final PowerManager.WakeLock wakeLock(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("power");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
        PowerManager pm = (PowerManager)object;
        PowerManager.WakeLock wakeLock = pm.newWakeLock(10, "jj:camera");
        Intrinsics.checkNotNullExpressionValue((Object)wakeLock, (String)"newWakeLock(...)");
        PowerManager.WakeLock mWakeLock = wakeLock;
        mWakeLock.setReferenceCounted(false);
        mWakeLock.acquire(600000L);
        return mWakeLock;
    }

    public final void wakeUnLock(@Nullable PowerManager.WakeLock wakeLock) {
        block0: {
            PowerManager.WakeLock wakeLock2 = wakeLock;
            if (wakeLock2 == null) break block0;
            wakeLock2.release();
        }
    }

    @Nullable
    public final String getGLESVersion(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager $this$getGLESVersion_u24lambda_u241 = (ActivityManager)object;
        boolean bl = false;
        return $this$getGLESVersion_u24lambda_u241.getDeviceConfigurationInfo().getGlEsVersion();
    }

    public final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Bitmap loadBitmapFromRawResource(@NotNull Context context, @RawRes int id2) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = null;
        try {
            Resources resources = context.getResources();
            inputStream = resources != null ? resources.openRawResource(id2) : null;
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = null;
        }
        finally {
            try {
                InputStream inputStream2 = inputStream;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bitmap;
    }

    public final boolean canDrawOverlays(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT < 23 ? true : Settings.canDrawOverlays((Context)context);
    }

    public final void requestOverlaysPermission(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        Uri uri = Uri.parse((String)("package:" + activity.getPackageName()));
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", uri);
        activity.startActivityForResult(intent, requestCode);
    }
}

