/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J$\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jiangdg/ausbc/utils/GLBitmapUtils;", "", "<init>", "()V", "transFrameBufferToBitmap", "Landroid/graphics/Bitmap;", "frameBufferId", "", "width", "height", "byteBuffer", "Ljava/nio/ByteBuffer;", "readPixelToByteBuffer", "", "readPixelToBitmap", "readPixelToBitmapWithBuffer", "libausbc_release"})
public final class GLBitmapUtils {
    @NotNull
    public static final GLBitmapUtils INSTANCE = new GLBitmapUtils();

    private GLBitmapUtils() {
    }

    @NotNull
    public final Bitmap transFrameBufferToBitmap(int frameBufferId, int width, int height) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Intrinsics.checkNotNull((Object)byteBuffer);
        return this.transFrameBufferToBitmap(frameBufferId, width, height, byteBuffer);
    }

    private final Bitmap transFrameBufferToBitmap(int frameBufferId, int width, int height, ByteBuffer byteBuffer) {
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap bitmap2 = bitmap;
        bitmap2.copyPixelsFromBuffer((Buffer)byteBuffer);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return bitmap2;
    }

    public final void readPixelToByteBuffer(int frameBufferId, int width, int height, @Nullable ByteBuffer byteBuffer) {
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    @Nullable
    public final Bitmap readPixelToBitmap(int width, int height) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return this.readPixelToBitmapWithBuffer(width, height, byteBuffer);
    }

    private final Bitmap readPixelToBitmapWithBuffer(int width, int height, ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap bitmap2 = bitmap;
        bitmap2.copyPixelsFromBuffer((Buffer)byteBuffer);
        return bitmap2;
    }
}

