/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.render.env;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;
import com.jiangdg.ausbc.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\tJ$\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0014J\u0006\u0010\u001e\u001a\u00020\u0014J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/jiangdg/ausbc/render/env/EGLEvn;", "", "<init>", "()V", "mEglDisplay", "Landroid/opengl/EGLDisplay;", "mEglSurface", "Landroid/opengl/EGLSurface;", "mEglContext", "Landroid/opengl/EGLContext;", "mSurface", "Landroid/view/Surface;", "configs", "", "Landroid/opengl/EGLConfig;", "[Landroid/opengl/EGLConfig;", "initEgl", "", "curContext", "setupSurface", "", "surface", "surfaceWidth", "", "surfaceHeight", "eglMakeCurrent", "setPresentationTime", "nanoseconds", "", "swapBuffers", "releaseElg", "loggerError", "msg", "", "getEGLContext", "Companion", "libausbc_release"})
public final class EGLEvn {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EGLDisplay mEglDisplay;
    @NotNull
    private EGLSurface mEglSurface;
    @NotNull
    private EGLContext mEglContext;
    @Nullable
    private Surface mSurface;
    @NotNull
    private final EGLConfig[] configs;
    @NotNull
    private static final String TAG = "EGLEvn";
    private static final int EGL_RECORDABLE_ANDROID = 12610;

    public EGLEvn() {
        EGLDisplay eGLDisplay = EGL14.EGL_NO_DISPLAY;
        Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"EGL_NO_DISPLAY");
        this.mEglDisplay = eGLDisplay;
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"EGL_NO_SURFACE");
        this.mEglSurface = eGLSurface;
        EGLContext eGLContext = EGL14.EGL_NO_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"EGL_NO_CONTEXT");
        this.mEglContext = eGLContext;
        this.configs = new EGLConfig[1];
    }

    public final boolean initEgl(@Nullable EGLContext curContext) {
        this.mEglDisplay = EGL14.eglGetDisplay((int)0);
        if (Intrinsics.areEqual((Object)this.mEglDisplay, (Object)EGL14.EGL_NO_DISPLAY)) {
            this.loggerError("Get display");
            return false;
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.loggerError("Init egl");
            return false;
        }
        int[] nArray = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12610, 1, 12344};
        int[] configAttribs = nArray;
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEglDisplay, (int[])configAttribs, (int)0, (EGLConfig[])this.configs, (int)0, (int)this.configs.length, (int[])numConfigs, (int)0)) {
            this.loggerError("Choose Config");
            return false;
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        int[] ctxAttribs = nArray2;
        EGLConfig eGLConfig = this.configs[0];
        EGLContext eGLContext = curContext;
        if (eGLContext == null) {
            eGLContext = EGL14.EGL_NO_CONTEXT;
        }
        this.mEglContext = EGL14.eglCreateContext((EGLDisplay)this.mEglDisplay, (EGLConfig)eGLConfig, (EGLContext)eGLContext, (int[])ctxAttribs, (int)0);
        if (Intrinsics.areEqual((Object)this.mEglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
            this.loggerError("Create context");
            return false;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)this.mEglContext)) {
            this.loggerError("Bind context and window");
            return false;
        }
        Logger.INSTANCE.i(TAG, "Init EGL Success!");
        return true;
    }

    public static /* synthetic */ boolean initEgl$default(EGLEvn eGLEvn, EGLContext eGLContext, int n, Object object) {
        if ((n & 1) != 0) {
            eGLContext = null;
        }
        return eGLEvn.initEgl(eGLContext);
    }

    public final void setupSurface(@Nullable Surface surface, int surfaceWidth, int surfaceHeight) {
        EGLSurface eGLSurface;
        if (Intrinsics.areEqual((Object)this.mEglDisplay, (Object)EGL14.EGL_NO_DISPLAY)) {
            return;
        }
        if (surface == null) {
            int[] nArray = new int[]{12375, surfaceWidth, 12374, surfaceHeight, 12344};
            int[] attributes = nArray;
            eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)this.configs[0], (int[])attributes, (int)0);
        } else {
            int[] nArray = new int[]{12344};
            int[] attributes = nArray;
            eGLSurface = this.mEglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)this.configs[0], (Object)surface, (int[])attributes, (int)0);
        }
        if (Intrinsics.areEqual((Object)this.mEglSurface, (Object)EGL14.EGL_NO_SURFACE)) {
            this.loggerError("Create window");
        }
        this.mSurface = surface;
        Logger.INSTANCE.i(TAG, "setupSurface Success!");
    }

    public static /* synthetic */ void setupSurface$default(EGLEvn eGLEvn, Surface surface, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        eGLEvn.setupSurface(surface, n, n2);
    }

    public final void eglMakeCurrent() {
        if (Intrinsics.areEqual((Object)this.mEglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.mEglSurface, (Object)EGL14.EGL_NO_SURFACE)) {
            return;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (EGLSurface)this.mEglSurface, (EGLContext)this.mEglContext)) {
            this.loggerError("Bind context and window");
        }
    }

    public final void setPresentationTime(long nanoseconds) {
        if (Intrinsics.areEqual((Object)this.mEglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
            return;
        }
        if (this.mSurface == null) {
            return;
        }
        if (!EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (long)nanoseconds)) {
            this.loggerError("Set Presentation time");
        }
    }

    public final void swapBuffers() {
        if (Intrinsics.areEqual((Object)this.mEglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
            return;
        }
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface)) {
            this.loggerError("Swap buffers");
        }
    }

    public final void releaseElg() {
        if (!Intrinsics.areEqual((Object)this.mEglDisplay, (Object)EGL14.EGL_NO_DISPLAY)) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mEglContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
        }
        Surface surface = this.mSurface;
        if (surface != null) {
            surface.release();
        }
        this.mEglDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEglSurface = EGL14.EGL_NO_SURFACE;
        this.mEglContext = EGL14.EGL_NO_CONTEXT;
        this.mSurface = null;
        Logger.INSTANCE.i(TAG, "Release EGL Success!");
    }

    private final void loggerError(String msg) {
        Logger.INSTANCE.e(TAG, msg + " failed. error = " + EGL14.eglGetError());
    }

    @NotNull
    public final EGLContext getEGLContext() {
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"eglGetCurrentContext(...)");
        return eGLContext;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jiangdg/ausbc/render/env/EGLEvn$Companion;", "", "<init>", "()V", "TAG", "", "EGL_RECORDABLE_ANDROID", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

