/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode.muxer;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.MediaUtils;
import com.jiangdg.ausbc.utils.Utils;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 =2\u00020\u0001:\u0001=B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00162\u0006\u0010,\u001a\u00020\u000bJ\u001e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020\u000bJ\b\u00102\u001a\u00020*H\u0002J\u0006\u00103\u001a\u00020*J\b\u00104\u001a\u0004\u0018\u00010\u0007J&\u00105\u001a\u00020*2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u00106\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u00107\u001a\u00020\u000bH\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010:\u001a\u00020\u000bJ\u0012\u0010;\u001a\u00020\t2\b\u0010<\u001a\u0004\u0018\u00010\u0007H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u001b\u0010%\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010$\u001a\u0004\b&\u0010'\u00a8\u0006>"}, d2={"Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer;", "", "context", "Landroid/content/Context;", "callBack", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "path", "", "durationInSec", "", "isVideoOnly", "", "<init>", "(Landroid/content/Context;Lcom/jiangdg/ausbc/callback/ICaptureCallBack;Ljava/lang/String;JZ)V", "mContext", "mMediaMuxer", "Landroid/media/MediaMuxer;", "mFileSubIndex", "", "mVideoTrackerIndex", "mAudioTrackerIndex", "mVideoFormat", "Landroid/media/MediaFormat;", "mAudioFormat", "mBeginMillis", "mCaptureCallBack", "mMainHandler", "Landroid/os/Handler;", "mOriginalPath", "mVideoPts", "mAudioPts", "mDateFormat", "Ljava/text/SimpleDateFormat;", "getMDateFormat", "()Ljava/text/SimpleDateFormat;", "mDateFormat$delegate", "Lkotlin/Lazy;", "mCameraDir", "getMCameraDir", "()Ljava/lang/String;", "mCameraDir$delegate", "addTracker", "", "mediaFormat", "isVideo", "pumpStream", "outputBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "saveNewFileIfNeed", "release", "getSavePath", "insertDCIM", "videoPath", "notifyOut", "getVideoContentValues", "Landroid/content/ContentValues;", "isMuxerStarter", "getLocalVideoDuration", "filePath", "Companion", "libausbc_release"})
public final class Mp4Muxer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String path;
    private final long durationInSec;
    private final boolean isVideoOnly;
    @Nullable
    private Context mContext;
    @Nullable
    private MediaMuxer mMediaMuxer;
    private int mFileSubIndex;
    private volatile int mVideoTrackerIndex;
    private volatile int mAudioTrackerIndex;
    @Nullable
    private MediaFormat mVideoFormat;
    @Nullable
    private MediaFormat mAudioFormat;
    private long mBeginMillis;
    @Nullable
    private ICaptureCallBack mCaptureCallBack;
    @NotNull
    private Handler mMainHandler;
    @Nullable
    private String mOriginalPath;
    private long mVideoPts;
    private long mAudioPts;
    @NotNull
    private final Lazy mDateFormat$delegate;
    @NotNull
    private final Lazy mCameraDir$delegate;
    @NotNull
    private static final String TAG = "Mp4Muxer";

    public Mp4Muxer(@Nullable Context context, @NotNull ICaptureCallBack callBack, @Nullable String path, long durationInSec, boolean isVideoOnly) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        this.path = path;
        this.durationInSec = durationInSec;
        this.isVideoOnly = isVideoOnly;
        this.mVideoTrackerIndex = -1;
        this.mAudioTrackerIndex = -1;
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mDateFormat$delegate = LazyKt.lazy(Mp4Muxer::mDateFormat_delegate$lambda$0);
        this.mCameraDir$delegate = LazyKt.lazy(Mp4Muxer::mCameraDir_delegate$lambda$1);
        this.mCaptureCallBack = callBack;
        this.mContext = context;
        try {
            CharSequence charSequence = this.path;
            if (charSequence == null || charSequence.length() == 0) {
                String date = this.getMDateFormat().format(System.currentTimeMillis());
                this.path = this.getMCameraDir() + "/VID_JJCamera_" + date;
            }
            this.mOriginalPath = this.path;
            String string = this.path = this.path + ".mp4";
            Intrinsics.checkNotNull((Object)string);
            this.mMediaMuxer = new MediaMuxer(string, 0);
        }
        catch (Exception e) {
            ICaptureCallBack iCaptureCallBack = this.mCaptureCallBack;
            if (iCaptureCallBack != null) {
                iCaptureCallBack.onError(e.getLocalizedMessage());
            }
            Logger.INSTANCE.e(TAG, "init media muxer failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    public /* synthetic */ Mp4Muxer(Context context, ICaptureCallBack iCaptureCallBack, String string, long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            l = 0L;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(context, iCaptureCallBack, string, l, bl);
    }

    private final SimpleDateFormat getMDateFormat() {
        Lazy lazy = this.mDateFormat$delegate;
        return (SimpleDateFormat)lazy.getValue();
    }

    private final String getMCameraDir() {
        Lazy lazy = this.mCameraDir$delegate;
        return (String)lazy.getValue();
    }

    public final synchronized void addTracker(@Nullable MediaFormat mediaFormat, boolean isVideo) {
        if (this.isMuxerStarter() || mediaFormat == null) {
            return;
        }
        try {
            MediaMuxer mediaMuxer = this.mMediaMuxer;
            if (mediaMuxer != null) {
                MediaMuxer mediaMuxer2;
                MediaMuxer $this$addTracker_u24lambda_u244 = mediaMuxer2 = mediaMuxer;
                boolean bl = false;
                int tracker = $this$addTracker_u24lambda_u244.addTrack(mediaFormat);
                if (Utils.INSTANCE.getDebugCamera()) {
                    Logger.INSTANCE.i(TAG, "addTracker index = " + tracker + " isVideo = " + isVideo);
                }
                if (isVideo) {
                    this.mVideoFormat = mediaFormat;
                    this.mVideoTrackerIndex = tracker;
                    if (this.mAudioTrackerIndex != -1 || this.isVideoOnly) {
                        $this$addTracker_u24lambda_u244.start();
                        this.mMainHandler.post(() -> Mp4Muxer.addTracker$lambda$4$lambda$2(this));
                        this.mBeginMillis = System.currentTimeMillis();
                        if (Utils.INSTANCE.getDebugCamera()) {
                            Logger.INSTANCE.i(TAG, "start media muxer");
                        }
                    }
                } else {
                    this.mAudioFormat = mediaFormat;
                    this.mAudioTrackerIndex = tracker;
                    if (this.mVideoTrackerIndex != -1) {
                        $this$addTracker_u24lambda_u244.start();
                        this.mMainHandler.post(() -> Mp4Muxer.addTracker$lambda$4$lambda$3(this));
                        this.mBeginMillis = System.currentTimeMillis();
                        if (Utils.INSTANCE.getDebugCamera()) {
                            Logger.INSTANCE.i(TAG, "start media muxer");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.release();
            this.mMainHandler.post(() -> Mp4Muxer.addTracker$lambda$5(this, e));
            Logger.INSTANCE.e(TAG, "addTracker failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    public final synchronized void pumpStream(@NotNull ByteBuffer outputBuffer, @NotNull MediaCodec.BufferInfo bufferInfo, boolean isVideo) {
        Intrinsics.checkNotNullParameter((Object)outputBuffer, (String)"outputBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        try {
            int n;
            if (!this.isMuxerStarter()) {
                return;
            }
            if (bufferInfo.size <= 0) {
                return;
            }
            if (isVideo) {
                if (this.mVideoPts == 0L) {
                    this.mVideoPts = bufferInfo.presentationTimeUs;
                }
                bufferInfo.presentationTimeUs -= this.mVideoPts;
                n = this.mVideoTrackerIndex;
            } else {
                if (this.mAudioPts == 0L) {
                    this.mAudioPts = bufferInfo.presentationTimeUs;
                }
                bufferInfo.presentationTimeUs -= this.mAudioPts;
                n = this.mAudioTrackerIndex;
            }
            int index = n;
            outputBuffer.position(bufferInfo.offset);
            outputBuffer.limit(bufferInfo.offset + bufferInfo.size);
            MediaMuxer mediaMuxer = this.mMediaMuxer;
            if (mediaMuxer != null) {
                mediaMuxer.writeSampleData(index, outputBuffer, bufferInfo);
            }
            this.saveNewFileIfNeed();
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "pumpStream failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    private final void saveNewFileIfNeed() {
        try {
            long endMillis = System.currentTimeMillis();
            if (this.durationInSec == 0L) {
                return;
            }
            if (endMillis - this.mBeginMillis <= this.durationInSec * (long)1000) {
                return;
            }
            MediaMuxer mediaMuxer = this.mMediaMuxer;
            if (mediaMuxer != null) {
                mediaMuxer.stop();
            }
            MediaMuxer mediaMuxer2 = this.mMediaMuxer;
            if (mediaMuxer2 != null) {
                mediaMuxer2.release();
            }
            this.mMediaMuxer = null;
            this.mAudioTrackerIndex = -1;
            this.mVideoTrackerIndex = -1;
            this.mAudioPts = 0L;
            this.mVideoPts = 0L;
            Mp4Muxer.insertDCIM$default(this, this.mContext, this.path, false, 4, null);
            ++this.mFileSubIndex;
            String string = this.path = this.mOriginalPath + '_' + this.mFileSubIndex + ".mp4";
            Intrinsics.checkNotNull((Object)string);
            this.mMediaMuxer = new MediaMuxer(string, 0);
            this.addTracker(this.mVideoFormat, true);
            this.addTracker(this.mAudioFormat, false);
        }
        catch (Exception e) {
            this.mMainHandler.post(() -> Mp4Muxer.saveNewFileIfNeed$lambda$6(this, e));
            Logger.INSTANCE.e(TAG, "release media muxer failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void release() {
        try {
            MediaMuxer mediaMuxer = this.mMediaMuxer;
            if (mediaMuxer != null) {
                mediaMuxer.stop();
            }
            MediaMuxer mediaMuxer2 = this.mMediaMuxer;
            if (mediaMuxer2 != null) {
                mediaMuxer2.release();
            }
            this.insertDCIM(this.mContext, this.path, true);
            Logger.INSTANCE.i(TAG, "stop media muxer");
        }
        catch (Exception e) {
            this.mMainHandler.post(() -> Mp4Muxer.release$lambda$7(this, e));
            Logger.INSTANCE.e(TAG, "release media muxer failed, err = " + e.getLocalizedMessage(), e);
        }
        finally {
            this.mMediaMuxer = null;
            this.mAudioTrackerIndex = -1;
            this.mVideoTrackerIndex = -1;
            this.mAudioPts = 0L;
            this.mVideoPts = 0L;
        }
    }

    @Nullable
    public final String getSavePath() {
        return this.path;
    }

    private final void insertDCIM(Context context, String videoPath, boolean notifyOut) {
        block1: {
            Context context2 = context;
            if (context2 == null) break block1;
            Context ctx = context2;
            boolean bl = false;
            CharSequence charSequence = videoPath;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            ContentResolver content = ctx.getContentResolver();
            boolean bl2 = false;
            Uri uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            content.insert(uri, this.getVideoContentValues(videoPath));
            this.mMainHandler.post(() -> Mp4Muxer.insertDCIM$lambda$10$lambda$9$lambda$8(this));
        }
    }

    static /* synthetic */ void insertDCIM$default(Mp4Muxer mp4Muxer, Context context, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        mp4Muxer.insertDCIM(context, string, bl);
    }

    private final ContentValues getVideoContentValues(String path) {
        File file = new File(path);
        ContentValues values = new ContentValues();
        values.put("_data", path);
        values.put("_display_name", file.getName());
        values.put("mime_type", "video/mp4");
        values.put("_size", Long.valueOf(file.length()));
        values.put("duration", Long.valueOf(this.getLocalVideoDuration(file.getPath())));
        if (MediaUtils.INSTANCE.isAboveQ()) {
            String relativePath = Environment.DIRECTORY_DCIM + File.separator + "Camera";
            long dateExpires = (System.currentTimeMillis() + 86400000L) / (long)1000;
            values.put("relative_path", relativePath);
            values.put("date_expires", Long.valueOf(dateExpires));
        }
        return values;
    }

    public final boolean isMuxerStarter() {
        return this.mVideoTrackerIndex != -1 && (this.mAudioTrackerIndex != -1 || this.isVideoOnly);
    }

    private final long getLocalVideoDuration(String filePath) {
        long l;
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(filePath);
            String string = mmr.extractMetadata(9);
            l = string != null ? Long.parseLong(string) : 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            l = 0L;
        }
        return l;
    }

    private static final SimpleDateFormat mDateFormat_delegate$lambda$0() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.getDefault());
    }

    private static final String mCameraDir_delegate$lambda$1() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) + "/Camera";
    }

    private static final void addTracker$lambda$4$lambda$2(Mp4Muxer this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureCallBack;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onBegin();
        }
    }

    private static final void addTracker$lambda$4$lambda$3(Mp4Muxer this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureCallBack;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onBegin();
        }
    }

    private static final void addTracker$lambda$5(Mp4Muxer this$0, Exception $e) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureCallBack;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError($e.getLocalizedMessage());
        }
    }

    private static final void saveNewFileIfNeed$lambda$6(Mp4Muxer this$0, Exception $e) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureCallBack;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError($e.getLocalizedMessage());
        }
    }

    private static final void release$lambda$7(Mp4Muxer this$0, Exception $e) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureCallBack;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError($e.getLocalizedMessage());
        }
    }

    private static final void insertDCIM$lambda$10$lambda$9$lambda$8(Mp4Muxer this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.mCaptureCallBack;
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onComplete(this$0.path);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer$Companion;", "", "<init>", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

