/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode.audio;

import com.jiangdg.ausbc.encode.audio.IAudioStrategy;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.uac.UACAudioCallBack;
import com.jiangdg.uac.UACAudioHandler;
import com.jiangdg.usb.USBMonitor;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jiangdg/ausbc/encode/audio/AudioStrategyUAC;", "Lcom/jiangdg/ausbc/encode/audio/IAudioStrategy;", "ctrlBlock", "Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;", "<init>", "(Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;)V", "mUacHandler", "Lcom/jiangdg/uac/UACAudioHandler;", "mPcmDataQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "mCallback", "Lcom/jiangdg/uac/UACAudioCallBack;", "initAudioRecord", "", "startRecording", "stopRecording", "releaseAudioRecord", "read", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "isRecording", "", "getSampleRate", "", "getAudioFormat", "getChannelCount", "getChannelConfig", "Companion", "libausbc_release"})
public final class AudioStrategyUAC
implements IAudioStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final USBMonitor.UsbControlBlock ctrlBlock;
    @Nullable
    private UACAudioHandler mUacHandler;
    @NotNull
    private final ConcurrentLinkedQueue<byte[]> mPcmDataQueue;
    @NotNull
    private final UACAudioCallBack mCallback;
    @NotNull
    private static final String TAG = "AudioUac";
    private static final int MAX_QUEUE_SIZE = 10;
    private static final int SAMPLE_RATE = 8000;
    private static final int BIT_RESOLUTION = 8;
    private static final int CHANNEL_COUNT = 1;

    public AudioStrategyUAC(@NotNull USBMonitor.UsbControlBlock ctrlBlock) {
        Intrinsics.checkNotNullParameter((Object)ctrlBlock, (String)"ctrlBlock");
        this.ctrlBlock = ctrlBlock;
        this.mPcmDataQueue = new ConcurrentLinkedQueue();
        this.mCallback = arg_0 -> AudioStrategyUAC.mCallback$lambda$0(this, arg_0);
    }

    @Override
    public void initAudioRecord() {
        UACAudioHandler uACAudioHandler = this.mUacHandler = UACAudioHandler.createHandler((USBMonitor.UsbControlBlock)this.ctrlBlock);
        if (uACAudioHandler != null) {
            uACAudioHandler.initAudioRecord();
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "initAudioRecord");
        }
    }

    @Override
    public void startRecording() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.addDataCallBack(this.mCallback);
        }
        UACAudioHandler uACAudioHandler2 = this.mUacHandler;
        if (uACAudioHandler2 != null) {
            uACAudioHandler2.startRecording();
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "startRecording:");
        }
    }

    @Override
    public void stopRecording() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.stopRecording();
        }
        UACAudioHandler uACAudioHandler2 = this.mUacHandler;
        if (uACAudioHandler2 != null) {
            uACAudioHandler2.removeDataCallBack(this.mCallback);
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "stopRecording:");
        }
    }

    @Override
    public void releaseAudioRecord() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.releaseAudioRecord();
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "releaseAudioRecord:");
        }
    }

    @Override
    @Nullable
    public RawData read() {
        RawData rawData;
        byte[] byArray = this.mPcmDataQueue.poll();
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            rawData = new RawData(it, it.length);
        } else {
            rawData = null;
        }
        return rawData;
    }

    @Override
    public boolean isRecording() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        return uACAudioHandler != null ? uACAudioHandler.isRecording() : false;
    }

    @Override
    public int getSampleRate() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        return uACAudioHandler != null ? uACAudioHandler.getSampleRate() : 8000;
    }

    @Override
    public int getAudioFormat() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        return (uACAudioHandler != null ? uACAudioHandler.getBitResolution() == 8 : false) ? 3 : 2;
    }

    @Override
    public int getChannelCount() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        return uACAudioHandler != null ? uACAudioHandler.getChannelCount() : 1;
    }

    @Override
    public int getChannelConfig() {
        return this.getChannelCount() == 1 ? 16 : 12;
    }

    private static final void mCallback$lambda$0(AudioStrategyUAC this$0, byte[] data) {
        if (this$0.mPcmDataQueue.size() >= 10) {
            this$0.mPcmDataQueue.poll();
        }
        this$0.mPcmDataQueue.offer(data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jiangdg/ausbc/encode/audio/AudioStrategyUAC$Companion;", "", "<init>", "()V", "TAG", "", "MAX_QUEUE_SIZE", "", "SAMPLE_RATE", "BIT_RESOLUTION", "CHANNEL_COUNT", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

