/*
 * Decompiled with CFR 0.152.
 */
package net.ypresto.androidtranscoder.engine;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.ypresto.androidtranscoder.engine.QueuedMuxer;
import net.ypresto.androidtranscoder.engine.TrackTranscoder;

public class PassThroughTrackTranscoder
implements TrackTranscoder {
    private final MediaExtractor mExtractor;
    private final int mTrackIndex;
    private final QueuedMuxer mMuxer;
    private final QueuedMuxer.SampleType mSampleType;
    private final MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    private int mBufferSize;
    private ByteBuffer mBuffer;
    private boolean mIsEOS;
    private MediaFormat mActualOutputFormat;
    private long mWrittenPresentationTimeUs;
    private long mMaxVideoDuration;

    public PassThroughTrackTranscoder(MediaExtractor extractor, int trackIndex, QueuedMuxer muxer, QueuedMuxer.SampleType sampleType, long maxVideoDuration) {
        this.mExtractor = extractor;
        this.mTrackIndex = trackIndex;
        this.mMuxer = muxer;
        this.mSampleType = sampleType;
        this.mMaxVideoDuration = maxVideoDuration;
        this.mActualOutputFormat = this.mExtractor.getTrackFormat(this.mTrackIndex);
        this.mMuxer.setOutputFormat(this.mSampleType, this.mActualOutputFormat);
        this.mBufferSize = this.mActualOutputFormat.getInteger("max-input-size");
        this.mBuffer = ByteBuffer.allocateDirect(this.mBufferSize).order(ByteOrder.nativeOrder());
    }

    @Override
    public void setup() {
    }

    @Override
    public MediaFormat getDeterminedFormat() {
        return this.mActualOutputFormat;
    }

    @Override
    @SuppressLint(value={"Assert"})
    public boolean stepPipeline() {
        if (this.mIsEOS) {
            return false;
        }
        int trackIndex = this.mExtractor.getSampleTrackIndex();
        if (trackIndex < 0 || this.mMaxVideoDuration > 0L && this.mWrittenPresentationTimeUs >= this.mMaxVideoDuration) {
            this.mBuffer.clear();
            this.mBufferInfo.set(0, 0, 0L, 4);
            this.mMuxer.writeSampleData(this.mSampleType, this.mBuffer, this.mBufferInfo);
            this.mIsEOS = true;
            return true;
        }
        if (trackIndex != this.mTrackIndex) {
            return false;
        }
        this.mBuffer.clear();
        int sampleSize = this.mExtractor.readSampleData(this.mBuffer, 0);
        assert (sampleSize <= this.mBufferSize);
        boolean isKeyFrame = (this.mExtractor.getSampleFlags() & 1) != 0;
        int flags = isKeyFrame ? 1 : 0;
        this.mBufferInfo.set(0, sampleSize, this.mExtractor.getSampleTime(), flags);
        this.mMuxer.writeSampleData(this.mSampleType, this.mBuffer, this.mBufferInfo);
        this.mWrittenPresentationTimeUs = this.mBufferInfo.presentationTimeUs;
        this.mExtractor.advance();
        return true;
    }

    @Override
    public long getWrittenPresentationTimeUs() {
        return this.mWrittenPresentationTimeUs;
    }

    @Override
    public boolean isFinished() {
        return this.mIsEOS;
    }

    @Override
    public void release() {
    }
}

