/*
 * Decompiled with CFR 0.152.
 */
package eltos.simpledialogfragment.color;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import eltos.simpledialogfragment.R;
import eltos.simpledialogfragment.SimpleDialog;
import eltos.simpledialogfragment.color.ColorView;
import eltos.simpledialogfragment.color.SimpleColorWheelDialog;
import eltos.simpledialogfragment.list.AdvancedAdapter;
import eltos.simpledialogfragment.list.CustomListDialog;

public class SimpleColorDialog
extends CustomListDialog<SimpleColorDialog>
implements SimpleDialog.OnDialogResultListener {
    public static final String COLOR = "simpleColorDialog.color";
    public static final int NONE = -1;
    private static final int PICKER = -2;
    @ColorInt
    protected static final int[] DEFAULT_COLORS = new int[]{-769226, -1499549, -6543440, -10011977, -12627531, -14575885, -16537100, -16728876, -16738680, -11751600, -7617718, -3285959, -5317, -16121, -26624, -43230, -8825528, -6381922, -10453621};
    private static final String COLORS = "simpleColorDialog.colors";
    private static final String CUSTOM = "simpleColorDialog.custom";
    private static final String PICKER_DIALOG_TAG = "simpleColorDialog.picker";
    private int mCustomColor = -16777216;

    public SimpleColorDialog() {
        this.grid();
        this.gridColumnWidth(R.dimen.dialog_color_item_size);
        this.choiceMode(1);
        this.choiceMin(1);
        this.colors(DEFAULT_COLORS);
    }

    public static SimpleColorDialog build() {
        return new SimpleColorDialog();
    }

    public SimpleColorDialog colors(@ColorInt int[] colors) {
        this.getArguments().putIntArray(COLORS, colors);
        return this;
    }

    public SimpleColorDialog colorPreset(@ColorInt int color) {
        this.getArguments().putInt(COLOR, color);
        return this;
    }

    public SimpleColorDialog allowCustom(boolean allow) {
        return (SimpleColorDialog)this.setArg(CUSTOM, allow);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mCustomColor = savedInstanceState.getInt(CUSTOM, this.mCustomColor);
        }
    }

    @Override
    protected AdvancedAdapter onCreateAdapter() {
        int[] colors = this.getArguments().getIntArray(COLORS);
        if (colors == null) {
            colors = new int[]{};
        }
        if (this.getArguments().containsKey(COLOR)) {
            int preset = this.getArguments().getInt(COLOR, -1);
            for (int i = 0; i < colors.length; ++i) {
                if (colors[i] != preset) continue;
                this.choicePreset(i);
                break;
            }
            if (preset != -1) {
                this.mCustomColor = preset;
            }
        }
        this.getListView().setSelector((Drawable)new ColorDrawable(0));
        return new ColorAdapter(colors, this.getArguments().getBoolean(CUSTOM));
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(CUSTOM, this.mCustomColor);
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (id2 == -2L) {
            SimpleColorWheelDialog.build().alpha(false).color(this.mCustomColor).show((Fragment)this, PICKER_DIALOG_TAG);
        }
    }

    @Override
    public boolean onResult(@NonNull String dialogTag, int which, @NonNull Bundle extras) {
        if (PICKER_DIALOG_TAG.equals(dialogTag) && which == -1) {
            this.mCustomColor = extras.getInt("SimpleColorWheelDialog.color");
            this.notifyDataSetChanged();
        }
        return true;
    }

    @Override
    protected Bundle onResult(int which) {
        Bundle b = super.onResult(which);
        int color = (int)b.getLong("CustomListDialogselectedSingleId");
        if (color == -2) {
            b.putInt(COLOR, this.mCustomColor);
        } else {
            b.putInt(COLOR, color);
        }
        return b;
    }

    private class ColorAdapter
    extends AdvancedAdapter<Integer> {
        ColorAdapter(int[] colors, boolean addCustomField) {
            if (colors == null) {
                colors = new int[]{};
            }
            Integer[] cs = new Integer[colors.length + (addCustomField ? 1 : 0)];
            for (int i = 0; i < colors.length; ++i) {
                cs[i] = colors[i];
            }
            if (addCustomField) {
                cs[cs.length - 1] = -2;
            }
            this.setData(cs, new AdvancedAdapter.ItemIdentifier<Integer>(){

                @Override
                @Nullable
                public Long getIdForItem(Integer color) {
                    return (long)color;
                }
            });
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ColorView item = convertView instanceof ColorView ? (ColorView)convertView : new ColorView(SimpleColorDialog.this.getContext());
            int color = (Integer)this.getItem(position);
            if (color == -2) {
                item.setColor(SimpleColorDialog.this.mCustomColor);
                item.setStyle(ColorView.Style.PALETTE);
            } else {
                item.setColor((Integer)this.getItem(position));
                item.setStyle(ColorView.Style.CHECK);
            }
            return super.getView(position, (View)item, parent);
        }
    }
}

