/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import com.jakewharton.scalpel.ScalpelFrameLayout;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import me.ele.uetool.R;
import me.ele.uetool.TransparentActivity;
import me.ele.uetool.UETSubMenu;
import me.ele.uetool.UETool;
import me.ele.uetool.Util;

public class UETMenu
extends LinearLayout {
    private View vMenu;
    private ViewGroup vSubMenuContainer;
    private ValueAnimator animator;
    private Interpolator defaultInterpolator = new AccelerateDecelerateInterpolator();
    private List<UETSubMenu.SubMenu> subMenus = new ArrayList<UETSubMenu.SubMenu>();
    private WindowManager windowManager;
    private WindowManager.LayoutParams params = new WindowManager.LayoutParams();
    private int touchSlop;
    private int y;

    public UETMenu(Context context, int y) {
        super(context);
        UETMenu.inflate((Context)context, (int)R.layout.uet_menu_layout, (ViewGroup)this);
        this.setGravity(16);
        this.y = y;
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.vMenu = this.findViewById(R.id.menu);
        this.vSubMenuContainer = (ViewGroup)this.findViewById(R.id.sub_menu_container);
        Resources resources = context.getResources();
        this.subMenus.add(new UETSubMenu.SubMenu(resources.getString(R.string.uet_catch_view), R.drawable.uet_edit_attr, new View.OnClickListener(){

            public void onClick(View v) {
                UETMenu.this.open(1);
            }
        }));
        this.subMenus.add(new UETSubMenu.SubMenu(resources.getString(R.string.uet_relative_location), R.drawable.uet_relative_position, new View.OnClickListener(){

            public void onClick(View v) {
                UETMenu.this.open(3);
            }
        }));
        this.subMenus.add(new UETSubMenu.SubMenu(resources.getString(R.string.uet_grid), R.drawable.uet_show_gridding, new View.OnClickListener(){

            public void onClick(View v) {
                UETMenu.this.open(2);
            }
        }));
        this.subMenus.add(new UETSubMenu.SubMenu(resources.getString(R.string.uet_scalpel), R.drawable.uet_scalpel, new View.OnClickListener(){

            public void onClick(View view) {
                ViewGroup decorView = (ViewGroup)Util.getCurrentActivity().getWindow().getDecorView();
                ViewGroup content = (ViewGroup)decorView.findViewById(0x1020002);
                View contentChild = content.getChildAt(0);
                if (contentChild != null) {
                    if (contentChild instanceof ScalpelFrameLayout) {
                        content.removeAllViews();
                        View originContent = ((ScalpelFrameLayout)contentChild).getChildAt(0);
                        ((ScalpelFrameLayout)contentChild).removeAllViews();
                        content.addView(originContent);
                    } else {
                        content.removeAllViews();
                        ScalpelFrameLayout frameLayout = new ScalpelFrameLayout(UETMenu.this.getContext());
                        frameLayout.setLayerInteractionEnabled(true);
                        frameLayout.setDrawIds(true);
                        frameLayout.addView(contentChild);
                        content.addView((View)frameLayout);
                    }
                }
            }
        }));
        for (UETSubMenu.SubMenu subMenu : this.subMenus) {
            UETSubMenu uetSubMenu = new UETSubMenu(this.getContext());
            uetSubMenu.update(subMenu);
            this.vSubMenuContainer.addView((View)uetSubMenu);
        }
        this.vMenu.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UETMenu.this.startAnim();
            }
        });
        this.vMenu.setOnTouchListener(new View.OnTouchListener(){
            private float downX;
            private float downY;
            private float lastY;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.downX = event.getRawX();
                        this.lastY = this.downY = event.getRawY();
                        break;
                    }
                    case 2: {
                        ((UETMenu)UETMenu.this).params.y = (int)((float)((UETMenu)UETMenu.this).params.y + (event.getRawY() - this.lastY));
                        ((UETMenu)UETMenu.this).params.y = Math.max(0, ((UETMenu)UETMenu.this).params.y);
                        UETMenu.this.windowManager.updateViewLayout((View)UETMenu.this, (ViewGroup.LayoutParams)UETMenu.this.params);
                        this.lastY = event.getRawY();
                        break;
                    }
                    case 1: {
                        if (!(Math.abs(event.getRawX() - this.downX) < (float)UETMenu.this.touchSlop) || !(Math.abs(event.getRawY() - this.downY) < (float)UETMenu.this.touchSlop)) break;
                        try {
                            Field field = View.class.getDeclaredField("mListenerInfo");
                            field.setAccessible(true);
                            Object object = field.get(UETMenu.this.vMenu);
                            field = object.getClass().getDeclaredField("mOnClickListener");
                            field.setAccessible(true);
                            object = field.get(object);
                            if (object == null || !(object instanceof View.OnClickListener)) break;
                            ((View.OnClickListener)object).onClick(UETMenu.this.vMenu);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return true;
            }
        });
    }

    private void startAnim() {
        this.ensureAnim();
        final boolean isOpen = this.vSubMenuContainer.getTranslationX() <= (float)(-this.vSubMenuContainer.getWidth());
        this.animator.setInterpolator((TimeInterpolator)(isOpen ? this.defaultInterpolator : new ReverseInterpolator((TimeInterpolator)this.defaultInterpolator)));
        this.animator.removeAllListeners();
        this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                UETMenu.this.vSubMenuContainer.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                if (!isOpen) {
                    UETMenu.this.vSubMenuContainer.setVisibility(8);
                }
            }
        });
        this.animator.start();
    }

    private void ensureAnim() {
        if (this.animator == null) {
            this.animator = ValueAnimator.ofInt((int[])new int[]{-this.vSubMenuContainer.getWidth(), 0});
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    UETMenu.this.vSubMenuContainer.setTranslationX((float)((Integer)animation.getAnimatedValue()).intValue());
                }
            });
            this.animator.setDuration(400L);
        }
    }

    private void open() {
        this.open(-1);
    }

    private void open(int type) {
        Activity currentTopActivity = Util.getCurrentActivity();
        if (currentTopActivity == null) {
            return;
        }
        if (currentTopActivity.getClass() == TransparentActivity.class) {
            currentTopActivity.finish();
            return;
        }
        Intent intent = new Intent((Context)currentTopActivity, TransparentActivity.class);
        intent.putExtra("extra_type", type);
        currentTopActivity.startActivity(intent);
        currentTopActivity.overridePendingTransition(0, 0);
        UETool.getInstance().setTargetActivity(currentTopActivity);
    }

    public void show() {
        try {
            this.windowManager.addView((View)this, (ViewGroup.LayoutParams)this.getWindowLayoutParams());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int dismiss() {
        try {
            this.windowManager.removeView((View)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.params.y;
    }

    private WindowManager.LayoutParams getWindowLayoutParams() {
        this.params.width = -2;
        this.params.height = -2;
        this.params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
        this.params.flags = 8;
        this.params.format = -3;
        this.params.gravity = 51;
        this.params.x = 10;
        this.params.y = this.y;
        return this.params;
    }

    private static class ReverseInterpolator
    implements TimeInterpolator {
        private TimeInterpolator mWrappedInterpolator;

        ReverseInterpolator(TimeInterpolator interpolator) {
            this.mWrappedInterpolator = interpolator;
        }

        public float getInterpolation(float input) {
            return this.mWrappedInterpolator.getInterpolation(Math.abs(input - 1.0f));
        }
    }
}

