/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import me.ele.uetool.AttrsDialog;
import me.ele.uetool.CollectViewsLayout;
import me.ele.uetool.base.DimenUtil;
import me.ele.uetool.base.Element;

public class EditAttrLayout
extends CollectViewsLayout {
    private final int moveUnit = DimenUtil.dip2px((float)1.0f);
    private final int lineBorderDistance = DimenUtil.dip2px((float)5.0f);
    private Paint areaPaint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(0x30000000);
        }
    };
    private Element targetElement;
    private AttrsDialog dialog;
    private IMode mode = new ShowMode();
    private float lastX;
    private float lastY;
    private OnDragListener onDragListener;

    public EditAttrLayout(Context context) {
        super(context);
    }

    public EditAttrLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public EditAttrLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.targetElement != null) {
            canvas.drawRect(this.targetElement.getRect(), this.areaPaint);
            this.mode.onDraw(canvas);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.lastX = event.getX();
                this.lastY = event.getY();
                break;
            }
            case 1: {
                this.mode.triggerActionUp(event);
                break;
            }
            case 2: {
                this.mode.triggerActionMove(event);
            }
        }
        return true;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.targetElement = null;
        this.dismissAttrsDialog();
    }

    public void setOnDragListener(OnDragListener onDragListener) {
        this.onDragListener = onDragListener;
    }

    public void dismissAttrsDialog() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    public static interface OnDragListener {
        public void showOffset(String var1);
    }

    public static interface IMode {
        public void onDraw(Canvas var1);

        public void triggerActionMove(MotionEvent var1);

        public void triggerActionUp(MotionEvent var1);
    }

    class ShowMode
    implements IMode {
        ShowMode() {
        }

        @Override
        public void onDraw(Canvas canvas) {
            Rect rect = EditAttrLayout.this.targetElement.getRect();
            EditAttrLayout.this.drawLineWithText(canvas, rect.left, rect.top - EditAttrLayout.this.lineBorderDistance, rect.right, rect.top - EditAttrLayout.this.lineBorderDistance);
            EditAttrLayout.this.drawLineWithText(canvas, rect.right + EditAttrLayout.this.lineBorderDistance, rect.top, rect.right + EditAttrLayout.this.lineBorderDistance, rect.bottom);
        }

        @Override
        public void triggerActionMove(MotionEvent event) {
        }

        @Override
        public void triggerActionUp(MotionEvent event) {
            Element element = EditAttrLayout.this.getTargetElement(event.getX(), event.getY());
            if (element != null) {
                EditAttrLayout.this.targetElement = element;
                EditAttrLayout.this.invalidate();
                if (EditAttrLayout.this.dialog == null) {
                    EditAttrLayout.this.dialog = new AttrsDialog(EditAttrLayout.this.getContext());
                    EditAttrLayout.this.dialog.setAttrDialogCallback(new AttrsDialog.AttrDialogCallback(){

                        @Override
                        public void enableMove() {
                            EditAttrLayout.this.mode = new MoveMode();
                            EditAttrLayout.this.dismissAttrsDialog();
                        }

                        @Override
                        public void showValidViews(int position, boolean isChecked) {
                            int positionStart = position + 1;
                            if (isChecked) {
                                EditAttrLayout.this.dialog.notifyValidViewItemInserted(positionStart, EditAttrLayout.this.getTargetElements(EditAttrLayout.this.lastX, EditAttrLayout.this.lastY), EditAttrLayout.this.targetElement);
                            } else {
                                EditAttrLayout.this.dialog.notifyItemRangeRemoved(positionStart);
                            }
                        }

                        @Override
                        public void selectView(Element element) {
                            EditAttrLayout.this.targetElement = element;
                            EditAttrLayout.this.dismissAttrsDialog();
                            EditAttrLayout.this.dialog.show(EditAttrLayout.this.targetElement);
                        }
                    });
                    EditAttrLayout.this.dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                        public void onDismiss(DialogInterface dialog) {
                            if (EditAttrLayout.this.targetElement != null) {
                                EditAttrLayout.this.targetElement.reset();
                                EditAttrLayout.this.invalidate();
                            }
                        }
                    });
                }
                EditAttrLayout.this.dialog.show(EditAttrLayout.this.targetElement);
            }
        }
    }

    class MoveMode
    implements IMode {
        MoveMode() {
        }

        @Override
        public void onDraw(Canvas canvas) {
            Rect rect = EditAttrLayout.this.targetElement.getRect();
            Rect originRect = EditAttrLayout.this.targetElement.getOriginRect();
            canvas.drawRect(originRect, EditAttrLayout.this.dashLinePaint);
            Element parentElement = EditAttrLayout.this.targetElement.getParentElement();
            if (parentElement != null) {
                Rect parentRect = parentElement.getRect();
                int x = rect.left + rect.width() / 2;
                int y = rect.top + rect.height() / 2;
                EditAttrLayout.this.drawLineWithText(canvas, rect.left, y, parentRect.left, y, DimenUtil.dip2px((float)2.0f));
                EditAttrLayout.this.drawLineWithText(canvas, x, rect.top, x, parentRect.top, DimenUtil.dip2px((float)2.0f));
                EditAttrLayout.this.drawLineWithText(canvas, rect.right, y, parentRect.right, y, DimenUtil.dip2px((float)2.0f));
                EditAttrLayout.this.drawLineWithText(canvas, x, rect.bottom, x, parentRect.bottom, DimenUtil.dip2px((float)2.0f));
            }
            if (EditAttrLayout.this.onDragListener != null) {
                EditAttrLayout.this.onDragListener.showOffset("Offset:\nx -> " + DimenUtil.px2dip((float)(rect.left - originRect.left), (boolean)true) + " y -> " + DimenUtil.px2dip((float)(rect.top - originRect.top), (boolean)true));
            }
        }

        @Override
        public void triggerActionMove(MotionEvent event) {
            if (EditAttrLayout.this.targetElement != null) {
                float diffY;
                boolean changed = false;
                View view = EditAttrLayout.this.targetElement.getView();
                float diffX = event.getX() - EditAttrLayout.this.lastX;
                if (Math.abs(diffX) >= (float)EditAttrLayout.this.moveUnit) {
                    view.setTranslationX(view.getTranslationX() + diffX);
                    EditAttrLayout.this.lastX = event.getX();
                    changed = true;
                }
                if (Math.abs(diffY = event.getY() - EditAttrLayout.this.lastY) >= (float)EditAttrLayout.this.moveUnit) {
                    view.setTranslationY(view.getTranslationY() + diffY);
                    EditAttrLayout.this.lastY = event.getY();
                    changed = true;
                }
                if (changed) {
                    EditAttrLayout.this.targetElement.reset();
                    EditAttrLayout.this.invalidate();
                }
            }
        }

        @Override
        public void triggerActionUp(MotionEvent event) {
        }
    }
}

