/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.Nullable;
import buzz.getcoco.exoplayer2.Format;
import buzz.getcoco.exoplayer2.source.TrackGroup;
import buzz.getcoco.exoplayer2.source.TrackGroupArray;
import buzz.getcoco.exoplayer2.trackselection.DefaultTrackSelector;
import buzz.getcoco.exoplayer2.trackselection.MappingTrackSelector;
import buzz.getcoco.exoplayer2.ui.DefaultTrackNameProvider;
import buzz.getcoco.exoplayer2.ui.R;
import buzz.getcoco.exoplayer2.ui.TrackNameProvider;
import buzz.getcoco.exoplayer2.util.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class TrackSelectionView
extends LinearLayout {
    private final int selectableItemBackgroundResourceId;
    private final LayoutInflater inflater;
    private final CheckedTextView disableView;
    private final CheckedTextView defaultView;
    private final ComponentListener componentListener;
    private final SparseArray<DefaultTrackSelector.SelectionOverride> overrides;
    private boolean allowAdaptiveSelections;
    private boolean allowMultipleOverrides;
    private TrackNameProvider trackNameProvider;
    private CheckedTextView[][] trackViews;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @MonotonicNonNull MappingTrackSelector.MappedTrackInfo mappedTrackInfo;
    private int rendererIndex;
    private TrackGroupArray trackGroups;
    private boolean isDisabled;
    @Nullable
    private Comparator<TrackInfo> trackInfoComparator;
    @Nullable
    private TrackSelectionListener listener;

    public TrackSelectionView(Context context) {
        this(context, null);
    }

    public TrackSelectionView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TrackSelectionView(Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        this.overrides = new SparseArray();
        this.setSaveFromParentEnabled(false);
        TypedArray attributeArray = context.getTheme().obtainStyledAttributes(new int[]{16843534});
        this.selectableItemBackgroundResourceId = attributeArray.getResourceId(0, 0);
        attributeArray.recycle();
        this.inflater = LayoutInflater.from((Context)context);
        this.componentListener = new ComponentListener();
        this.trackNameProvider = new DefaultTrackNameProvider(this.getResources());
        this.trackGroups = TrackGroupArray.EMPTY;
        this.disableView = (CheckedTextView)this.inflater.inflate(17367055, (ViewGroup)this, false);
        this.disableView.setBackgroundResource(this.selectableItemBackgroundResourceId);
        this.disableView.setText(R.string.exo_track_selection_none);
        this.disableView.setEnabled(false);
        this.disableView.setFocusable(true);
        this.disableView.setOnClickListener((View.OnClickListener)this.componentListener);
        this.disableView.setVisibility(8);
        this.addView((View)this.disableView);
        this.addView(this.inflater.inflate(R.layout.exo_list_divider, (ViewGroup)this, false));
        this.defaultView = (CheckedTextView)this.inflater.inflate(17367055, (ViewGroup)this, false);
        this.defaultView.setBackgroundResource(this.selectableItemBackgroundResourceId);
        this.defaultView.setText(R.string.exo_track_selection_auto);
        this.defaultView.setEnabled(false);
        this.defaultView.setFocusable(true);
        this.defaultView.setOnClickListener((View.OnClickListener)this.componentListener);
        this.addView((View)this.defaultView);
    }

    public void setAllowAdaptiveSelections(boolean allowAdaptiveSelections) {
        if (this.allowAdaptiveSelections != allowAdaptiveSelections) {
            this.allowAdaptiveSelections = allowAdaptiveSelections;
            this.updateViews();
        }
    }

    public void setAllowMultipleOverrides(boolean allowMultipleOverrides) {
        if (this.allowMultipleOverrides != allowMultipleOverrides) {
            this.allowMultipleOverrides = allowMultipleOverrides;
            if (!allowMultipleOverrides && this.overrides.size() > 1) {
                for (int i = this.overrides.size() - 1; i > 0; --i) {
                    this.overrides.remove(i);
                }
            }
            this.updateViews();
        }
    }

    public void setShowDisableOption(boolean showDisableOption) {
        this.disableView.setVisibility(showDisableOption ? 0 : 8);
    }

    public void setTrackNameProvider(TrackNameProvider trackNameProvider) {
        this.trackNameProvider = (TrackNameProvider)Assertions.checkNotNull((Object)trackNameProvider);
        this.updateViews();
    }

    public void init(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int rendererIndex, boolean isDisabled, List<DefaultTrackSelector.SelectionOverride> overrides, @Nullable Comparator<Format> trackFormatComparator, @Nullable TrackSelectionListener listener) {
        this.mappedTrackInfo = mappedTrackInfo;
        this.rendererIndex = rendererIndex;
        this.isDisabled = isDisabled;
        this.trackInfoComparator = trackFormatComparator == null ? null : (o1, o2) -> trackFormatComparator.compare(o1.format, o2.format);
        this.listener = listener;
        int maxOverrides = this.allowMultipleOverrides ? overrides.size() : Math.min(overrides.size(), 1);
        for (int i = 0; i < maxOverrides; ++i) {
            DefaultTrackSelector.SelectionOverride override = overrides.get(i);
            this.overrides.put(override.groupIndex, (Object)override);
        }
        this.updateViews();
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public List<DefaultTrackSelector.SelectionOverride> getOverrides() {
        ArrayList<DefaultTrackSelector.SelectionOverride> overrideList = new ArrayList<DefaultTrackSelector.SelectionOverride>(this.overrides.size());
        for (int i = 0; i < this.overrides.size(); ++i) {
            overrideList.add((DefaultTrackSelector.SelectionOverride)this.overrides.valueAt(i));
        }
        return overrideList;
    }

    private void updateViews() {
        for (int i = this.getChildCount() - 1; i >= 3; --i) {
            this.removeViewAt(i);
        }
        if (this.mappedTrackInfo == null) {
            this.disableView.setEnabled(false);
            this.defaultView.setEnabled(false);
            return;
        }
        this.disableView.setEnabled(true);
        this.defaultView.setEnabled(true);
        this.trackGroups = this.mappedTrackInfo.getTrackGroups(this.rendererIndex);
        this.trackViews = new CheckedTextView[this.trackGroups.length][];
        boolean enableMultipleChoiceForMultipleOverrides = this.shouldEnableMultiGroupSelection();
        for (int groupIndex = 0; groupIndex < this.trackGroups.length; ++groupIndex) {
            int trackIndex;
            TrackGroup group = this.trackGroups.get(groupIndex);
            boolean enableMultipleChoiceForAdaptiveSelections = this.shouldEnableAdaptiveSelection(groupIndex);
            this.trackViews[groupIndex] = new CheckedTextView[group.length];
            TrackInfo[] trackInfos = new TrackInfo[group.length];
            for (trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                trackInfos[trackIndex] = new TrackInfo(groupIndex, trackIndex, group.getFormat(trackIndex));
            }
            if (this.trackInfoComparator != null) {
                Arrays.sort(trackInfos, this.trackInfoComparator);
            }
            for (trackIndex = 0; trackIndex < trackInfos.length; ++trackIndex) {
                if (trackIndex == 0) {
                    this.addView(this.inflater.inflate(R.layout.exo_list_divider, (ViewGroup)this, false));
                }
                int trackViewLayoutId = enableMultipleChoiceForAdaptiveSelections || enableMultipleChoiceForMultipleOverrides ? 0x1090010 : 17367055;
                CheckedTextView trackView = (CheckedTextView)this.inflater.inflate(trackViewLayoutId, (ViewGroup)this, false);
                trackView.setBackgroundResource(this.selectableItemBackgroundResourceId);
                trackView.setText((CharSequence)this.trackNameProvider.getTrackName(trackInfos[trackIndex].format));
                trackView.setTag((Object)trackInfos[trackIndex]);
                if (this.mappedTrackInfo.getTrackSupport(this.rendererIndex, groupIndex, trackIndex) == 4) {
                    trackView.setFocusable(true);
                    trackView.setOnClickListener((View.OnClickListener)this.componentListener);
                } else {
                    trackView.setFocusable(false);
                    trackView.setEnabled(false);
                }
                this.trackViews[groupIndex][trackIndex] = trackView;
                this.addView((View)trackView);
            }
        }
        this.updateViewStates();
    }

    private void updateViewStates() {
        this.disableView.setChecked(this.isDisabled);
        this.defaultView.setChecked(!this.isDisabled && this.overrides.size() == 0);
        for (int i = 0; i < this.trackViews.length; ++i) {
            DefaultTrackSelector.SelectionOverride override = (DefaultTrackSelector.SelectionOverride)this.overrides.get(i);
            for (int j = 0; j < this.trackViews[i].length; ++j) {
                if (override != null) {
                    TrackInfo trackInfo = (TrackInfo)Assertions.checkNotNull((Object)this.trackViews[i][j].getTag());
                    this.trackViews[i][j].setChecked(override.containsTrack(trackInfo.trackIndex));
                    continue;
                }
                this.trackViews[i][j].setChecked(false);
            }
        }
    }

    private void onClick(View view) {
        if (view == this.disableView) {
            this.onDisableViewClicked();
        } else if (view == this.defaultView) {
            this.onDefaultViewClicked();
        } else {
            this.onTrackViewClicked(view);
        }
        this.updateViewStates();
        if (this.listener != null) {
            this.listener.onTrackSelectionChanged(this.getIsDisabled(), this.getOverrides());
        }
    }

    private void onDisableViewClicked() {
        this.isDisabled = true;
        this.overrides.clear();
    }

    private void onDefaultViewClicked() {
        this.isDisabled = false;
        this.overrides.clear();
    }

    private void onTrackViewClicked(View view) {
        this.isDisabled = false;
        TrackInfo trackInfo = (TrackInfo)Assertions.checkNotNull((Object)view.getTag());
        int groupIndex = trackInfo.groupIndex;
        int trackIndex = trackInfo.trackIndex;
        DefaultTrackSelector.SelectionOverride override = (DefaultTrackSelector.SelectionOverride)this.overrides.get(groupIndex);
        Assertions.checkNotNull((Object)this.mappedTrackInfo);
        if (override == null) {
            if (!this.allowMultipleOverrides && this.overrides.size() > 0) {
                this.overrides.clear();
            }
            this.overrides.put(groupIndex, (Object)new DefaultTrackSelector.SelectionOverride(groupIndex, new int[]{trackIndex}));
        } else {
            boolean isUsingCheckBox;
            int overrideLength = override.length;
            int[] overrideTracks = override.tracks;
            boolean isCurrentlySelected = ((CheckedTextView)view).isChecked();
            boolean isAdaptiveAllowed = this.shouldEnableAdaptiveSelection(groupIndex);
            boolean bl = isUsingCheckBox = isAdaptiveAllowed || this.shouldEnableMultiGroupSelection();
            if (isCurrentlySelected && isUsingCheckBox) {
                if (overrideLength == 1) {
                    this.overrides.remove(groupIndex);
                } else {
                    int[] tracks = TrackSelectionView.getTracksRemoving(overrideTracks, trackIndex);
                    this.overrides.put(groupIndex, (Object)new DefaultTrackSelector.SelectionOverride(groupIndex, tracks));
                }
            } else if (!isCurrentlySelected) {
                if (isAdaptiveAllowed) {
                    int[] tracks = TrackSelectionView.getTracksAdding(overrideTracks, trackIndex);
                    this.overrides.put(groupIndex, (Object)new DefaultTrackSelector.SelectionOverride(groupIndex, tracks));
                } else {
                    this.overrides.put(groupIndex, (Object)new DefaultTrackSelector.SelectionOverride(groupIndex, new int[]{trackIndex}));
                }
            }
        }
    }

    @RequiresNonNull(value={"mappedTrackInfo"})
    private boolean shouldEnableAdaptiveSelection(int groupIndex) {
        return this.allowAdaptiveSelections && this.trackGroups.get((int)groupIndex).length > 1 && this.mappedTrackInfo.getAdaptiveSupport(this.rendererIndex, groupIndex, false) != 0;
    }

    private boolean shouldEnableMultiGroupSelection() {
        return this.allowMultipleOverrides && this.trackGroups.length > 1;
    }

    private static int[] getTracksAdding(int[] tracks, int addedTrack) {
        tracks = Arrays.copyOf(tracks, tracks.length + 1);
        tracks[tracks.length - 1] = addedTrack;
        return tracks;
    }

    private static int[] getTracksRemoving(int[] tracks, int removedTrack) {
        int[] newTracks = new int[tracks.length - 1];
        int trackCount = 0;
        for (int track : tracks) {
            if (track == removedTrack) continue;
            newTracks[trackCount++] = track;
        }
        return newTracks;
    }

    private static final class TrackInfo {
        public final int groupIndex;
        public final int trackIndex;
        public final Format format;

        public TrackInfo(int groupIndex, int trackIndex, Format format) {
            this.groupIndex = groupIndex;
            this.trackIndex = trackIndex;
            this.format = format;
        }
    }

    private class ComponentListener
    implements View.OnClickListener {
        private ComponentListener() {
        }

        public void onClick(View view) {
            TrackSelectionView.this.onClick(view);
        }
    }

    public static interface TrackSelectionListener {
        public void onTrackSelectionChanged(boolean var1, List<DefaultTrackSelector.SelectionOverride> var2);
    }
}

