/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.util;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.net.UnknownHostException;
import org.checkerframework.dataflow.qual.Pure;

public final class Log {
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_INFO = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_ERROR = 3;
    public static final int LOG_LEVEL_OFF = Integer.MAX_VALUE;
    private static int logLevel = 0;
    private static boolean logStackTraces = true;

    private Log() {
    }

    @Pure
    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int logLevel) {
        Log.logLevel = logLevel;
    }

    public static void setLogStackTraces(boolean logStackTraces) {
        Log.logStackTraces = logStackTraces;
    }

    @Pure
    public static void d(String tag, String message) {
        if (logLevel == 0) {
            android.util.Log.d((String)tag, (String)message);
        }
    }

    @Pure
    public static void d(String tag, String message, @Nullable Throwable throwable) {
        Log.d(tag, Log.appendThrowableString(message, throwable));
    }

    @Pure
    public static void i(String tag, String message) {
        if (logLevel <= 1) {
            android.util.Log.i((String)tag, (String)message);
        }
    }

    @Pure
    public static void i(String tag, String message, @Nullable Throwable throwable) {
        Log.i(tag, Log.appendThrowableString(message, throwable));
    }

    @Pure
    public static void w(String tag, String message) {
        if (logLevel <= 2) {
            android.util.Log.w((String)tag, (String)message);
        }
    }

    @Pure
    public static void w(String tag, String message, @Nullable Throwable throwable) {
        Log.w(tag, Log.appendThrowableString(message, throwable));
    }

    @Pure
    public static void e(String tag, String message) {
        if (logLevel <= 3) {
            android.util.Log.e((String)tag, (String)message);
        }
    }

    @Pure
    public static void e(String tag, String message, @Nullable Throwable throwable) {
        Log.e(tag, Log.appendThrowableString(message, throwable));
    }

    @Pure
    @Nullable
    public static String getThrowableString(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (Log.isCausedByUnknownHostException(throwable)) {
            return "UnknownHostException (no network)";
        }
        if (!logStackTraces) {
            return throwable.getMessage();
        }
        return android.util.Log.getStackTraceString((Throwable)throwable).trim().replace("\t", "    ");
    }

    @Pure
    private static String appendThrowableString(String message, @Nullable Throwable throwable) {
        String throwableString = Log.getThrowableString(throwable);
        if (!TextUtils.isEmpty((CharSequence)throwableString)) {
            message = message + "\n  " + throwableString.replace("\n", "\n  ") + '\n';
        }
        return message;
    }

    @Pure
    private static boolean isCausedByUnknownHostException(@Nullable Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof UnknownHostException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }
}

