/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.vectors;

import net.sacredlabyrinth.Phaed.PreciousStones.vectors.AbstractVec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Vec
extends AbstractVec {
    public Vec(int x, int y, int z, String world) {
        super(x, y, z, world);
    }

    public Vec(String serialized) {
        String[] unpacked = serialized.split("[:]");
        this.setX(Integer.parseInt(unpacked[0]));
        this.setY(Integer.parseInt(unpacked[1]));
        this.setZ(Integer.parseInt(unpacked[2]));
        this.setWorld(unpacked[3]);
    }

    public Vec(Vec vec) {
        super(vec.getX(), vec.getY(), vec.getZ(), vec.getWorld());
    }

    public Vec(Block block) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
    }

    public Vec(AbstractVec av) {
        super(av.getX(), av.getY(), av.getZ(), av.getWorld());
    }

    public Vec(Location loc) {
        super(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getWorld().getName());
    }

    public double distance(Vec vec) {
        return Math.sqrt(Math.pow(vec.getX() - this.getX(), 2.0) + Math.pow(vec.getY() - this.getY(), 2.0) + Math.pow(vec.getZ() - this.getZ(), 2.0));
    }

    public Vec add(int x, int y, int z) {
        return new Vec(this.getX() + x, this.getY() + y, this.getZ() + z, this.getWorld());
    }

    public Vec subtract(int x, int y, int z) {
        return new Vec(this.getX() - x, this.getY() - y, this.getZ() - z, this.getWorld());
    }

    public Vec add(Vec vec) {
        return new Vec(this.getX() + vec.getX(), this.getY() + vec.getY(), this.getZ() + vec.getZ(), this.getWorld());
    }

    public Vec subtract(Vec vec) {
        return new Vec(this.getX() - vec.getX(), this.getY() - vec.getY(), this.getZ() - vec.getZ(), this.getWorld());
    }

    public Vec multiply(int m) {
        return new Vec(this.getX() * m, this.getY() * m, this.getZ() * m, this.getWorld());
    }

    public String serialize() {
        return this.getX() + ":" + this.getY() + ":" + this.getZ() + ":" + this.getWorld();
    }

    public World toWorld() {
        return Bukkit.getWorld((String)this.getWorld());
    }
}

