/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class UnprotectableManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public boolean touchingUnprotectableBlock(Block block) {
        return this.getTouchingUnprotectableBlock(block) != null;
    }

    public Block getTouchingUnprotectableBlock(Block block) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Block touching = block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z);
                    if (!this.plugin.getSettingsManager().isUnprotectableType(touching)) continue;
                    return block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z);
                }
            }
        }
        return null;
    }

    public Block existsUnprotectableBlock(Block fieldblock) {
        int maxy;
        int miny;
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(fieldblock);
        if (fs == null) {
            return null;
        }
        if (!this.plugin.getSettingsManager().hasUnprotectableBlocks()) {
            return null;
        }
        int minx = fieldblock.getX() - fs.getRadius();
        int maxx = fieldblock.getX() + fs.getRadius();
        int minz = fieldblock.getZ() - fs.getRadius();
        int maxz = fieldblock.getZ() + fs.getRadius();
        if (fs.getCustomHeight() > 0) {
            miny = fieldblock.getY() - Math.max(fs.getCustomHeight() - 1, 0) / 2;
            maxy = fieldblock.getY() + Math.max(fs.getCustomHeight() - 1, 0) / 2;
        } else {
            miny = fieldblock.getY() - Math.max(fs.getRadius() - 1, 0) / 2;
            maxy = fieldblock.getY() + Math.max(fs.getRadius() - 1, 0) / 2;
        }
        Field field = this.plugin.getForceFieldManager().getField(fieldblock);
        if (field != null) {
            minx = field.getMinx();
            maxx = field.getMaxx();
            minz = field.getMinz();
            maxz = field.getMaxz();
            miny = field.getMiny();
            maxy = field.getMaxy();
        }
        World world = fieldblock.getWorld();
        for (int x = minx; x <= maxx; ++x) {
            for (int z = minz; z <= maxz; ++z) {
                for (int y = miny; y <= maxy; ++y) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Material type = world.getBlockAt(x, y, z).getType();
                    if (!this.plugin.getSettingsManager().isUnprotectableType(new BlockTypeEntry(type))) continue;
                    return fieldblock.getWorld().getBlockAt(x, y, z);
                }
            }
        }
        return null;
    }

    public Block existsUnprotectableBlock(Field field) {
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(field.getSettings().getTypeEntry());
        if (fs == null) {
            return null;
        }
        if (!this.plugin.getSettingsManager().hasUnprotectableBlocks()) {
            return null;
        }
        int minx = field.getMinx();
        int maxx = field.getMaxx();
        int minz = field.getMinz();
        int maxz = field.getMaxz();
        int miny = field.getMiny();
        int maxy = field.getMaxy();
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            for (int x = minx; x <= maxx; ++x) {
                for (int z = minz; z <= maxz; ++z) {
                    for (int y = miny; y <= maxy; ++y) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        Material type = world.getBlockAt(x, y, z).getType();
                        if (!this.plugin.getSettingsManager().isUnprotectableType(new BlockTypeEntry(type))) continue;
                        return field.getBlock().getWorld().getBlockAt(x, y, z);
                    }
                }
            }
        }
        return null;
    }
}

