/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Flying;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public void applyPotions(Player player, Field field) {
        if (field.hasFlag(FieldFlag.POTION_IGNORE_PLAYER)) {
            return;
        }
        HashMap<PotionEffectType, Integer> potions = field.getSettings().getPotions();
        for (Map.Entry<PotionEffectType, Integer> potion : potions.entrySet()) {
            int intensity = potion.getValue();
            PotionEffectType pot = potion.getKey();
            if (player.hasPotionEffect(pot)) continue;
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.manual.bypass.potions") && this.plugin.getSettingsManager().isHarmfulPotion(pot)) {
                return;
            }
            if (!player.hasPotionEffect(pot)) {
                player.addPotionEffect(new PotionEffect(pot, 72000, intensity));
            }
            this.plugin.getPermissionsManager().allowFast(player);
            this.plugin.getPermissionsManager().allowFly(player);
        }
    }

    public void removePotions(Player player, Field field) {
        HashMap<PotionEffectType, Integer> potions = field.getSettings().getPotions();
        for (PotionEffectType pot : potions.keySet()) {
            if (!player.hasPotionEffect(pot)) continue;
            player.removePotionEffect(pot);
            this.plugin.getPermissionsManager().resetFast(player);
        }
    }

    public void neutralizePotions(Player player, Field field) {
        List<PotionEffectType> noPotions = field.getSettings().getNeutralizePotions();
        for (PotionEffectType pot : noPotions) {
            if (!player.hasPotionEffect(pot)) continue;
            player.removePotionEffect(pot);
            this.plugin.getPermissionsManager().resetFast(player);
            this.plugin.getCommunicationManager().showNoPotion(player, pot.getName());
        }
    }

    public void addEffectToFieldEntities(Field field) {
        List<String> types = field.getSettings().getPotionTargets();
        if (types.size() == 0) {
            return;
        }
        int longestRadius = field.getLongestSide() / 2;
        int height = field.getHeight();
        Collection nearbyEntities = field.getLocation().getWorld().getNearbyEntities(field.getLocation(), (double)longestRadius, (double)height, (double)longestRadius);
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            this.addEffectToEntity(field, (LivingEntity)entity, types);
        }
    }

    public void removeEffectFromFieldEntities(Field field) {
        List<String> types = field.getSettings().getPotionTargets();
        if (types.size() == 0) {
            return;
        }
        int longestRadius = field.getLongestSide() / 2;
        int height = field.getHeight();
        Collection nearbyEntities = field.getLocation().getWorld().getNearbyEntities(field.getLocation(), (double)longestRadius, (double)height, (double)longestRadius);
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            this.removeEffectFromEntity(field, (LivingEntity)entity, types);
        }
    }

    public void addEffectToEntity(Field field, LivingEntity entity, List<String> types) {
        if (field.envelops(entity.getLocation()) && this.isMatchingLivingEntity((Entity)entity, types)) {
            HashMap<PotionEffectType, Integer> potions = field.getSettings().getPotions();
            for (Map.Entry<PotionEffectType, Integer> potion : potions.entrySet()) {
                int intensity = potion.getValue();
                PotionEffectType pot = potion.getKey();
                if (entity.hasPotionEffect(pot)) continue;
                entity.addPotionEffect(new PotionEffect(pot, 72000, intensity));
            }
        }
    }

    public void removeEffectFromEntity(Field field, LivingEntity entity, List<String> types) {
        if (field.envelops(entity.getLocation()) && this.isMatchingLivingEntity((Entity)entity, types)) {
            HashMap<PotionEffectType, Integer> potions = field.getSettings().getPotions();
            for (Map.Entry<PotionEffectType, Integer> potion : potions.entrySet()) {
                PotionEffectType pot = potion.getKey();
                if (!entity.hasPotionEffect(pot)) continue;
                entity.removePotionEffect(pot);
            }
        }
    }

    private boolean isMatchingLivingEntity(Entity entity, List<String> types) {
        if (entity instanceof Player) {
            return false;
        }
        if (entity instanceof Ambient && types.stream().anyMatch("Ambient"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Ageable && types.stream().anyMatch("Ageable"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Animals && types.stream().anyMatch("Animals"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof ArmorStand && types.stream().anyMatch("ArmorStand"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Bat && types.stream().anyMatch("Bat"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Blaze && types.stream().anyMatch("Blaze"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof CaveSpider && types.stream().anyMatch("CaveSpider"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof ChestedHorse && types.stream().anyMatch("ChestedHorse"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Chicken && types.stream().anyMatch("Chicken"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Cow && types.stream().anyMatch("Cow"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Creature && types.stream().anyMatch("Creature"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Creeper && types.stream().anyMatch("Creeper"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Donkey && types.stream().anyMatch("Donkey"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof ElderGuardian && types.stream().anyMatch("ElderGuardian"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof EnderDragon && types.stream().anyMatch("EnderDragon"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Enderman && types.stream().anyMatch("Enderman"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Endermite && types.stream().anyMatch("Endermite"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Evoker && types.stream().anyMatch("Evoker"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Flying && types.stream().anyMatch("Flying"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Ghast && types.stream().anyMatch("Ghast"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Giant && types.stream().anyMatch("Giant"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Golem && types.stream().anyMatch("Golem"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Guardian && types.stream().anyMatch("Guardian"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Horse && types.stream().anyMatch("Horse"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof HumanEntity && types.stream().anyMatch("HumanEntity"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Husk && types.stream().anyMatch("Husk"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Illager && types.stream().anyMatch("Illager"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Illusioner && types.stream().anyMatch("Illusioner"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof IronGolem && types.stream().anyMatch("IronGolem"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Llama && types.stream().anyMatch("Llama"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof MagmaCube && types.stream().anyMatch("MagmaCube"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Monster && types.stream().anyMatch("Monster"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Mule && types.stream().anyMatch("Mule"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof MushroomCow && types.stream().anyMatch("MushroomCow"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof NPC && types.stream().anyMatch("NPC"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Ocelot && types.stream().anyMatch("Ocelot"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Parrot && types.stream().anyMatch("Parrot"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Pig && types.stream().anyMatch("Pig"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof PigZombie && types.stream().anyMatch("PigZombie"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Player && types.stream().anyMatch("Player"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof PolarBear && types.stream().anyMatch("PolarBear"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Rabbit && types.stream().anyMatch("Rabbit"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Sheep && types.stream().anyMatch("Sheep"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Shulker && types.stream().anyMatch("Shulker"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Silverfish && types.stream().anyMatch("Silverfish"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Skeleton && types.stream().anyMatch("Skeleton"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof SkeletonHorse && types.stream().anyMatch("SkeletonHorse"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Slime && types.stream().anyMatch("Slime"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Snowman && types.stream().anyMatch("Snowman"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Spellcaster && types.stream().anyMatch("Spellcaster"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Spider && types.stream().anyMatch("Spider"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Squid && types.stream().anyMatch("Squid"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Stray && types.stream().anyMatch("Stray"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Vex && types.stream().anyMatch("Vex"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Villager && types.stream().anyMatch("Villager"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Vindicator && types.stream().anyMatch("Vindicator"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof WaterMob && types.stream().anyMatch("WaterMob"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Witch && types.stream().anyMatch("Witch"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Wither && types.stream().anyMatch("Wither"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof WitherSkeleton && types.stream().anyMatch("WitherSkeleton"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Wolf && types.stream().anyMatch("Wolf"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof Zombie && types.stream().anyMatch("Zombie"::equalsIgnoreCase)) {
            return true;
        }
        if (entity instanceof ZombieHorse && types.stream().anyMatch("ZombieHorse"::equalsIgnoreCase)) {
            return true;
        }
        return entity instanceof ZombieVillager && types.stream().anyMatch("ZombieVillager"::equalsIgnoreCase);
    }
}

