/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import com.gmail.nossr50.mcMMO;
import com.griefcraft.lwc.LWC;
import com.griefcraft.lwc.LWCPlugin;
import com.griefcraft.model.Protection;
import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import com.platymuus.bukkit.permissions.Group;
import com.platymuus.bukkit.permissions.PermissionsPlugin;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.gravitydevelopment.anticheat.api.AntiCheatAPI;
import net.gravitydevelopment.anticheat.check.CheckType;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.RedProtectManager;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.WorldGuardManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.yi.acru.bukkit.Lockette.Lockette;

public final class PermissionsManager {
    public static Permission permission = null;
    private static Economy economy = null;
    private PermissionHandler handler = null;
    private PermissionsPlugin pbukkit = null;
    private LWC lwc = null;
    private Lockette lockette = null;
    private PreciousStones plugin = PreciousStones.getInstance();
    private mcMMO mcmmo = null;
    private WorldEditPlugin worldEdit = null;

    public PermissionsManager() {
        this.detectPermissionsBukkit();
        this.detectPermissionsEx();
        this.detectPermissions();
        this.detectLWC();
        this.detectLockette();
        this.detectMcMMO();
        this.detectWorldEdit();
        try {
            Class.forName("net.milkbowl.vault.permission.Permission");
            this.setupEconomy();
            this.setupPermissions();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void detectWorldEdit() {
        Plugin p = this.plugin.getServer().getPluginManager().getPlugin("WorldEdit");
        if (p != null) {
            this.worldEdit = (WorldEditPlugin)p;
        }
    }

    private void detectMcMMO() {
        Plugin plug = this.plugin.getServer().getPluginManager().getPlugin("mcMMO");
        if (plug != null) {
            this.mcmmo = (mcMMO)plug;
        }
    }

    private void detectLWC() {
        Plugin plug = this.plugin.getServer().getPluginManager().getPlugin("LWC");
        if (plug != null) {
            this.lwc = ((LWCPlugin)plug).getLWC();
        }
    }

    private void detectLockette() {
        Plugin plug = this.plugin.getServer().getPluginManager().getPlugin("Lockette");
        if (plug != null) {
            this.lockette = (Lockette)plug;
        }
    }

    private void detectPermissions() {
        Plugin test;
        if (this.handler == null && (test = this.plugin.getServer().getPluginManager().getPlugin("Permissions")) != null) {
            this.handler = ((Permissions)test).getHandler();
        }
    }

    private void detectPermissionsEx() {
    }

    private void detectPermissionsBukkit() {
        Plugin test;
        if (this.pbukkit == null && (test = this.plugin.getServer().getPluginManager().getPlugin("PermissionsBukkit")) != null) {
            this.pbukkit = (PermissionsPlugin)test;
        }
    }

    private Boolean setupPermissions() {
        RegisteredServiceProvider permissionProvider = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            permission = (Permission)permissionProvider.getProvider();
        }
        return permission != null;
    }

    private Boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    public boolean canBuild(Player player, Location loc) {
        WorldGuardManager wm = PreciousStones.getInstance().getWorldGuardManager();
        RedProtectManager rm = PreciousStones.getInstance().getRedProtectManager();
        if (!wm.canBuild(player, loc)) {
            return false;
        }
        return rm.canBuild(player, loc);
    }

    public boolean canBuildField(Player player, Block block, FieldSettings fs) {
        WorldGuardManager wm = PreciousStones.getInstance().getWorldGuardManager();
        RedProtectManager rm = PreciousStones.getInstance().getRedProtectManager();
        if (!wm.canBuildField(player, block, fs)) {
            return false;
        }
        return rm.canBuildField(player, block, fs);
    }

    public boolean has(Player player, String perm) {
        PlayerEntry entry;
        if (player == null) {
            return true;
        }
        if (!perm.contains("preciousstones.bypass.toggle") && (perm.contains("preciousstones.bypass.") || perm.contains("preciousstones.admin.allowed")) && (entry = this.plugin.getPlayerManager().getPlayerEntry(player)).isBypassDisabled()) {
            return false;
        }
        if (permission != null) {
            if (permission.has(player, "preciousstones.blacklist") && !permission.has(player, "preciousstones.admin.isadmin")) {
                return false;
            }
            return permission.has(player, perm);
        }
        if (this.handler != null) {
            if (this.handler.has(player, "preciousstones.blacklist") && !this.handler.has(player, "preciousstones.admin.isadmin")) {
                return false;
            }
            return this.handler.has(player, perm);
        }
        return player.hasPermission(perm);
    }

    public boolean inGroup(String playerName, World world, String group) {
        try {
            if (this.pbukkit != null) {
                List groups = this.pbukkit.getGroups(playerName);
                for (Group g : groups) {
                    if (!g.getName().equalsIgnoreCase(group)) continue;
                    return true;
                }
                return false;
            }
            if (permission != null) {
                return permission.playerInGroup(world, playerName, group);
            }
            if (this.handler != null) {
                return this.handler.getGroup(world.getName(), playerName).equalsIgnoreCase(group);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public List<String> getGroups(String worldName, String playerName) {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            String group;
            if (this.pbukkit != null) {
                List gs = this.pbukkit.getGroups(playerName);
                for (Group group2 : gs) {
                    groups.add(group2.getName().toLowerCase());
                }
                return groups;
            }
            if (permission != null) {
                World world = this.plugin.getServer().getWorld(worldName);
                if (world != null) {
                    String[] groupList = permission.getPlayerGroups(world, playerName);
                    Collections.addAll(groups, groupList);
                }
            } else if (this.handler != null && (group = this.handler.getGroup(worldName, playerName)) != null) {
                groups.add(group.toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return groups;
    }

    public void addGroup(Player player, String group) {
        if (permission != null && player != null) {
            permission.playerAddGroup(player, group);
        }
    }

    public void removeGroup(Player player, String group) {
        if (permission != null && player != null) {
            permission.playerRemoveGroup(player, group);
        }
    }

    public boolean hasEconomy() {
        return economy != null && economy.isEnabled();
    }

    public boolean playerCharge(Player player, double amount) {
        return economy.withdrawPlayer(player.getName(), amount).transactionSuccess();
    }

    public boolean playerCharge(String playerName, double amount) {
        return economy.withdrawPlayer(playerName, amount).transactionSuccess();
    }

    public boolean playerCredit(Player player, double amount) {
        return economy.depositPlayer(player.getName(), amount).transactionSuccess();
    }

    public static boolean hasMoney(Player player, double amount) {
        return economy.has(player.getName(), amount);
    }

    public static boolean hasMoney(String playerName, double amount) {
        return economy.has(playerName, amount);
    }

    public boolean lwcProtected(Player player, Block block) {
        if (this.lwc == null) {
            return false;
        }
        Protection protection = this.lwc.findProtection(block);
        if (protection != null) {
            return !this.lwc.canAccessProtection(player, block);
        }
        return false;
    }

    public boolean locketteProtected(Player player, Block block) {
        if (this.lockette == null) {
            return false;
        }
        if (Lockette.isProtected((Block)block)) {
            String owner = Lockette.getProtectedOwner((Block)block);
            return !owner.equalsIgnoreCase(player.getName());
        }
        return false;
    }

    public boolean hasWorldEdit() {
        return this.worldEdit != null;
    }

    public boolean hasMcMMO() {
        return this.mcmmo != null;
    }

    public boolean hasLWC() {
        return this.lwc != null;
    }

    public boolean isVanished(Player player) {
        List values = player.getMetadata("vanished");
        for (MetadataValue value : values) {
            if (!value.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public void allowFly(Player player) {
        if (Bukkit.getServer().getPluginManager().getPlugin("AntiCheat") != null) {
            AntiCheatAPI.exemptPlayer((Player)player, (CheckType)CheckType.FLY);
        }
    }

    public void resetFly(Player player) {
        if (Bukkit.getServer().getPluginManager().getPlugin("AntiCheat") != null) {
            AntiCheatAPI.unexemptPlayer((Player)player, (CheckType)CheckType.FLY);
        }
    }

    public void allowFast(Player player) {
        if (Bukkit.getServer().getPluginManager().getPlugin("AntiCheat") != null) {
            AntiCheatAPI.exemptPlayer((Player)player, (CheckType)CheckType.FAST_BREAK);
            AntiCheatAPI.exemptPlayer((Player)player, (CheckType)CheckType.FAST_PLACE);
        }
    }

    public void resetFast(Player player) {
        if (Bukkit.getServer().getPluginManager().getPlugin("AntiCheat") != null) {
            AntiCheatAPI.unexemptPlayer((Player)player, (CheckType)CheckType.FAST_BREAK);
            AntiCheatAPI.unexemptPlayer((Player)player, (CheckType)CheckType.FAST_PLACE);
        }
    }
}

