/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sacredlabyrinth.Phaed.PreciousStones.MaterialName;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class Helper {
    private static Map<Integer, Material> materialIdMap;
    private static Field materialIdField;

    public void dumpStackTrace() {
        for (StackTraceElement el : Thread.currentThread().getStackTrace()) {
            PreciousStones.debug(el.toString(), new Object[0]);
        }
    }

    public static boolean isInteger(Object o) {
        return o instanceof Integer;
    }

    public static boolean isDouble(Object o) {
        return o instanceof Double;
    }

    public static boolean isByte(String input) {
        try {
            Byte.parseByte(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isShort(String input) {
        try {
            Short.parseShort(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isIntList(Object obj) {
        try {
            List list = (List)obj;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isStringList(Object obj) {
        try {
            List list = (List)obj;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isFloat(String input) {
        try {
            Float.parseFloat(input);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isString(Object o) {
        return o instanceof String;
    }

    public static boolean isBoolean(Object o) {
        return o instanceof Boolean;
    }

    public static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    public static String removeFirstChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
            break;
        }
        return r;
    }

    public static String capitalize(String content) {
        if (content.length() < 2) {
            return content;
        }
        return content;
    }

    public static int indexOf(Pattern pattern, String s) {
        Matcher matcher = pattern.matcher(s);
        return matcher.find() ? matcher.start() : -1;
    }

    public static String friendlyBlockType(Material type) {
        return MaterialName.getIDName(type);
    }

    public static String friendlyName(String type) {
        String[] words;
        String out = "";
        type = type.toLowerCase().replace('_', ' ');
        for (String word : words = type.split("\\s+")) {
            out = out + Helper.capitalize(word) + " ";
        }
        return out.trim();
    }

    public static String stripColors(String msg) {
        String out = msg.replaceAll("[&][0-9a-f]", "");
        out = out.replaceAll(String.valueOf('\u00c2'), "");
        return out.replaceAll("[\u00a7][0-9a-f]", "");
    }

    public static String stripTrailing(String msg, String sep) {
        if (msg.length() < sep.length() * 2) {
            return msg;
        }
        String out = msg;
        String first = msg.substring(0, sep.length());
        String last = msg.substring(msg.length() - sep.length(), msg.length());
        if (first.equals(sep)) {
            out = msg.substring(sep.length());
        }
        if (last.equals(sep)) {
            out = msg.substring(0, msg.length() - sep.length());
        }
        return out;
    }

    public static String toColor(String hexValue) {
        return ChatColor.getByChar((String)hexValue).toString();
    }

    public static List<String> fromArray(String ... values) {
        ArrayList<String> results = new ArrayList<String>();
        Collections.addAll(results, values);
        results.remove("");
        return results;
    }

    public static HashSet<String> fromArray2(String ... values) {
        HashSet<String> results = new HashSet<String>();
        Collections.addAll(results, values);
        results.remove("");
        return results;
    }

    public static List<Player> fromPlayerArray(Player ... values) {
        ArrayList<Player> results = new ArrayList<Player>();
        Collections.addAll(results, values);
        return results;
    }

    public static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    public static String[] removeFirst(String[] args) {
        List<String> out = Helper.fromArray(args);
        if (!out.isEmpty()) {
            out.remove(0);
        }
        return Helper.toArray(out);
    }

    public static String toMessage(String[] args) {
        String out = "";
        for (String arg : args) {
            out = out + arg + " ";
        }
        return out.trim();
    }

    public static String toMessage(String[] args, String sep) {
        String out = "";
        for (String arg : args) {
            out = out + arg + sep;
        }
        return Helper.stripTrailing(out, sep);
    }

    public static String toMessage(Collection<String> args, String sep) {
        String out = "";
        for (String arg : args) {
            out = out + arg + sep;
        }
        return Helper.stripTrailing(out, sep);
    }

    public static String toLocationString(Location loc) {
        return loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ();
    }

    @Deprecated
    public static String escapeQuotesTrue(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("'", "''");
    }

    public static String escapeQuotes(String str) {
        return Helper.escapeQuotesTrue(str);
    }

    public static boolean isSameBlock(Location loc, Location loc2) {
        if (loc == null && loc2 == null) {
            return true;
        }
        if (loc == null || loc2 == null) {
            return false;
        }
        return loc.getBlockX() == loc2.getBlockX() && loc.getBlockY() == loc2.getBlockY() && loc.getBlockZ() == loc2.getBlockZ();
    }

    public static boolean isSameLocation(Location loc, Location loc2) {
        if (loc == null && loc2 == null) {
            return true;
        }
        if (loc == null || loc2 == null) {
            return false;
        }
        return loc.getX() == loc2.getX() && loc.getY() == loc2.getY() && loc.getZ() == loc2.getZ();
    }

    public static String toFlagStr(FieldFlag flag) {
        if (flag == null) {
            return "";
        }
        return flag.toString().toLowerCase().replace("_", "-");
    }

    public static FieldFlag toFieldFlag(String flagStr) {
        try {
            return FieldFlag.valueOf(flagStr.toUpperCase().replace("-", "_"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean hasData(String rawItem) {
        return rawItem.contains(":");
    }

    public static boolean isTypeEntry(String input) {
        try {
            String out = input.replace(":", "");
            Integer.parseInt(out);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<BlockTypeEntry> toTypeEntriesBlind(List<Object> rawList) {
        ArrayList<BlockTypeEntry> types = new ArrayList<BlockTypeEntry>();
        for (Object rawItem : rawList) {
            BlockTypeEntry entry = new BlockTypeEntry(rawItem.toString());
            if (!entry.isValid()) continue;
            types.add(entry);
        }
        return types;
    }

    public static List<BlockTypeEntry> toTypeEntries(List<String> rawList) {
        ArrayList<BlockTypeEntry> types = new ArrayList<BlockTypeEntry>();
        for (String rawItem : rawList) {
            BlockTypeEntry entry = new BlockTypeEntry(rawItem);
            if (!entry.isValid()) continue;
            types.add(entry);
        }
        return types;
    }

    public static Location locationFromPacked(String packed) {
        String[] unpacked = packed.split("[|]");
        int x = Integer.parseInt(unpacked[1]);
        int y = Integer.parseInt(unpacked[2]);
        int z = Integer.parseInt(unpacked[3]);
        String world = unpacked[4];
        World w = Bukkit.getServer().getWorld(world);
        return new Location(w, (double)x, (double)y, (double)z);
    }

    public static boolean isDoor(Block block) {
        return block.getType() == Material.OAK_DOOR || block.getType() == Material.IRON_DOOR || block.getType() == Material.ACACIA_DOOR || block.getType() == Material.BIRCH_DOOR || block.getType() == Material.DARK_OAK_DOOR || block.getType() == Material.JUNGLE_DOOR;
    }

    public static String getDetails(Block block) {
        return "[" + block.getType() + "|" + block.getLocation().getBlockX() + " " + block.getLocation().getBlockY() + " " + block.getLocation().getBlockZ() + "]";
    }

    public static boolean isOnline(String playerName) {
        return Bukkit.getServer().getPlayer(playerName) != null;
    }

    public static boolean dropBlock(Block block) {
        if (block.getType() != Material.AIR) {
            try {
                World world = block.getWorld();
                ItemStack is = new ItemStack(block.getType());
                world.dropItemNaturally(block.getLocation(), is);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void dropBlockWipe(Block block) {
        if (Helper.dropBlock(block)) {
            block.setType(Material.AIR);
        }
    }

    public static int forceParseInteger(String intString) {
        if (!Helper.isInteger(intString = intString.replaceAll("[^0-9]", ""))) {
            return 0;
        }
        return Integer.parseInt(intString);
    }

    public static int getWidthFromCoords(int a, int b) {
        if (a < 0 && b < 0) {
            if (a < b) {
                return Math.abs(a - b) + 1;
            }
            return Math.abs(b - a) + 1;
        }
        if (a >= 0 && b >= 0) {
            if (a > b) {
                return Math.abs(a - b) + 1;
            }
            return Math.abs(b - a) + 1;
        }
        if (a < 0 && b >= 0) {
            return Math.abs(a - b) + 1;
        }
        if (a >= 0 && b < 0) {
            return Math.abs(b - a) + 1;
        }
        return 0;
    }

    public static String getMaterialString(Material type) {
        return MaterialName.getIDName(type);
    }

    public static boolean isAirOrWater(Location loc) {
        Material type = loc.getWorld().getBlockAt(loc).getType();
        return type == Material.AIR || type == Material.WATER;
    }

    public static Player getDamagingPlayer(EntityDamageEvent event) {
        ProjectileSource shooter;
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return null;
        }
        Entity damager = ((EntityDamageByEntityEvent)event).getDamager();
        if (damager instanceof Player) {
            return (Player)damager;
        }
        if (damager instanceof Projectile && (shooter = ((Projectile)damager).getShooter()) instanceof Player) {
            return (Player)shooter;
        }
        return null;
    }

    public static Player getClosestPlayer(Location target, int radius) {
        Collection<Player> players = Helper.getOnlinePlayers();
        double closestDistance = radius;
        Player closestPlayer = null;
        for (Player player : players) {
            double distance;
            Location loc = player.getLocation();
            if (!loc.getWorld().getName().equals(target.getWorld().getName()) || !((distance = loc.distance(target)) < closestDistance)) continue;
            closestDistance = distance;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    public static Player getClosestPlayer(Location target, int radius, Set<String> names) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (String name : names) {
            Player player = Bukkit.getServer().getPlayer(name);
            if (player == null) continue;
            players.add(player);
        }
        double closestDistance = radius;
        Player closestPlayer = null;
        for (Player player : players) {
            double distance;
            Location loc = player.getLocation();
            if (!loc.getWorld().getName().equals(target.getWorld().getName()) || !((distance = loc.distance(target)) < closestDistance)) continue;
            closestDistance = distance;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    public static Collection<Player> getOnlinePlayers() {
        try {
            Method method = Bukkit.class.getDeclaredMethod("getOnlinePlayers", new Class[0]);
            Object players = method.invoke(null, new Object[0]);
            if (players instanceof Player[]) {
                return new ArrayList<Player>(Arrays.asList((Player[])players));
            }
            return (Collection)players;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Player>();
        }
    }

    public static String getMethodName(int depth) {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        return ste[ste.length - 1 - depth].getMethodName();
    }

    public static boolean isBoat(Material mat) {
        return mat == Material.OAK_BOAT || mat == Material.ACACIA_BOAT || mat == Material.BIRCH_BOAT || mat == Material.DARK_OAK_BOAT || mat == Material.JUNGLE_BOAT || mat == Material.SPRUCE_BOAT;
    }

    public static long getMillis() {
        return LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static <T> void addUnique(List<T> one, List<T> two) {
        for (T x : two) {
            if (one.contains(x)) continue;
            one.add(x);
        }
    }

    public static String formatDouble(double d) {
        if (d == (double)((long)d)) {
            return String.format("%d", (long)d);
        }
        return String.format("%s", d);
    }

    public static Material getMaterial(int id) {
        Material converted;
        Material material;
        if (materialIdMap == null) {
            T[] allMaterials;
            materialIdMap = new HashMap<Integer, Material>();
            for (Object o : allMaterials = Material.AIR.getDeclaringClass().getEnumConstants()) {
                Material material2 = (Material)o;
                materialIdMap.put(Helper.getMaterialId(material2), material2);
            }
        }
        if ((material = materialIdMap.get(id)) != null && material.isLegacy() && (converted = Bukkit.getUnsafe().fromLegacy(material)) != null && converted != Material.AIR) {
            material = converted;
        }
        return material;
    }

    public static int getMaterialId(Material material) {
        int id = -1;
        try {
            if (materialIdField == null) {
                materialIdField = Material.class.getDeclaredField("id");
                materialIdField.setAccessible(true);
            }
            id = (Integer)materialIdField.get(material);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "PreciousStones failed to hackily workaround Material.getId legacy issues, all is lost, abandon hope", ex);
        }
        return id;
    }
}

