/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.blocks;

import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;

public class RelativeBlock
implements Comparable {
    private int rx;
    private int ry;
    private int rz;

    public RelativeBlock(Vec centerVec, Vec vec) {
        Vec v = vec.subtract(centerVec);
        this.rx = v.getX();
        this.ry = v.getY();
        this.rz = v.getZ();
    }

    public RelativeBlock(int rx, int ry, int rz) {
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
    }

    public Vec getAbsoluteVec(Vec vec) {
        return this.getRelativeVec(vec.getWorld()).add(vec);
    }

    public Vec getRelativeVec(String world) {
        return new Vec(this.rx, this.ry, this.rz, world);
    }

    public Vec toVec(Vec centerVec) {
        return new Vec(this.getAbsoluteVec(centerVec));
    }

    public int getRx() {
        return this.rx;
    }

    public int getRy() {
        return this.ry;
    }

    public int getRz() {
        return this.rz;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelativeBlock)) {
            return false;
        }
        RelativeBlock other = (RelativeBlock)obj;
        return other.getRx() == this.getRx() && other.getRy() == this.getRy() && other.getRz() == this.getRz();
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.getRx();
        hash = 47 * hash + this.getRy();
        hash = 47 * hash + this.getRz();
        return hash;
    }

    public int compareTo(Object obj) {
        if (obj instanceof RelativeBlock) {
            RelativeBlock other = (RelativeBlock)obj;
            if (this.getRx() < other.getRx() || this.getRx() == other.getRx() && this.getRy() < other.getRy() || this.getRx() == other.getRx() && this.getRy() == other.getRy() && this.getRz() < other.getRz()) {
                return -1;
            }
            if (this.getRx() > other.getRx() || this.getRx() == other.getRx() && this.getRy() > other.getRy() || this.getRx() == other.getRx() && this.getRy() == other.getRy() && this.getRz() > other.getRz()) {
                return 1;
            }
            return 0;
        }
        throw new IllegalArgumentException("obj must be an instance of a RelativeBlock object.");
    }
}

