/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones;

import java.util.LinkedList;
import java.util.Queue;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.GriefBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Rollback
implements Runnable {
    private PreciousStones plugin;
    private Queue<GriefBlock> griefQueue;
    private Queue<GriefBlock> dependentQueue = new LinkedList<GriefBlock>();
    private final int timerID;
    private final World world;
    private final Field field;

    public Rollback(Queue<GriefBlock> griefQueue, World world, Field field) {
        this.field = field;
        this.griefQueue = griefQueue;
        this.world = world;
        this.plugin = PreciousStones.getInstance();
        this.timerID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 2L, 1L);
    }

    @Override
    public void run() {
        GriefBlock gb;
        int i = 0;
        while (i < 500 && !this.griefQueue.isEmpty()) {
            gb = this.griefQueue.poll();
            if (this.plugin.getSettingsManager().isDependentBlock(gb.getType())) {
                this.dependentQueue.add(gb);
                continue;
            }
            if (this.field.hasFlag(FieldFlag.GRIEF_REVERT_SAFETY)) {
                this.movePlayers(gb);
            }
            PreciousStones.getInstance().getGriefUndoManager().undoGriefBlock(gb, this.world);
            ++i;
        }
        if (this.griefQueue.isEmpty()) {
            while (i < 500 && !this.dependentQueue.isEmpty()) {
                gb = this.dependentQueue.poll();
                if (this.field.hasFlag(FieldFlag.GRIEF_REVERT_SAFETY)) {
                    this.movePlayers(gb);
                }
                PreciousStones.getInstance().getGriefUndoManager().undoGriefBlock(gb, this.world);
                ++i;
            }
            if (!this.dependentQueue.iterator().hasNext()) {
                Bukkit.getServer().getScheduler().cancelTask(this.timerID);
            }
        }
    }

    private void movePlayers(GriefBlock gb) {
        for (Player player : this.world.getPlayers()) {
            Vec location;
            Vec blockLocation = gb.toVec();
            if (!blockLocation.equals(location = new Vec(player.getLocation())) && !blockLocation.equals(location.add(0, 1, 0))) continue;
            this.plugin.getTeleportationManager().teleportAway(player);
        }
    }
}

