/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.ItemStackEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

import java.util.ArrayList;
import java.util.List;

/**
 * @author telaeris
 */
public class ConfiscationManager {
    private PreciousStones plugin;

    /**
     *
     */
    public ConfiscationManager() {
        plugin = PreciousStones.getInstance();
    }

    /**
     * Confiscates items from a player and places them on a chest on top of the field
     *
     * @param player
     */
    @SuppressWarnings("deprecation")
    public void confiscateItems(Field field, Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();

        ItemStackEntry helmet = null;
        ItemStackEntry chestplate = null;
        ItemStackEntry leggings = null;
        ItemStackEntry boots = null;

        List<ItemStackEntry> confiscated = new ArrayList<>();

        for (ItemStack stack : contents) {
            if (stack != null && stack.getType() != Material.AIR) {
                if (!field.getSettings().canCarry(stack.getType())) {
                    // remove item from inventory

                    inventory.removeItem(stack);

                    // add item to confiscated list

                    confiscated.add(new ItemStackEntry(stack));
                }
            }
        }

        ItemStack item = inventory.getHelmet();

        if (item != null) {
            if (!field.getSettings().canCarry(item.getType())) {
                // add item to confiscated list
                helmet = new ItemStackEntry(item);

                // remove item
                inventory.setHelmet(new ItemStack(Material.AIR));
            }
        }

        item = inventory.getChestplate();

        if (item != null) {
            if (!field.getSettings().canCarry(item.getType())) {
                // add item to confiscated list
                chestplate = new ItemStackEntry(item);

                // remove item
                inventory.setChestplate(new ItemStack(Material.AIR));
            }
        }

        item = inventory.getLeggings();

        if (item != null) {
            if (!field.getSettings().canCarry(item.getType())) {
                // add item to confiscated list
                leggings = new ItemStackEntry(item);

                // remove item
                inventory.setLeggings(new ItemStack(Material.AIR));
            }
        }

        item = inventory.getBoots();

        if (item != null) {
            if (!field.getSettings().canCarry(item.getType())) {
                // add item to confiscated list
                boots = new ItemStackEntry(item);

                // remove item
                inventory.setBoots(new ItemStack(Material.AIR));
            }
        }

        if (!confiscated.isEmpty() || helmet != null || chestplate != null || leggings != null || boots != null) {
            PlayerEntry entry = plugin.getPlayerManager().getPlayerEntry(player);
            entry.confiscate(confiscated, helmet, chestplate, leggings, boots);
            plugin.getStorageManager().updatePlayer(player.getName());
            player.updateInventory();

            String msg = "";

            for (ItemStackEntry e : confiscated) {
                msg += e.getAmount() + " " + Helper.friendlyBlockType(e.getType()) + ", ";
            }

            if (helmet != null) {
                msg += "1 " + Helper.friendlyBlockType(helmet.getType()) + ", ";
            }

            if (chestplate != null) {
                msg += "1 " + Helper.friendlyBlockType(chestplate.getType()) + ", ";
            }

            if (leggings != null) {
                msg += "1 " + Helper.friendlyBlockType(leggings.getType()) + ", ";
            }

            if (boots != null) {
                msg += "1 " + Helper.friendlyBlockType(boots.getType()) + ", ";
            }

            msg = Helper.stripTrailing(msg, ", ");

            PreciousStones.log("confiscatedFrom", msg, player.getName(), field.toString());
            ChatHelper.send(player, "confiscated", msg);
        }
    }

    /**
     * Returns confiscated items to the player
     *
     * @param player
     */
    @SuppressWarnings("deprecation")
    public void returnItems(Player player) {
        PlayerInventory inventory = player.getInventory();

        if (inventory == null) {
            return;
        }

        PlayerEntry entry = plugin.getPlayerManager().getPlayerEntry(player);

        List<ItemStackEntry> confiscated = entry.returnInventory();
        ItemStackEntry helmet = entry.returnHelmet();
        ItemStackEntry chestplate = entry.returnChestplate();
        ItemStackEntry leggings = entry.returnLeggings();
        ItemStackEntry boots = entry.returnBoots();

        plugin.getStorageManager().updatePlayer(player.getName());
        player.updateInventory();

        if (helmet != null) {
            inventory.setHelmet(helmet.toItemStack());
        }

        if (chestplate != null) {
            inventory.setChestplate(chestplate.toItemStack());
        }

        if (leggings != null) {
            inventory.setLeggings(leggings.toItemStack());
        }

        if (boots != null) {
            inventory.setBoots(boots.toItemStack());
        }

        for (ItemStackEntry item : confiscated) {
            if (inventory.firstEmpty() == -1) {
                player.getWorld().dropItemNaturally(player.getLocation(), item.toItemStack());
                continue;
            }

            inventory.addItem(item.toItemStack());
        }

        if (!confiscated.isEmpty() || helmet != null || chestplate != null || leggings != null || boots != null) {
            String msg = "";

            for (ItemStackEntry e : confiscated) {
                msg += e.getAmount() + " " + Helper.friendlyBlockType(e.getType()) + ", ";
            }

            if (helmet != null) {
                msg += "1 " + Helper.friendlyBlockType(helmet.getType()) + ", ";
            }

            if (chestplate != null) {
                msg += "1 " + Helper.friendlyBlockType(chestplate.getType()) + ", ";
            }

            if (leggings != null) {
                msg += "1 " + Helper.friendlyBlockType(leggings.getType()) + ", ";
            }

            if (boots != null) {
                msg += "1 " + Helper.friendlyBlockType(boots.getType()) + ", ";
            }

            msg = Helper.stripTrailing(msg, ", ");

            PreciousStones.log("returnedTo", msg, player.getName());
            ChatHelper.send(player, "returned", msg);
        }
    }
}
