/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="bun", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class BunMojo
extends AbstractFrontendMojo {
    private static final String NPM_REGISTRY_URL = "npmRegistryURL";
    @Parameter(defaultValue="", property="frontend.bun.arguments", required=false)
    private String arguments;
    @Parameter(property="frontend.bun.bunInheritsProxyConfigFromMaven", required=false, defaultValue="true")
    private boolean bunInheritsProxyConfigFromMaven;
    @Parameter(property="npmRegistryURL", required=false, defaultValue="")
    private String npmRegistryURL;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(property="skip.bun", defaultValue="${skip.bun}")
    private boolean skip;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws TaskRunnerException {
        File packageJson = new File(this.workingDirectory, "package.json");
        if (this.buildContext == null || this.buildContext.hasDelta(packageJson) || !this.buildContext.isIncremental()) {
            ProxyConfig proxyConfig = this.getProxyConfig();
            factory.getBunRunner(proxyConfig, this.getRegistryUrl()).execute(this.arguments, this.environmentVariables);
        } else {
            this.getLog().info((CharSequence)"Skipping bun install as package.json unchanged");
        }
    }

    private ProxyConfig getProxyConfig() {
        if (this.bunInheritsProxyConfigFromMaven) {
            return MojoUtils.getProxyConfig(this.session, this.decrypter);
        }
        this.getLog().info((CharSequence)"bun not inheriting proxy config from Maven");
        return new ProxyConfig(Collections.emptyList());
    }

    private String getRegistryUrl() {
        return System.getProperty(NPM_REGISTRY_URL, this.npmRegistryURL);
    }
}

