/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="install-node-and-npm", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class InstallNodeAndNpmMojo
extends AbstractFrontendMojo {
    @Parameter(property="nodeDownloadRoot", required=false)
    private String nodeDownloadRoot;
    @Parameter(property="npmDownloadRoot", required=false, defaultValue="https://registry.npmjs.org/npm/-/")
    private String npmDownloadRoot;
    @Deprecated
    @Parameter(property="downloadRoot", required=false, defaultValue="")
    private String downloadRoot;
    @Parameter(property="nodeVersion", required=true)
    private String nodeVersion;
    @Parameter(property="npmVersion", required=false, defaultValue="provided")
    private String npmVersion;
    @Parameter(property="serverId", defaultValue="")
    private String serverId;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="skip.installnodenpm", defaultValue="${skip.installnodenpm}")
    private boolean skip;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public void execute(FrontendPluginFactory factory) throws InstallationException {
        ProxyConfig proxyConfig = MojoUtils.getProxyConfig(this.session, this.decrypter);
        String nodeDownloadRoot = this.getNodeDownloadRoot();
        String npmDownloadRoot = this.getNpmDownloadRoot();
        Server server = MojoUtils.decryptServer(this.serverId, this.session, this.decrypter);
        if (null != server) {
            factory.getNodeInstaller(proxyConfig).setNodeVersion(this.nodeVersion).setNodeDownloadRoot(nodeDownloadRoot).setNpmVersion(this.npmVersion).setUserName(server.getUsername()).setPassword(server.getPassword()).install();
            factory.getNPMInstaller(proxyConfig).setNodeVersion(this.nodeVersion).setNpmVersion(this.npmVersion).setNpmDownloadRoot(npmDownloadRoot).setUserName(server.getUsername()).setPassword(server.getPassword()).install();
        } else {
            factory.getNodeInstaller(proxyConfig).setNodeVersion(this.nodeVersion).setNodeDownloadRoot(nodeDownloadRoot).setNpmVersion(this.npmVersion).install();
            factory.getNPMInstaller(proxyConfig).setNodeVersion(this.nodeVersion).setNpmVersion(this.npmVersion).setNpmDownloadRoot(npmDownloadRoot).install();
        }
    }

    private String getNodeDownloadRoot() {
        if (this.downloadRoot != null && !"".equals(this.downloadRoot) && this.nodeDownloadRoot == null) {
            return this.downloadRoot;
        }
        return this.nodeDownloadRoot;
    }

    private String getNpmDownloadRoot() {
        if (this.downloadRoot != null && !"".equals(this.downloadRoot) && "https://registry.npmjs.org/npm/-/".equals(this.npmDownloadRoot)) {
            return this.downloadRoot;
        }
        return this.npmDownloadRoot;
    }
}

