/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.parser;

import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlTokenSource;
import org.ehrbase.terminology.client.terminology.TermDefinition;
import org.ehrbase.terminology.client.terminology.TerminologyProvider;
import org.ehrbase.terminology.client.terminology.ValueSet;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateAnnotation;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.model.WebTemplateValidation;
import org.ehrbase.webtemplate.model.WebtemplateCardinality;
import org.ehrbase.webtemplate.parser.FlatPath;
import org.ehrbase.webtemplate.parser.InputHandler;
import org.ehrbase.webtemplate.parser.OptNameHelper;
import org.openehr.schemas.v1.ARCHETYPESLOT;
import org.openehr.schemas.v1.ARCHETYPETERM;
import org.openehr.schemas.v1.CARCHETYPEROOT;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCODEPHRASE;
import org.openehr.schemas.v1.CCODEREFERENCE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CDOMAINTYPE;
import org.openehr.schemas.v1.CDVORDINAL;
import org.openehr.schemas.v1.CDVQUANTITY;
import org.openehr.schemas.v1.CDVSTATE;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CODEPHRASE;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;
import org.openehr.schemas.v1.DVCODEDTEXT;
import org.openehr.schemas.v1.DVORDINAL;
import org.openehr.schemas.v1.DVQUANTITY;
import org.openehr.schemas.v1.Interval;
import org.openehr.schemas.v1.IntervalOfInteger;
import org.openehr.schemas.v1.OBJECTID;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.RESOURCEDESCRIPTIONITEM;
import org.openehr.schemas.v1.StringDictionaryItem;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OPTParser {
    public static final String PATH_DIVIDER = "/";
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    public static final String CAREFLOW_STEP = "careflow_step";
    public static final String DV_CODED_TEXT = "DV_CODED_TEXT";
    public static final String CODED_TEXT = "CODED_TEXT";
    public static final String OPENEHR = "openehr";
    public static final String CURRENT_STATE = "current_state";
    private final OPERATIONALTEMPLATE operationaltemplate;
    private final String defaultLanguage;
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final InputHandler inputHandler = new InputHandler(this.defaultValues);
    private List<String> languages;

    public OPTParser(OPERATIONALTEMPLATE operationaltemplate) {
        this.operationaltemplate = operationaltemplate;
        this.defaultLanguage = operationaltemplate.getLanguage().getCodeString();
        Arrays.stream(this.extractChildren((XmlObject)operationaltemplate, "constraints")).map(c -> this.extractChildren((XmlObject)c, "attributes")).flatMap(Arrays::stream).map(this::extractDefault).flatMap(Collection::stream).forEach(p -> this.defaultValues.put((String)p.getKey(), (String)p.getValue()));
    }

    public WebTemplate parse() {
        WebTemplate webTemplate = new WebTemplate();
        webTemplate.setTemplateId(this.operationaltemplate.getTemplateId().getValue());
        webTemplate.setDefaultLanguage(this.defaultLanguage);
        webTemplate.setVersion("2.3");
        webTemplate.getLanguages().addAll(Arrays.stream(this.operationaltemplate.getDescription().getDetailsArray()).map(RESOURCEDESCRIPTIONITEM::getLanguage).map(CODEPHRASE::getCodeString).collect(Collectors.toSet()));
        this.languages = webTemplate.getLanguages();
        webTemplate.setTree(this.parseCARCHETYPEROO(this.operationaltemplate.getDefinition(), ""));
        return webTemplate;
    }

    public XmlObject[] extractChildren(XmlObject c, String attributes) {
        return c.selectChildren("http://schemas.openehr.org/v1", attributes);
    }

    private List<Pair<String, String>> extractDefault(XmlObject xmlObject) {
        ArrayList<Pair<String, String>> defaults = new ArrayList<Pair<String, String>>();
        String differential_path = StringUtils.substringAfter((String)this.extractChildren(xmlObject, "differential_path")[0].newCursor().getTextValue(), (String)PATH_DIVIDER);
        String rm_attribute_name = this.extractChildren(xmlObject, "rm_attribute_name")[0].newCursor().getTextValue();
        String aql = PATH_DIVIDER + differential_path + PATH_DIVIDER + rm_attribute_name;
        List<String> attributeNames = Arrays.stream(this.extractChildren(xmlObject, "children")).map(x -> this.extractChildren((XmlObject)x, "default_value")).flatMap(Arrays::stream).map(XmlTokenSource::newDomNode).map(Node::getFirstChild).map(Node::getChildNodes).map(this::buildList).flatMap(Collection::stream).map(Node::getNodeName).collect(Collectors.toList());
        attributeNames.forEach(n -> {
            Optional any = Arrays.stream(this.extractChildren(xmlObject, "children")).map(x -> this.extractChildren((XmlObject)x, "default_value")).flatMap(Arrays::stream).map(x -> this.extractChildren((XmlObject)x, (String)n)).flatMap(Arrays::stream).findAny();
            if (any.isPresent()) {
                if (((XmlObject)any.get()).newDomNode().getFirstChild().getChildNodes().getLength() == 1) {
                    String defaultValue = ((XmlObject)any.get()).newCursor().getTextValue();
                    defaults.add((Pair<String, String>)new ImmutablePair((Object)(aql + "|" + n), (Object)defaultValue));
                } else {
                    String defaultValue = Arrays.stream(this.extractChildren((XmlObject)any.get(), "defining_code")).findAny().map(x -> this.extractChildren((XmlObject)x, "code_string")).stream().flatMap(Arrays::stream).map(XmlTokenSource::newCursor).map(XmlCursor::getTextValue).findAny().orElse("");
                    defaults.add((Pair<String, String>)new ImmutablePair((Object)(aql + "|defining_code"), (Object)defaultValue));
                }
            }
        });
        return defaults;
    }

    private List<Node> buildList(NodeList list) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1) continue;
            nodes.add(item);
        }
        return nodes;
    }

    private WebTemplateNode parseCARCHETYPEROO(CARCHETYPEROOT carchetyperoot, String aqlPath) {
        HashMap<String, Map<String, TermDefinition>> termDefinitionMap = new HashMap<String, Map<String, TermDefinition>>();
        for (ARCHETYPETERM term : carchetyperoot.getTermDefinitionsArray()) {
            String code = term.getCode();
            String value2 = null;
            String description = null;
            HashMap<String, String> otherMap = new HashMap<String, String>();
            for (StringDictionaryItem item : term.getItemsArray()) {
                if ("text".equals(item.getId())) {
                    value2 = item.getStringValue();
                    continue;
                }
                if ("description".equals(item.getId())) {
                    description = item.getStringValue();
                    continue;
                }
                otherMap.put(item.getId(), item.getStringValue());
            }
            termDefinitionMap.computeIfAbsent(code, c -> new HashMap()).put(this.defaultLanguage, new TermDefinition(code, value2, description, otherMap));
        }
        Map<String, Map<String, TermDefinition>> otherTermDefinitionMap = this.buildOtherTerms(carchetyperoot.getArchetypeId().getValue());
        otherTermDefinitionMap.forEach((key, value) -> termDefinitionMap.computeIfAbsent((String)key, c -> new HashMap()).putAll(value));
        WebTemplateNode node = this.parseCCOMPLEXOBJECT((CCOMPLEXOBJECT)carchetyperoot, aqlPath, termDefinitionMap, null);
        node.setNodeId(carchetyperoot.getArchetypeId().getValue());
        this.addRMAttributes(node, aqlPath, termDefinitionMap);
        return node;
    }

    private Map<String, Map<String, TermDefinition>> buildOtherTerms(String archetypeId) {
        HashMap<String, Map<String, TermDefinition>> otherTermDefinitionMap = new HashMap<String, Map<String, TermDefinition>>();
        ArrayList ontologies = new ArrayList();
        ontologies.addAll(Arrays.stream(this.extractChildren((XmlObject)this.operationaltemplate, "ontology")).filter(x -> x.selectAttribute("", "archetype_id").newCursor().getTextValue().equals(archetypeId)).map(x -> this.extractChildren((XmlObject)x, "term_definitions")).flatMap(Arrays::stream).collect(Collectors.toList()));
        ontologies.addAll(Arrays.stream(this.extractChildren((XmlObject)this.operationaltemplate, "component_ontologies")).filter(x -> x.selectAttribute("", "archetype_id").newCursor().getTextValue().equals(archetypeId)).map(x -> this.extractChildren((XmlObject)x, "term_definitions")).flatMap(Arrays::stream).collect(Collectors.toList()));
        for (XmlObject term : ontologies) {
            String language = term.selectAttribute("", "language").newCursor().getTextValue();
            for (XmlObject items : this.extractChildren(term, "items")) {
                String code = items.selectAttribute("", "code").newCursor().getTextValue();
                String text = "";
                String description = "";
                for (XmlObject item : this.extractChildren(items, "items")) {
                    String id = item.selectAttribute("", "id").newCursor().getTextValue();
                    String value = item.newCursor().getTextValue();
                    if (Objects.equals(id, "text")) {
                        text = value;
                        continue;
                    }
                    if (!Objects.equals(id, "description")) continue;
                    description = value;
                }
                Map termDefinitionMap = otherTermDefinitionMap.computeIfAbsent(code, c -> new HashMap());
                termDefinitionMap.put(language, new TermDefinition(code, text, description));
            }
        }
        return otherTermDefinitionMap;
    }

    private WebTemplateNode parseCCOMPLEXOBJECT(CCOMPLEXOBJECT ccomplexobject, String aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName) {
        Optional<String> expliziteName = OptNameHelper.extractName(ccomplexobject);
        WebTemplateNode node = this.buildNode((COBJECT)ccomplexobject, rmAttributeName, termDefinitionMap);
        node.setAqlPath(aqlPath);
        if (StringUtils.isNotBlank((CharSequence)ccomplexobject.getNodeId()) && expliziteName.isPresent()) {
            FlatPath path;
            FlatPath lastSegment = path = new FlatPath(node.getAqlPath());
            while (lastSegment.getChild() != null) {
                lastSegment = lastSegment.getChild();
            }
            lastSegment.addOtherPredicate("name/value", expliziteName.get().replace("\\", "\\\\").replace("'", "\\'"));
            node.setAqlPath(path.format(true));
            aqlPath = path.format(true);
        }
        CATTRIBUTE[] cattributes = ccomplexobject.getAttributesArray();
        HashMap<String, WebTemplateInput> inputMap = new HashMap<String, WebTemplateInput>();
        ArrayList<Pair> cardinaltyList = new ArrayList<Pair>();
        for (CATTRIBUTE cattribute : cattributes) {
            WebtemplateCardinality webtemplateCardinality;
            String pathLoop = aqlPath + PATH_DIVIDER + cattribute.getRmAttributeName();
            if (pathLoop.endsWith("/name")) continue;
            ArrayList<WebTemplateNode> newChildren = new ArrayList<WebTemplateNode>();
            for (COBJECT cobject : cattribute.getChildrenArray()) {
                if (cobject instanceof CPRIMITIVEOBJECT) {
                    inputMap.put(cattribute.getRmAttributeName(), this.inputHandler.extractInput((CPRIMITIVEOBJECT)cobject));
                    continue;
                }
                WebTemplateNode childNode = this.parseCOBJECT(cobject, pathLoop, termDefinitionMap, cattribute.getRmAttributeName());
                if (childNode == null) continue;
                newChildren.add(childNode);
            }
            List<WebTemplateNode> ismTransitionList = newChildren.stream().filter(n -> "ISM_TRANSITION".equals(n.getRmType())).collect(Collectors.toList());
            if (!ismTransitionList.isEmpty()) {
                WebTemplateNode ismTransition = new WebTemplateNode();
                ismTransition.setName(cattribute.getRmAttributeName());
                ismTransition.setId(this.buildId(cattribute.getRmAttributeName()));
                ismTransition.setMin(((WebTemplateNode)ismTransitionList.get(0)).getMin());
                ismTransition.setMax(((WebTemplateNode)ismTransitionList.get(0)).getMax());
                ismTransition.setRmType("ISM_TRANSITION");
                ismTransition.setInContext(true);
                ismTransition.setAqlPath(aqlPath + PATH_DIVIDER + cattribute.getRmAttributeName());
                WebTemplateNode careflowStep = new WebTemplateNode();
                WebTemplateNode careflowStepProto = ((WebTemplateNode)ismTransitionList.get(0)).findMatching(n -> n.getId().equals(CAREFLOW_STEP)).get(0);
                careflowStep.setMin(careflowStepProto.getMin());
                careflowStep.setMax(careflowStepProto.getMin());
                careflowStep.setName("Careflow_step");
                careflowStep.setId(CAREFLOW_STEP);
                careflowStep.setRmType(DV_CODED_TEXT);
                careflowStep.setInContext(true);
                careflowStep.setAqlPath(aqlPath + PATH_DIVIDER + cattribute.getRmAttributeName() + "/careflow_step");
                WebTemplateInput code = new WebTemplateInput();
                code.setSuffix("code");
                code.setType(CODED_TEXT);
                code.setTerminology(OPENEHR);
                ismTransitionList.forEach(i -> {
                    WebTemplateInputValue value = i.findChildById(CAREFLOW_STEP).get().getInputs().get(0).getList().get(0);
                    value.getCurrentStates().addAll(i.findChildById(CURRENT_STATE).get().getInputs().get(0).getList().stream().map(WebTemplateInputValue::getValue).collect(Collectors.toList()));
                    code.getList().add(value);
                });
                careflowStep.getInputs().add(code);
                ismTransition.getChildren().add(careflowStep);
                WebTemplateNode currentState = new WebTemplateNode();
                WebTemplateNode currentStateProto = ((WebTemplateNode)ismTransitionList.get(0)).findMatching(n -> n.getId().equals(CURRENT_STATE)).get(0);
                currentState.setMin(currentStateProto.getMin());
                currentState.setMax(currentStateProto.getMin());
                currentState.setRmType(DV_CODED_TEXT);
                currentState.setName("Current_state");
                currentState.setId(CURRENT_STATE);
                currentState.setInContext(true);
                currentState.setAqlPath(aqlPath + PATH_DIVIDER + cattribute.getRmAttributeName() + "/current_state");
                WebTemplateInput code2 = new WebTemplateInput();
                code2.setSuffix("code");
                code2.setType(CODED_TEXT);
                code2.setTerminology(OPENEHR);
                code2.getList().addAll(ismTransitionList.stream().map(n -> n.findMatching(k -> k.getId().equals(CURRENT_STATE))).flatMap(Collection::stream).map(WebTemplateNode::getInputs).flatMap(Collection::stream).map(WebTemplateInput::getList).flatMap(Collection::stream).collect(Collectors.toList()));
                currentState.getInputs().add(code2);
                ismTransition.getChildren().add(currentState);
                WebTemplateNode transition = ((WebTemplateNode)ismTransitionList.get(0)).findChildById("transition").orElseThrow();
                transition.setAqlPath(aqlPath + PATH_DIVIDER + cattribute.getRmAttributeName() + "/transition");
                transition.setInContext(true);
                ismTransition.getChildren().add(transition);
                node.getChildren().add(ismTransition);
            }
            if ((webtemplateCardinality = (WebtemplateCardinality)Arrays.stream(this.extractChildren((XmlObject)cattribute, "cardinality")).findFirst().map(this::buildCardinality).orElse(null)) != null) {
                cardinaltyList.add(Pair.of((Object)webtemplateCardinality, newChildren.stream().map(WebTemplateNode::getAqlPath).collect(Collectors.toList())));
            }
            node.getChildren().addAll(newChildren);
        }
        Collection<List<WebTemplateNode>> values = node.getChoicesInChildren().values();
        values.stream().flatMap(Collection::stream).filter(n -> n.getRmType().startsWith("DV_")).forEach(n -> n.setId(n.getRmType().replace("DV_", "").toLowerCase() + "_value"));
        if (node.getRmType().equals("ELEMENT")) {
            if (node.getChildren().isEmpty()) {
                this.addAnyNode(node, "DV_TEXT", inputMap);
                this.addAnyNode(node, DV_CODED_TEXT, inputMap);
                this.addAnyNode(node, "DV_MULTIMEDIA", inputMap);
                this.addAnyNode(node, "DV_PARSABLE", inputMap);
                this.addAnyNode(node, "DV_STATE", inputMap);
                this.addAnyNode(node, "DV_BOOLEAN", inputMap);
                this.addAnyNode(node, "DV_IDENTIFIER", inputMap);
                this.addAnyNode(node, "DV_URI", inputMap);
                this.addAnyNode(node, "DV_EHR_URI", inputMap);
                this.addAnyNode(node, "DV_DURATION", inputMap);
                this.addAnyNode(node, "DV_QUANTITY", inputMap);
                this.addAnyNode(node, "DV_COUNT", inputMap);
                this.addAnyNode(node, "DV_PROPORTION", inputMap);
                this.addAnyNode(node, "DV_DATE_TIME", inputMap);
                this.addAnyNode(node, "DV_TIME", inputMap);
                this.addAnyNode(node, "DV_ORDINAL", inputMap);
                this.addAnyNode(node, "DV_DATE", inputMap);
            } else {
                List<WebTemplateNode> trueChildren = node.getChildren().stream().filter(n -> !List.of("null_flavour", "feeder_audit").contains(n.getName()) || !n.isNullable()).collect(Collectors.toList());
                trueChildren.forEach(c -> this.pushProperties(node, (WebTemplateNode)c));
                if (trueChildren.size() == 1) {
                    WebTemplateNode value = (WebTemplateNode)trueChildren.get(0);
                    value.setId(node.getId(false));
                    value.setAnnotations(node.getAnnotations());
                } else if (trueChildren.stream().map(WebTemplateNode::getRmType).collect(Collectors.toList()).containsAll(List.of("DV_TEXT", DV_CODED_TEXT)) && node.getChoicesInChildren().size() > 0) {
                    WebTemplateNode merged = new WebTemplateNode();
                    merged.setId(node.getId(false));
                    merged.setName(node.getName());
                    merged.setMax(node.getMax());
                    merged.setMin(node.getMin());
                    merged.setRmType(DV_CODED_TEXT);
                    WebTemplateNode codedTextValue = node.findChildById("coded_text_value").orElseThrow();
                    merged.getInputs().addAll(codedTextValue.getInputs());
                    merged.setAqlPath(codedTextValue.getAqlPath());
                    merged.getLocalizedDescriptions().putAll(node.getLocalizedDescriptions());
                    merged.getLocalizedNames().putAll(node.getLocalizedNames());
                    merged.setLocalizedName(node.getLocalizedName());
                    merged.setAnnotations(node.getAnnotations());
                    WebTemplateInput other = this.inputHandler.buildWebTemplateInput("other", "TEXT");
                    merged.getInputs().add(other);
                    merged.getInputs().stream().filter(i -> Objects.equals(i.getSuffix(), "code")).findAny().ifPresent(i -> i.setListOpen(true));
                    node.getChildren().add(merged);
                } else if (node.getChoicesInChildren().isEmpty()) {
                    node.getChildren().stream().filter(n -> !List.of("null_flavour", "feeder_audit").contains(n.getName()) || !n.isNullable()).filter(n -> n.getRmType().startsWith("DV_")).forEach(n -> {
                        n.setId(n.getRmType().replace("DV_", "").toLowerCase() + "_value");
                        n.getLocalizedDescriptions().putAll(node.getLocalizedDescriptions());
                        n.getLocalizedNames().putAll(node.getLocalizedNames());
                    });
                }
            }
        }
        if (node.getRmType().equals(DV_CODED_TEXT)) {
            List<WebTemplateNode> matching = node.findMatching(n -> n.getRmType().equals("CODE_PHRASE"));
            if (!matching.isEmpty()) {
                node.getInputs().addAll(matching.get(0).getInputs());
            } else {
                node.getInputs().add(this.inputHandler.buildWebTemplateInput("value", "TEXT"));
                node.getInputs().add(this.inputHandler.buildWebTemplateInput("code", "TEXT"));
            }
        }
        this.addRMAttributes(node, aqlPath, termDefinitionMap);
        if (node.getInputs().isEmpty()) {
            this.inputHandler.addInputs(node, inputMap);
        }
        OPTParser.makeIdUnique(node);
        cardinaltyList.forEach(p -> {
            List nodeIds = ((List)p.getRight()).stream().map(s -> node.findMatching(n -> n.getAqlPath().equals(s))).flatMap(Collection::stream).map(WebTemplateNode::getId).collect(Collectors.toList());
            if (((WebtemplateCardinality)p.getKey()).getMax() != null && ((WebtemplateCardinality)p.getKey()).getMax() < nodeIds.size()) {
                ((WebtemplateCardinality)p.getKey()).getIds().addAll(nodeIds);
                node.getCardinalities().add((WebtemplateCardinality)p.getKey());
            }
        });
        node.getChildren().forEach(child -> this.addInContext(node, (WebTemplateNode)child));
        return node;
    }

    private void addAnyNode(WebTemplateNode node, String rmType, Map<String, WebTemplateInput> inputMap) {
        WebTemplateNode subNode = new WebTemplateNode();
        subNode.setRmType(rmType);
        subNode.setId(subNode.getRmType().replace("DV_", "").toLowerCase() + "_value");
        subNode.setName(node.getName());
        subNode.setAqlPath(node.getAqlPath(true) + "/value");
        subNode.setInContext(true);
        subNode.setMax(1);
        subNode.setMin(0);
        subNode.setLocalizedName(node.getLocalizedName());
        subNode.getLocalizedDescriptions().putAll(node.getLocalizedDescriptions());
        subNode.getLocalizedNames().putAll(node.getLocalizedNames());
        this.inputHandler.addInputs(subNode, inputMap);
        node.getChildren().add(subNode);
    }

    private void addInContext(WebTemplateNode node, WebTemplateNode child) {
        Map<Class<Composition>, List<String>> contextAttributes = Map.of(Locatable.class, List.of("language"), Action.class, List.of("time"), Activity.class, List.of("timing", "action_archetype_id"), Instruction.class, List.of("narrative"), IsmTransition.class, List.of(CURRENT_STATE, CAREFLOW_STEP, "transition"), History.class, List.of("origin"), Event.class, List.of("time"), Entry.class, List.of("language", "provider", "other_participations", "subject", "encoding"), EventContext.class, List.of("start_time", "end_time", "location", "setting", "healthCareFacility", "participations"), Composition.class, List.of("language", "territory", "composer", "category"));
        RMTypeInfo typeInfo = ARCHIE_RM_INFO_LOOKUP.getTypeInfo(node.getRmType());
        if (typeInfo != null) {
            contextAttributes.forEach((k, v) -> {
                if (k.isAssignableFrom(typeInfo.getJavaClass()) && v.contains(child.getId())) {
                    child.setInContext(true);
                }
            });
        }
    }

    private WebtemplateCardinality buildCardinality(XmlObject xmlObject) {
        WebtemplateCardinality webtemplateCardinality = new WebtemplateCardinality();
        Arrays.stream(this.extractChildren(xmlObject, "interval")).map(x -> this.extractChildren((XmlObject)x, "lower")).flatMap(Arrays::stream).findFirst().map(x -> x.newCursor().getTextValue()).map(Integer::valueOf).ifPresent(webtemplateCardinality::setMin);
        Arrays.stream(this.extractChildren(xmlObject, "interval")).map(x -> this.extractChildren((XmlObject)x, "upper")).flatMap(Arrays::stream).findFirst().map(x -> x.newCursor().getTextValue()).map(Integer::valueOf).ifPresent(webtemplateCardinality::setMax);
        return webtemplateCardinality;
    }

    private void pushProperties(WebTemplateNode node, WebTemplateNode value) {
        value.setName(node.getName());
        value.setMax(node.getMax());
        value.setMin(node.getMin());
        value.getLocalizedDescriptions().putAll(node.getLocalizedDescriptions());
        value.getLocalizedNames().putAll(node.getLocalizedNames());
        value.setLocalizedName(node.getLocalizedName());
    }

    public static void makeIdUnique(WebTemplateNode node) {
        node.getChildren().stream().collect(Collectors.groupingBy(node1 -> node1.getId(false))).values().forEach(l -> {
            if (l.size() > 1) {
                for (int i = 0; i < l.size(); ++i) {
                    if (i <= 0) continue;
                    WebTemplateNode n = (WebTemplateNode)l.get(i);
                    n.setOptionalIdNumber(i + 1);
                }
            } else {
                ((WebTemplateNode)l.get(0)).setOptionalIdNumber(null);
            }
        });
    }

    private void addRMAttributes(WebTemplateNode node, String aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap) {
        RMTypeInfo typeInfo = ARCHIE_RM_INFO_LOOKUP.getTypeInfo(node.getRmType());
        if (typeInfo != null && (Locatable.class.isAssignableFrom(typeInfo.getJavaClass()) || EventContext.class.isAssignableFrom(typeInfo.getJavaClass()) || DvInterval.class.isAssignableFrom(typeInfo.getJavaClass()) || IsmTransition.class.isAssignableFrom(typeInfo.getJavaClass()))) {
            node.getChildren().addAll(typeInfo.getAttributes().values().stream().filter(s -> !s.isComputed()).filter(s -> !Element.class.isAssignableFrom(typeInfo.getJavaClass()) || List.of("feeder_audit", "null_flavour").contains(s.getRmName())).filter(s -> !List.of("value").contains(s.getRmName())).filter(s -> !Locatable.class.isAssignableFrom(s.getTypeInCollection())).map(i -> this.buildNodeForAttribute((RMAttributeInfo)i, aqlPath, termDefinitionMap)).filter(n -> node.getChildren().stream().map(WebTemplateNode::getId).noneMatch(s -> s.equals(n.getId()))).collect(Collectors.toList()));
        }
    }

    private WebTemplateNode buildNodeForAttribute(RMAttributeInfo attributeInfo, String aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap) {
        WebTemplateNode node = new WebTemplateNode();
        node.setAqlPath(aqlPath + PATH_DIVIDER + attributeInfo.getRmName());
        node.setName(attributeInfo.getRmName());
        node.setId(this.buildId(attributeInfo.getRmName()));
        node.setRmType(attributeInfo.getTypeNameInCollection());
        node.setMax(attributeInfo.isMultipleValued() ? -1 : 1);
        node.setMin(attributeInfo.isNullable() ? 0 : 1);
        if (attributeInfo.getRmName().equals("action_archetype_id")) {
            node.setMin(1);
        }
        this.inputHandler.addInputs(node, Collections.emptyMap());
        this.addRMAttributes(node, node.getAqlPath(), termDefinitionMap);
        return node;
    }

    private WebTemplateNode parseCOBJECT(COBJECT cobject, String aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName) {
        if (cobject instanceof CARCHETYPEROOT) {
            String nodeId = ((CARCHETYPEROOT)cobject).getArchetypeId().getValue();
            Object pathLoop = StringUtils.isNotBlank((CharSequence)nodeId) ? aqlPath + "[" + nodeId + "]" : aqlPath;
            return this.parseCARCHETYPEROO((CARCHETYPEROOT)cobject, (String)pathLoop);
        }
        if (cobject instanceof CCOMPLEXOBJECT) {
            String nodeId = cobject.getNodeId();
            Object pathLoop = StringUtils.isNotBlank((CharSequence)nodeId) ? aqlPath + "[" + nodeId + "]" : aqlPath;
            return this.parseCCOMPLEXOBJECT((CCOMPLEXOBJECT)cobject, (String)pathLoop, termDefinitionMap, rmAttributeName);
        }
        if (cobject instanceof CDOMAINTYPE) {
            String nodeId = cobject.getNodeId();
            Object pathLoop = StringUtils.isNotBlank((CharSequence)nodeId) ? aqlPath + "[" + nodeId + "]" : aqlPath;
            return this.parseCDOMAINTYPE((CDOMAINTYPE)cobject, (String)pathLoop, termDefinitionMap, rmAttributeName);
        }
        if (cobject instanceof ARCHETYPESLOT) {
            String nodeId = cobject.getNodeId();
            Object pathLoop = StringUtils.isNotBlank((CharSequence)nodeId) ? aqlPath + "[" + nodeId + "]" : aqlPath;
            return this.parseARCHETYPESLOT((ARCHETYPESLOT)cobject, (String)pathLoop, termDefinitionMap, rmAttributeName);
        }
        return null;
    }

    private WebTemplateNode parseARCHETYPESLOT(ARCHETYPESLOT cobject, String pathLoop, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName) {
        WebTemplateNode node = this.buildNode((COBJECT)cobject, rmAttributeName, termDefinitionMap);
        node.setAqlPath(pathLoop);
        return node;
    }

    private WebTemplateNode parseCDOMAINTYPE(CDOMAINTYPE cdomaintype, String aqlPath, Map<String, Map<String, TermDefinition>> termDefinitionMap, String rmAttributeName) {
        WebTemplateNode node = this.buildNode((COBJECT)cdomaintype, rmAttributeName, termDefinitionMap);
        node.setAqlPath(aqlPath);
        if (cdomaintype instanceof CDVSTATE) {
            throw new SdkException(String.format("Unexpected class: %s", cdomaintype.getClass().getSimpleName()));
        }
        if (cdomaintype instanceof CDVQUANTITY) {
            WebTemplateInput magnitude = new WebTemplateInput();
            magnitude.setSuffix("magnitude");
            magnitude.setType("DECIMAL");
            Optional.of((CDVQUANTITY)cdomaintype).map(CDVQUANTITY::getAssumedValue).map(DVQUANTITY::getMagnitude).map(d -> Double.toString(d)).ifPresent(magnitude::setDefaultValue);
            this.inputHandler.findDefaultValue(node, "magnitude").ifPresent(magnitude::setDefaultValue);
            node.getInputs().add(magnitude);
            WebTemplateInput unit = new WebTemplateInput();
            unit.setSuffix("unit");
            unit.setType(CODED_TEXT);
            Optional.of((CDVQUANTITY)cdomaintype).map(CDVQUANTITY::getAssumedValue).map(DVQUANTITY::getUnits).ifPresent(unit::setDefaultValue);
            this.inputHandler.findDefaultValue(node, "units").ifPresent(unit::setDefaultValue);
            node.getInputs().add(unit);
            Arrays.stream(((CDVQUANTITY)cdomaintype).getListArray()).forEach(o -> {
                WebTemplateInputValue value = new WebTemplateInputValue();
                value.setLabel(o.getUnits());
                value.setValue(o.getUnits());
                WebTemplateValidation validation = new WebTemplateValidation();
                boolean addValidation = false;
                if (o.getMagnitude() != null) {
                    addValidation = true;
                    validation.setRange(this.inputHandler.extractInterval((Interval)o.getMagnitude()));
                }
                if (o.getPrecision() != null) {
                    addValidation = true;
                    validation.setPrecision(this.inputHandler.extractInterval((Interval)o.getPrecision()));
                }
                if (addValidation) {
                    value.setValidation(validation);
                }
                value.getLocalizedLabels().putAll(termDefinitionMap.getOrDefault(o.getUnits(), Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getValue())));
                unit.getList().add(value);
            });
            if (unit.getList().size() == 1) {
                magnitude.setValidation(unit.getList().get(0).getValidation());
            }
        } else if (cdomaintype instanceof CDVORDINAL) {
            WebTemplateInput code = new WebTemplateInput();
            this.inputHandler.findDefaultValue(node, "defining_code").ifPresent(code::setDefaultValue);
            code.setType(CODED_TEXT);
            node.getInputs().add(code);
            Optional.of((CDVORDINAL)cdomaintype).map(CDVORDINAL::getAssumedValue).map(DVORDINAL::getSymbol).map(DVCODEDTEXT::getDefiningCode).map(CODEPHRASE::getCodeString).ifPresent(code::setDefaultValue);
            Arrays.stream(((CDVORDINAL)cdomaintype).getListArray()).forEach(o -> {
                WebTemplateInputValue value = new WebTemplateInputValue();
                value.setOrdinal(o.getValue());
                value.setValue(o.getSymbol().getDefiningCode().getCodeString());
                value.getLocalizedLabels().putAll(Optional.ofNullable((Map)termDefinitionMap.get(value.getValue())).map(Map::entrySet).stream().flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getValue())));
                value.getLocalizedDescriptions().putAll(Optional.ofNullable((Map)termDefinitionMap.get(value.getValue())).map(Map::entrySet).stream().flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getDescription())));
                value.setLabel(value.getLocalizedLabels().get(this.defaultLanguage));
                if (!value.getLocalizedDescriptions().containsKey(this.defaultLanguage)) {
                    value.getLocalizedDescriptions().put(this.defaultLanguage, "");
                }
                code.getList().add(value);
            });
        } else if (cdomaintype instanceof CCODEPHRASE) {
            WebTemplateInput code = new WebTemplateInput();
            this.inputHandler.findDefaultValue(node, "defining_code").ifPresent(code::setDefaultValue);
            code.setSuffix("code");
            node.getInputs().add(code);
            Optional.of((CCODEPHRASE)cdomaintype).map(CCODEPHRASE::getAssumedValue).map(CODEPHRASE::getCodeString).ifPresent(code::setDefaultValue);
            if (cdomaintype instanceof CCODEREFERENCE) {
                code.setTerminology(Optional.of((CCODEREFERENCE)cdomaintype).map(CCODEREFERENCE::getReferenceSetUri).map(s -> StringUtils.removeStart((String)s, (String)"terminology:")).orElse(null));
            } else {
                code.setTerminology(Optional.of((CCODEPHRASE)cdomaintype).map(CCODEPHRASE::getTerminologyId).map(OBJECTID::getValue).orElse(null));
            }
            if (code.getTerminology().equals(OPENEHR)) {
                ValueSet valueSet = TerminologyProvider.findOpenEhrValueSet((String)code.getTerminology(), (String[])((CCODEPHRASE)cdomaintype).getCodeListArray(), (String)this.defaultLanguage);
                Map collect = this.languages.stream().collect(Collectors.toMap(Function.identity(), l -> TerminologyProvider.findOpenEhrValueSet((String)code.getTerminology(), (String[])((CCODEPHRASE)cdomaintype).getCodeListArray(), (String)l)));
                valueSet.getTherms().forEach(t -> {
                    WebTemplateInputValue value = new WebTemplateInputValue();
                    value.setValue(t.getCode());
                    value.setLabel(t.getValue());
                    value.getLocalizedLabels().putAll(collect.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ValueSet)e.getValue()).getTherms().stream().filter(x -> x.getCode().equals(t.getCode())).findAny().map(TermDefinition::getValue).orElse(""))));
                    code.getList().add(value);
                });
            } else {
                Arrays.stream(((CCODEPHRASE)cdomaintype).getCodeListArray()).forEach(o -> {
                    WebTemplateInputValue value = new WebTemplateInputValue();
                    Optional<TermDefinition> termDefinition = Optional.ofNullable((Map)termDefinitionMap.get(o)).map(e -> (TermDefinition)e.get(this.defaultLanguage));
                    if (termDefinition.isPresent()) {
                        value.setValue(termDefinition.get().getCode());
                        value.setLabel(termDefinition.get().getValue());
                        value.getLocalizedLabels().putAll(termDefinitionMap.getOrDefault(o, Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getValue())));
                        value.getLocalizedDescriptions().putAll(termDefinitionMap.getOrDefault(o, Collections.emptyMap()).entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((TermDefinition)e.getValue()).getDescription())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getDescription())));
                        if (!value.getLocalizedDescriptions().containsKey(this.defaultLanguage)) {
                            value.getLocalizedDescriptions().put(this.defaultLanguage, "");
                        }
                        code.getList().add(value);
                    }
                });
            }
            if (code.getList().isEmpty()) {
                code.setType("TEXT");
                WebTemplateInput value = this.inputHandler.buildWebTemplateInput("value", "TEXT");
                value.setTerminology(code.getTerminology());
                node.getInputs().add(value);
            } else {
                code.setType(CODED_TEXT);
            }
        } else {
            throw new SdkException(String.format("Unexpected class: %s", cdomaintype.getClass().getSimpleName()));
        }
        return node;
    }

    private WebTemplateNode buildNode(COBJECT cobject, String rmAttributeName, Map<String, Map<String, TermDefinition>> termDefinitionMap) {
        WebTemplateNode node = new WebTemplateNode();
        node.setRmType(cobject.getRmTypeName());
        IntervalOfInteger occurrences = cobject.getOccurrences();
        node.setMin(occurrences.getLowerUnbounded() ? -1 : occurrences.getLower());
        node.setMax(occurrences.getUpperUnbounded() ? -1 : occurrences.getUpper());
        String nodeId = cobject.getNodeId();
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            Optional<String> expliziteName = cobject instanceof CCOMPLEXOBJECT ? OptNameHelper.extractName((CCOMPLEXOBJECT)cobject) : Optional.empty();
            String name = expliziteName.orElse(termDefinitionMap.get(nodeId).get(this.defaultLanguage).getValue());
            node.setName(name);
            node.setId(this.buildId(name));
            node.setNodeId(nodeId);
            node.setLocalizedName(name);
            node.getLocalizedNames().putAll(termDefinitionMap.get(nodeId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TermDefinition)e.getValue()).getValue())));
            node.getLocalizedNames().put(this.defaultLanguage, name);
            node.getLocalizedDescriptions().putAll(termDefinitionMap.get(nodeId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable(((TermDefinition)e.getValue()).getDescription()).orElse(((TermDefinition)e.getValue()).getValue()))));
            Optional.of(termDefinitionMap.get(nodeId)).map(m -> (TermDefinition)m.get(this.defaultLanguage)).map(TermDefinition::getOther).stream().map(Map::entrySet).flatMap(Collection::stream).forEach(e -> {
                if (node.getAnnotations() == null) {
                    node.setAnnotations(new WebTemplateAnnotation());
                }
                if (((String)e.getKey()).equals("comment")) {
                    node.getAnnotations().setComment((String)e.getValue());
                } else {
                    node.getAnnotations().getOther().put((String)e.getKey(), (String)e.getValue());
                }
            });
        } else {
            String name = StringUtils.isNotBlank((CharSequence)rmAttributeName) ? rmAttributeName : cobject.getRmTypeName();
            node.setId(this.buildId(name));
            node.setName(name);
            node.setLocalizedName(name);
        }
        return node;
    }

    private String buildId(String term) {
        Object normalTerm = StringUtils.normalizeSpace((String)term.toLowerCase().replaceAll("[^a-z0-9\u00e4\u00fc\u00f6\u00df._\\-]", " ").trim()).replace(" ", "_");
        if (StringUtils.isNumeric((CharSequence)((String)normalTerm).substring(0, 1))) {
            normalTerm = "a" + (String)normalTerm;
        }
        return normalTerm;
    }
}

