/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FlatPath {
    private final String name;
    private final String atCode;
    private FlatPath child;
    private final Map<String, String> otherPredicates;
    private final String attributeName;
    private final boolean startWithSlash;

    public FlatPath(String path) {
        String[] split;
        if (StringUtils.isBlank((CharSequence)path)) {
            this.name = "";
            this.atCode = null;
            this.child = null;
            this.otherPredicates = new HashMap<String, String>();
            this.attributeName = null;
            this.startWithSlash = false;
            return;
        }
        this.startWithSlash = StringUtils.startsWith((CharSequence)path, (CharSequence)"/");
        String[] strings = this.split(StringUtils.stripStart((String)path, (String)"/"), 2, "/");
        if (strings.length == 2) {
            if (StringUtils.endsWith((CharSequence)strings[0], (CharSequence)"]")) {
                int fist = strings[0].indexOf("[");
                split = new String[]{strings[0].substring(0, fist), strings[0].substring(fist)};
            } else {
                split = new String[]{strings[0]};
            }
            this.name = StringUtils.stripStart((String)split[0], (String)"/");
            this.child = new FlatPath("/" + strings[1]);
            this.attributeName = null;
        } else {
            this.child = null;
            String[] attributeSplit = this.split(strings[0], null, "|");
            this.attributeName = attributeSplit.length == 2 ? attributeSplit[1] : null;
            if (StringUtils.endsWith((CharSequence)attributeSplit[0], (CharSequence)"]")) {
                int fist = attributeSplit[0].indexOf("[");
                split = new String[]{attributeSplit[0].substring(0, fist), attributeSplit[0].substring(fist)};
            } else {
                split = new String[]{attributeSplit[0]};
            }
            this.name = StringUtils.stripStart((String)split[0], (String)"/");
        }
        if (split.length == 2) {
            String node = StringUtils.removeEnd((String)StringUtils.removeStart((String)split[1], (String)"["), (String)"]");
            String[] predicates = this.split(node, null, "and", ",");
            this.atCode = predicates[0].trim();
            this.otherPredicates = new HashMap<String, String>();
            for (int i = 1; i < predicates.length; ++i) {
                String[] pair = this.split(predicates[i], null, "=");
                if (i == 1 && pair.length == 1) {
                    this.otherPredicates.put("name/value", StringUtils.unwrap((String)pair[0], (String)"'"));
                    continue;
                }
                if (pair.length != 2) continue;
                this.otherPredicates.put(pair[0].trim(), StringUtils.unwrap((String)pair[1], (String)"'"));
            }
        } else {
            this.atCode = null;
            this.otherPredicates = Collections.emptyMap();
        }
    }

    private String[] split(String path, Integer max, String ... search) {
        ArrayList<String> strings = new ArrayList<String>();
        List<String> searchList = Arrays.asList(search);
        boolean inBrackets = false;
        boolean inQuotes = false;
        boolean escape = false;
        int last = 0;
        for (int i = 0; i < path.length(); ++i) {
            String pathAfter = path.substring(i);
            if (pathAfter.startsWith("[") && !inQuotes) {
                inBrackets = true;
                escape = false;
                continue;
            }
            if (pathAfter.startsWith("]") && !inQuotes) {
                inBrackets = false;
                escape = false;
                continue;
            }
            if (pathAfter.startsWith("'") && !escape) {
                inQuotes = !inQuotes;
                escape = false;
                continue;
            }
            if (pathAfter.startsWith("\\") && !escape) {
                escape = true;
                continue;
            }
            if (searchList.stream().anyMatch(pathAfter::startsWith) && !inBrackets && !inQuotes) {
                strings.add(path.substring(last, i));
                last = searchList.stream().filter(pathAfter::startsWith).findAny().orElseThrow().length() + i;
                if (max == null || strings.size() != max - 1) continue;
                strings.add(path.substring(last));
                break;
            }
            escape = false;
        }
        if (strings.isEmpty()) {
            strings.add(path);
        } else if (last < path.length() && max == null) {
            strings.add(path.substring(last));
        }
        return (String[])strings.stream().toArray(String[]::new);
    }

    public String getName() {
        return this.name;
    }

    public String getAtCode() {
        return this.atCode;
    }

    public FlatPath getChild() {
        return this.child;
    }

    public String getPath() {
        return StringUtils.removeEnd((String)this.toString(), (String)("|" + this.getLast().getAttributeName()));
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String findOtherPredicate(String name) {
        return this.otherPredicates.get(name);
    }

    public void addOtherPredicate(String name, String value) {
        this.otherPredicates.put(name, value);
    }

    public String toString() {
        return this.format(true);
    }

    public String format(boolean withOtherPredicates) {
        if (withOtherPredicates) {
            return this.format(OtherPredicatesFormate.FULL);
        }
        return this.format(OtherPredicatesFormate.NONE);
    }

    public String format(OtherPredicatesFormate otherPredicatesFormate) {
        StringBuilder sb = new StringBuilder();
        if (this.startWithSlash) {
            sb.append("/");
        }
        sb.append(this.name);
        if (StringUtils.isNotBlank((CharSequence)this.atCode)) {
            sb.append("[").append(this.atCode);
            if (!otherPredicatesFormate.equals((Object)OtherPredicatesFormate.NONE)) {
                this.otherPredicates.forEach((key, value) -> {
                    if (otherPredicatesFormate.equals((Object)OtherPredicatesFormate.SHORTED) && key.equals("name/value")) {
                        sb.append(",").append("'").append((String)value).append("'");
                    } else {
                        sb.append(" and ").append((String)key).append("=").append("'").append((String)value).append("'");
                    }
                });
            }
            sb.append("]");
        }
        if (this.child != null) {
            sb.append(this.child.format(otherPredicatesFormate));
        }
        if (this.attributeName != null) {
            sb.append("|").append(this.attributeName);
        }
        return sb.toString();
    }

    public FlatPath getLast() {
        FlatPath path = this;
        while (path.getChild() != null) {
            path = path.getChild();
        }
        return path;
    }

    public static FlatPath removeEnd(FlatPath path, FlatPath remove) {
        return new FlatPath(StringUtils.removeEnd((String)path.toString(), (String)remove.toString()));
    }

    public static FlatPath removeStart(FlatPath path, FlatPath remove) {
        return new FlatPath(StringUtils.removeStart((String)path.toString(), (String)remove.toString()));
    }

    public static FlatPath addEnd(FlatPath path, FlatPath add) {
        return new FlatPath(path.toString() + "/" + StringUtils.removeStart((String)add.toString(), (String)"/"));
    }

    public static enum OtherPredicatesFormate {
        NONE,
        SHORTED,
        FULL;

    }
}

