/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.webtemplate.model.AqlPathSerializer;
import org.ehrbase.webtemplate.model.ProportionType;
import org.ehrbase.webtemplate.model.WebTemplateAnnotation;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateTerminology;
import org.ehrbase.webtemplate.model.WebtemplateCardinality;
import org.ehrbase.webtemplate.parser.FlatPath;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class WebTemplateNode
implements Serializable {
    private static final ArchieRMInfoLookup RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private String id;
    @JsonIgnore
    private Integer optionalIdNumber;
    private String name;
    private String localizedName;
    private String rmType;
    private String nodeId;
    private int min;
    private int max;
    private final Map<String, String> localizedNames = new HashMap<String, String>();
    private final Map<String, String> localizedDescriptions = new HashMap<String, String>();
    @JsonSerialize(using=AqlPathSerializer.class)
    private String aqlPath;
    private final List<WebTemplateNode> children = new ArrayList<WebTemplateNode>();
    private final List<WebTemplateInput> inputs = new ArrayList<WebTemplateInput>();
    private Boolean inContext;
    private final Map<String, WebTemplateTerminology> termBindings = new HashMap<String, WebTemplateTerminology>();
    private final List<String> dependsOn = new ArrayList<String>();
    private WebTemplateAnnotation annotations;
    private final List<ProportionType> proportionTypes = new ArrayList<ProportionType>();
    private final List<WebtemplateCardinality> cardinalities = new ArrayList<WebtemplateCardinality>();

    public WebTemplateNode() {
    }

    public WebTemplateNode(WebTemplateNode other) {
        this.id = other.id;
        this.optionalIdNumber = other.optionalIdNumber;
        this.name = other.name;
        this.localizedName = other.localizedName;
        this.rmType = other.rmType;
        this.nodeId = other.nodeId;
        this.min = other.min;
        this.max = other.max;
        this.aqlPath = other.aqlPath;
        this.inContext = other.inContext;
        this.dependsOn.addAll(other.dependsOn);
        this.annotations = other.annotations != null ? new WebTemplateAnnotation(other.annotations) : null;
        this.cardinalities.addAll(other.cardinalities.stream().map(WebtemplateCardinality::new).collect(Collectors.toList()));
        this.inputs.addAll(other.getInputs().stream().map(WebTemplateInput::new).collect(Collectors.toList()));
        this.getChildren().addAll(other.children.stream().map(WebTemplateNode::new).collect(Collectors.toList()));
        this.localizedNames.putAll(other.localizedNames);
        this.localizedDescriptions.putAll(other.localizedDescriptions);
        this.proportionTypes.addAll(other.getProportionTypes());
        this.termBindings.putAll(other.termBindings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new WebTemplateTerminology((WebTemplateTerminology)e.getValue()))));
    }

    public String getId() {
        return this.getId(true);
    }

    public String getId(boolean withOptionalIdNumber) {
        if (withOptionalIdNumber && this.optionalIdNumber != null) {
            return this.id + this.optionalIdNumber;
        }
        return this.id;
    }

    public void setOptionalIdNumber(Integer optionalIdNumber) {
        this.optionalIdNumber = optionalIdNumber;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public String getRmType() {
        return this.rmType;
    }

    public void setRmType(String rmType) {
        this.rmType = rmType;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public Map<String, String> getLocalizedNames() {
        return this.localizedNames;
    }

    public Map<String, String> getLocalizedDescriptions() {
        return this.localizedDescriptions;
    }

    public String getAqlPath() {
        return this.aqlPath;
    }

    public String getAqlPath(boolean withOtherPredicates) {
        return new FlatPath(this.aqlPath).format(withOtherPredicates);
    }

    public void setAqlPath(String aqlPath) {
        this.aqlPath = aqlPath;
    }

    public List<WebTemplateNode> getChildren() {
        return this.children;
    }

    public List<WebtemplateCardinality> getCardinalities() {
        return this.cardinalities;
    }

    @JsonIgnore
    public Map<String, List<WebTemplateNode>> getChoicesInChildren() {
        return this.children.stream().collect(Collectors.groupingBy(WebTemplateNode::getAqlPath)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<WebTemplateInput> getInputs() {
        return this.inputs;
    }

    public Boolean getInContext() {
        return this.inContext;
    }

    public void setInContext(Boolean inContext) {
        this.inContext = inContext;
    }

    public Map<String, WebTemplateTerminology> getTermBindings() {
        return this.termBindings;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public WebTemplateAnnotation getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(WebTemplateAnnotation annotations) {
        this.annotations = annotations;
    }

    public List<ProportionType> getProportionTypes() {
        return this.proportionTypes;
    }

    public Optional<WebTemplateNode> findChildById(String id) {
        return this.children.stream().filter(n -> n.getId().equals(id)).findAny();
    }

    public String buildRelativPath(WebTemplateNode child) {
        return FlatPath.removeStart(new FlatPath(child.getAqlPath()), new FlatPath(this.getAqlPath())).toString();
    }

    public List<WebTemplateNode> findMatching(Predicate<WebTemplateNode> filter) {
        ArrayList<WebTemplateNode> matching = new ArrayList<WebTemplateNode>(this.children.stream().map(c -> c.findMatching(filter)).flatMap(Collection::stream).collect(Collectors.toList()));
        if (filter.test(this)) {
            matching.add(this);
        }
        return matching;
    }

    public List<WebTemplateNode> multiValued() {
        ArrayList<WebTemplateNode> matching = new ArrayList<WebTemplateNode>(this.children.stream().map(WebTemplateNode::multiValued).flatMap(Collection::stream).collect(Collectors.toList()));
        if (this.max != 1) {
            matching.add(this);
        }
        Map<String, List<WebTemplateNode>> collect = this.children.stream().collect(Collectors.groupingBy(n -> new FlatPath(n.getAqlPath()).format(false)));
        collect.forEach((k, v) -> {
            if (v.size() > 1) {
                matching.addAll(v.stream().filter(n -> n.max == 1).collect(Collectors.toList()));
            }
        });
        return matching;
    }

    @JsonIgnore
    public boolean isArchetype() {
        return RM_INFO_LOOKUP.getTypeInfo(this.getRmType()) != null && Locatable.class.isAssignableFrom(RM_INFO_LOOKUP.getTypeInfo(this.getRmType()).getJavaClass()) && !StringUtils.startsWith((CharSequence)this.getNodeId(), (CharSequence)"at");
    }

    @JsonIgnore
    public boolean isArchetypeSlot() {
        return RM_INFO_LOOKUP.getTypeInfo(this.getRmType()) != null && Locatable.class.isAssignableFrom(RM_INFO_LOOKUP.getTypeInfo(this.getRmType()).getJavaClass()) && StringUtils.startsWith((CharSequence)this.getNodeId(), (CharSequence)"at") && this.getChildren().isEmpty();
    }

    @JsonIgnore
    public boolean isNullable() {
        return this.min == 0;
    }

    @JsonIgnore
    public boolean isMulti() {
        return this.max != 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebTemplateNode that = (WebTemplateNode)o;
        return this.min == that.min && this.max == that.max && Objects.equals(this.id, that.id) && Objects.equals(this.optionalIdNumber, that.optionalIdNumber) && Objects.equals(this.name, that.name) && Objects.equals(this.localizedName, that.localizedName) && Objects.equals(this.rmType, that.rmType) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.localizedNames, that.localizedNames) && Objects.equals(this.localizedDescriptions, that.localizedDescriptions) && Objects.equals(this.aqlPath, that.aqlPath) && Objects.equals(this.children, that.children) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.inContext, that.inContext) && Objects.equals(this.termBindings, that.termBindings) && Objects.equals(this.dependsOn, that.dependsOn) && Objects.equals(this.annotations, that.annotations) && Objects.equals(this.proportionTypes, that.proportionTypes) && Objects.equals(this.cardinalities, that.cardinalities);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.optionalIdNumber, this.name, this.localizedName, this.rmType, this.nodeId, this.min, this.max, this.localizedNames, this.localizedDescriptions, this.aqlPath, this.children, this.inputs, this.inContext, this.termBindings, this.dependsOn, this.annotations, this.proportionTypes, this.cardinalities);
    }
}

