/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.templateprovider;

import java.util.Optional;
import javax.cache.Cache;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.parser.OPTParser;
import org.ehrbase.webtemplate.templateprovider.TemplateProvider;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class CachedTemplateProvider
implements TemplateProvider {
    private final TemplateProvider rootTemplateProvider;
    private final Cache<String, OPERATIONALTEMPLATE> templateCache;
    private final Cache<String, WebTemplate> introspectCache;

    @Deprecated
    public CachedTemplateProvider(TemplateProvider rootTemplateProvider, Cache<String, OPERATIONALTEMPLATE> templateCache) {
        this.rootTemplateProvider = rootTemplateProvider;
        this.templateCache = templateCache;
        this.introspectCache = null;
    }

    public CachedTemplateProvider(TemplateProvider rootTemplateProvider, Cache<String, OPERATIONALTEMPLATE> templateCache, Cache<String, WebTemplate> introspectCache) {
        this.rootTemplateProvider = rootTemplateProvider;
        this.templateCache = templateCache;
        this.introspectCache = introspectCache;
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> find(String templateId) {
        Optional<OPERATIONALTEMPLATE> operationaltemplate = Optional.ofNullable((OPERATIONALTEMPLATE)this.templateCache.get((Object)templateId));
        if (!operationaltemplate.isPresent()) {
            operationaltemplate = this.rootTemplateProvider.find(templateId);
            operationaltemplate.ifPresent(o -> this.templateCache.put((Object)templateId, o));
        }
        return operationaltemplate;
    }

    @Override
    public Optional<WebTemplate> buildIntrospect(String templateId) {
        WebTemplate templateIntrospect = (WebTemplate)this.introspectCache.get((Object)templateId);
        if (templateIntrospect == null) {
            templateIntrospect = this.find(templateId).map(t -> new OPTParser((OPERATIONALTEMPLATE)t).parse()).orElse(null);
        }
        return Optional.ofNullable(templateIntrospect);
    }
}

