/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.path.flat;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import org.ehrbase.webtemplate.path.flat.FlatPathParser;

public class FlatPathDto {
    private String name;
    private FlatPathDto child;
    private String attributeName;
    private Integer count;

    public FlatPathDto() {
    }

    public FlatPathDto(String path) {
        this(FlatPathParser.parse(path));
    }

    public FlatPathDto(FlatPathDto flatPathDto) {
        this.name = flatPathDto.getName();
        this.child = flatPathDto.getChild();
        this.attributeName = flatPathDto.getAttributeName();
        this.count = flatPathDto.getCount();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlatPathDto getChild() {
        return this.child;
    }

    public void setChild(FlatPathDto child) {
        this.child = child;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        this.appendFormat(sb);
        return sb.toString();
    }

    private void appendFormat(StringBuilder sb) {
        sb.append(this.name);
        if (this.count != null) {
            sb.append(':').append(this.count);
        }
        if (this.attributeName != null) {
            sb.append('|').append(this.attributeName);
        }
        if (this.child != null) {
            sb.append('/');
            this.child.appendFormat(sb);
        }
    }

    public FlatPathDto getLast() {
        FlatPathDto path = this;
        while (path.getChild() != null) {
            path = path.getChild();
        }
        return path;
    }

    public static FlatPathDto removeEnd(FlatPathDto path, FlatPathDto remove) {
        FlatPathDto me = new FlatPathDto(path);
        FlatPathDto other = new FlatPathDto(remove);
        FlatPathDto newMe = null;
        while (!FlatPathDto.isNodeEqual(me, other)) {
            FlatPathDto newChild = new FlatPathDto(me);
            newChild.setChild(null);
            if (newMe == null) {
                newMe = newChild;
            } else {
                newMe.getLast().setChild(newChild);
            }
            if ((me = me.child) != null) continue;
        }
        if (me != null && me.isEqualTo(other.format())) {
            return newMe;
        }
        return me;
    }

    public static boolean isNodeEqual(FlatPathDto me, FlatPathDto other) {
        if (!Objects.equals(me.getName(), other.getName())) {
            return false;
        }
        if (!(Objects.equals(me.getCount(), other.getCount()) || me.getCount() == null && Objects.equals(other.getCount(), 0) || Objects.equals(me.getCount(), 0) && other.getCount() == null)) {
            return false;
        }
        return Objects.equals(me.getAttributeName(), other.getAttributeName());
    }

    public static FlatPathDto removeStart(FlatPathDto path, FlatPathDto remove) {
        FlatPathDto other = new FlatPathDto(remove);
        FlatPathDto me = new FlatPathDto(path);
        while (FlatPathDto.isNodeEqual(me, other)) {
            other = other.getChild();
            me = me.child;
            if (other != null && me != null) continue;
        }
        if (other == null) {
            return me;
        }
        return new FlatPathDto(path);
    }

    public static FlatPathDto addEnd(FlatPathDto path, FlatPathDto add) {
        FlatPathDto flatPath = new FlatPathDto(path);
        flatPath.getLast().setChild(new FlatPathDto(add));
        return flatPath;
    }

    public String toString() {
        return this.format();
    }

    public boolean startsWith(String otherPath) {
        FlatPathDto other = new FlatPathDto(otherPath);
        FlatPathDto me = new FlatPathDto(this);
        do {
            String tempAttributeName = me.getAttributeName();
            if (other.getAttributeName() == null) {
                me.setAttributeName(null);
            }
            Integer tempCount = me.getCount();
            if (other.getChild() == null && other.count == null) {
                me.setCount(null);
            }
            boolean nodeEqual = FlatPathDto.isNodeEqual(me, other);
            me.setAttributeName(tempAttributeName);
            me.setCount(tempCount);
            if (!nodeEqual) break;
            other = other.getChild();
            me = me.child;
        } while (other != null && me != null);
        return other == null;
    }

    public boolean isEqualTo(String otherPath) {
        FlatPathDto other = new FlatPathDto(otherPath);
        FlatPathDto me = new FlatPathDto(this);
        while (Objects.equals(me.getName(), other.getName()) && Objects.equals(me.getAttributeName(), other.getAttributeName()) && (Objects.equals(me.getCount(), other.getCount()) || me.getCount() == null && Objects.equals(other.getCount(), 0) || Objects.equals(me.getCount(), 0) && other.getCount() == null)) {
            other = other.getChild();
            me = me.child;
            if (other != null && me != null) continue;
        }
        return other == null && me == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatPathDto that = (FlatPathDto)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.child, that.child) && Objects.equals(this.attributeName, that.attributeName) && Objects.equals(this.count, that.count);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.child, this.attributeName, this.count);
    }

    public static <T> Map.Entry<FlatPathDto, T> get(Map<FlatPathDto, T> map, String otherPath) {
        return map.entrySet().stream().filter(d -> ((FlatPathDto)d.getKey()).isEqualTo(otherPath)).findAny().orElse(new AbstractMap.SimpleEntry<Object, Object>(null, null));
    }
}

