/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.parser;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class NodeId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final String nodeId;

    public NodeId(String nodeId) {
        if (nodeId.startsWith("at")) {
            this.nodeId = nodeId;
            this.className = null;
        } else if (nodeId.startsWith("openEHR-EHR-")) {
            this.className = StringUtils.substringBetween((String)nodeId, (String)"openEHR-EHR-", (String)".");
            this.nodeId = nodeId;
        } else {
            this.className = nodeId;
            this.nodeId = null;
        }
    }

    public NodeId(String className, String nodeId) {
        this.className = className;
        this.nodeId = nodeId;
    }

    public boolean isArchetypeId() {
        return StringUtils.isNotBlank((CharSequence)this.className) && StringUtils.isNotBlank((CharSequence)this.nodeId);
    }

    public String getClassName() {
        return this.className;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeId nodeId1 = (NodeId)o;
        return Objects.equals(this.className, nodeId1.className) && Objects.equals(this.nodeId, nodeId1.nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.nodeId);
    }

    public String toString() {
        return "NodeId{className='" + this.className + "', nodeId='" + this.nodeId + "'}";
    }
}

