/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehrbase.aql.dto.path.AqlPath;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.NodeId;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebTemplate
implements Serializable {
    private String templateId;
    private String version;
    private String defaultLanguage;
    private final List<String> languages = new ArrayList<String>();
    private WebTemplateNode tree;

    public WebTemplate() {
    }

    public WebTemplate(WebTemplate other) {
        this.templateId = other.templateId;
        this.version = other.version;
        this.defaultLanguage = other.defaultLanguage;
        this.tree = other.tree != null ? new WebTemplateNode(other.tree) : null;
        this.languages.addAll(other.languages);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public WebTemplateNode getTree() {
        return this.tree;
    }

    public void setTree(WebTemplateNode tree) {
        this.tree = tree;
    }

    public List<WebTemplateNode> upperNotBounded() {
        return this.tree.findMatching(t -> t.getMax() == -1);
    }

    public List<WebTemplateNode> multiValued() {
        return this.tree.multiValued();
    }

    public Optional<WebTemplateNode> findByAqlPath(String aql) {
        return this.findAllByAqlPath(aql, true).stream().findFirst();
    }

    public List<WebTemplateNode> findAllByAqlPath(String aql, boolean ignoreName) {
        AqlPath aqlPath = AqlPath.parse((String)aql);
        return this.tree.findMatching(c -> aqlPath.equals((Object)c.getAqlPathDto(), !ignoreName));
    }

    public Set<Set<NodeId>> findAllContainmentCombinations() {
        return this.findAllContainmentCombinations(this.tree);
    }

    private Set<Set<NodeId>> findAllContainmentCombinations(WebTemplateNode tree) {
        NodeId currentContainment;
        LinkedHashSet<Set<NodeId>> containments = new LinkedHashSet<Set<NodeId>>();
        if (tree.getNodeId() != null && new NodeId(tree.getNodeId()).isArchetypeId()) {
            currentContainment = new NodeId(tree.getNodeId());
            containments.add(new LinkedHashSet<NodeId>(Set.of(currentContainment)));
        } else {
            currentContainment = null;
        }
        for (WebTemplateNode child : tree.getChildren()) {
            Set<Set<NodeId>> subSets = this.findAllContainmentCombinations(child);
            containments.addAll(subSets);
            if (currentContainment == null) continue;
            containments.addAll(subSets.stream().map(s -> {
                LinkedHashSet<NodeId> list = new LinkedHashSet<NodeId>(Set.of(currentContainment));
                list.addAll((Collection<NodeId>)s);
                return list;
            }).collect(Collectors.toSet()));
        }
        return containments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebTemplate that = (WebTemplate)o;
        return Objects.equals(this.templateId, that.templateId) && Objects.equals(this.version, that.version) && Objects.equals(this.defaultLanguage, that.defaultLanguage) && this.languages.equals(that.languages) && Objects.equals(this.tree, that.tree);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.version, this.defaultLanguage, this.languages, this.tree);
    }
}

