/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.interpreter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ehrbase.aql.dto.containment.Containment;
import org.ehrbase.webtemplate.interpreter.InterpreterPath;
import org.ehrbase.webtemplate.interpreter.InterpreterPathNode;

public class InterpreterOutput
implements Serializable {
    private int rootContainment;
    private List<Containment> originalContain;
    private List<Containment> contain;
    private InterpreterPath pathFromRootToValue = new InterpreterPath();

    public InterpreterOutput() {
    }

    public InterpreterOutput(InterpreterOutput other) {
        this.rootContainment = other.rootContainment;
        this.contain = other.contain.stream().map(Containment::new).collect(Collectors.toList());
        this.originalContain = other.originalContain.stream().map(Containment::new).collect(Collectors.toList());
        this.pathFromRootToValue = new InterpreterPath();
        this.pathFromRootToValue.setNodeList(new ArrayList<InterpreterPathNode>(other.pathFromRootToValue.getNodeList()));
    }

    public boolean isRepresentingObject() {
        return this.pathFromRootToValue.getNodeList().isEmpty() || this.pathFromRootToValue.getNodeList().get(this.pathFromRootToValue.getNodeList().size() - 1).isRepresentingObject();
    }

    public int getRootContainment() {
        return this.rootContainment;
    }

    public void setRootContainment(int rootContainment) {
        this.rootContainment = rootContainment;
    }

    public List<Containment> getContain() {
        return this.contain;
    }

    public void setContain(List<Containment> contain) {
        this.contain = contain;
    }

    public List<Containment> getOriginalContain() {
        return this.originalContain;
    }

    public void setOriginalContain(List<Containment> originalContain) {
        this.originalContain = originalContain;
    }

    public InterpreterPath getPathFromRootToValue() {
        return this.pathFromRootToValue;
    }

    public void setPathFromRootToValue(InterpreterPath pathFromRootToValue) {
        this.pathFromRootToValue = pathFromRootToValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterpreterOutput that = (InterpreterOutput)o;
        return this.rootContainment == that.rootContainment && Objects.equals(this.originalContain, that.originalContain) && Objects.equals(this.contain, that.contain) && Objects.equals(this.pathFromRootToValue, that.pathFromRootToValue);
    }

    public int hashCode() {
        return Objects.hash(this.rootContainment, this.originalContain, this.contain, this.pathFromRootToValue);
    }

    public String toString() {
        return "InterpreterOutput{rootContainment=" + this.rootContainment + ", originalContain=" + this.originalContain + ", contain=" + this.contain + ", pathFromRootToValue=" + this.pathFromRootToValue + "}";
    }
}

