/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.webtemplate.interpreter;

import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.aql.dto.condition.ConditionComparisonOperatorSymbol;
import org.ehrbase.aql.dto.condition.SimpleValue;
import org.ehrbase.aql.dto.condition.Value;
import org.ehrbase.aql.dto.containment.Containment;
import org.ehrbase.aql.dto.containment.ContainmentDto;
import org.ehrbase.aql.dto.containment.ContainmentExpresionDto;
import org.ehrbase.aql.dto.path.AqlPath;
import org.ehrbase.aql.dto.path.predicate.PredicateComparisonOperatorDto;
import org.ehrbase.aql.dto.path.predicate.PredicateDto;
import org.ehrbase.aql.dto.path.predicate.PredicateHelper;
import org.ehrbase.aql.dto.path.predicate.PredicateLogicalAndOperation;
import org.ehrbase.aql.dto.path.predicate.SimplePredicateDto;
import org.ehrbase.aql.dto.select.SelectFieldDto;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.webtemplate.interpreter.InterpreterInput;
import org.ehrbase.webtemplate.interpreter.InterpreterOutput;
import org.ehrbase.webtemplate.interpreter.InterpreterPathNode;
import org.ehrbase.webtemplate.interpreter.MatcherUtil;
import org.ehrbase.webtemplate.interpreter.SimpleTemplateNode;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.templateprovider.TemplateProvider;

public class Interpreter {
    private static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    private final List<String> resolveTo;
    private final TemplateProvider templateProvider;

    public Interpreter(TemplateProvider templateProvider, List<String> resolveTo) {
        this.templateProvider = templateProvider;
        this.resolveTo = resolveTo;
    }

    private Set<InterpreterInput> toInterpreterInputSet(SelectFieldDto selectFieldDto, ContainmentExpresionDto contains) {
        return this.findContainment(selectFieldDto.getContainmentId(), contains).stream().map(r -> {
            InterpreterInput interpreterInput = new InterpreterInput();
            interpreterInput.setContainment((Containment)r.getRight());
            interpreterInput.setContainmentPath(Arrays.stream((Containment[])r.getLeft()).collect(Collectors.toList()));
            interpreterInput.setPathFromContainment(selectFieldDto.getAqlPathDto());
            return interpreterInput;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<InterpreterOutput> interpret(SelectFieldDto selectFieldDto, ContainmentExpresionDto contains, String templateId) {
        return this.interpret(this.toInterpreterInputSet(selectFieldDto, contains), templateId);
    }

    protected Set<InterpreterOutput> interpret(Set<InterpreterInput> inputs, String templateId) {
        LinkedHashSet<InterpreterOutput> result = new LinkedHashSet<InterpreterOutput>();
        inputs.stream().map(i -> this.interpret((InterpreterInput)i, this.templateProvider.buildIntrospect(templateId).get().getTree())).forEach(result::addAll);
        return result;
    }

    private Set<InterpreterOutput> interpret(InterpreterInput input, WebTemplateNode node) {
        return Interpreter.resolve(input.getContainmentPath(), node).stream().map(r -> this.interpret(input, (List<Pair<WebTemplateNode, Deque<WebTemplateNode>>>)r)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<InterpreterOutput> interpret(InterpreterInput input, List<Pair<WebTemplateNode, Deque<WebTemplateNode>>> result) {
        InterpreterOutput interpreterOutput = new InterpreterOutput();
        interpreterOutput.setOriginalContain(input.getContainmentPath());
        interpreterOutput.setContain(result.stream().map(Pair::getLeft).map(Interpreter::toContainment).collect(Collectors.toList()));
        int containmentIndex = this.findContainmentIndex(input.getContainmentPath(), input.getContainment());
        interpreterOutput.setRootContainment(this.findRootIndex(interpreterOutput.getContain(), containmentIndex));
        WebTemplateNode current = Interpreter.findPathToContainment(result, interpreterOutput, containmentIndex);
        if (input.getPathFromContainment().isEmpty()) {
            return Collections.singleton(interpreterOutput);
        }
        return current.getChildren().stream().map(c -> this.findPathToValue(current, input.getPathFromContainment(), (WebTemplateNode)c)).flatMap(Collection::stream).map(l -> {
            InterpreterOutput output = new InterpreterOutput(interpreterOutput);
            output.getPathFromRootToValue().getNodeList().addAll((Collection<InterpreterPathNode>)l);
            return output;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Containment toContainment(WebTemplateNode n) {
        Containment containment = new Containment();
        if (MatcherUtil.findTypeName(n.getNodeId()).equals("COMPOSITION")) {
            containment.setArchetypeId(n.getNodeId());
            containment.setType("COMPOSITION");
            containment.setOtherPredicates((PredicateDto)new PredicateLogicalAndOperation(new SimplePredicateDto[]{new PredicateComparisonOperatorDto("archetype_node_id", ConditionComparisonOperatorSymbol.EQ, (Value)new SimpleValue((Object)n.getNodeId()))}));
        } else {
            AqlPath.AqlNode lastNode = n.getAqlPathDto().getLastNode();
            containment.setArchetypeId(lastNode.getAtCode());
            containment.setType(MatcherUtil.findTypeName(lastNode.getAtCode()));
            containment.setOtherPredicates((PredicateDto)lastNode.getOtherPredicate());
        }
        return containment;
    }

    private static WebTemplateNode findPathToContainment(List<Pair<WebTemplateNode, Deque<WebTemplateNode>>> result, InterpreterOutput interpreterOutput, int containment) {
        ArrayDeque webTemplateNodes = new ArrayDeque();
        int skip = interpreterOutput.getRootContainment() + 1;
        int maxSize = containment - interpreterOutput.getRootContainment();
        if (maxSize < 0) {
            maxSize = 0;
        }
        result.stream().skip(skip).limit(maxSize).map(Pair::getValue).forEach(webTemplateNodes::addAll);
        WebTemplateNode curent = (WebTemplateNode)result.get(interpreterOutput.getRootContainment()).getLeft();
        interpreterOutput.getPathFromRootToValue().setNodeList(new ArrayList<InterpreterPathNode>());
        while (!webTemplateNodes.isEmpty()) {
            WebTemplateNode next = (WebTemplateNode)webTemplateNodes.poll();
            InterpreterPathNode interpreterPathNode = new InterpreterPathNode();
            interpreterPathNode.setNormalisedNode(next.getAqlPathDto().getLastNode());
            interpreterPathNode.setOtherPredicate((PredicateDto)new PredicateLogicalAndOperation());
            interpreterPathNode.setTemplateNode(new SimpleTemplateNode(next));
            interpreterPathNode.setRepresentingObject(true);
            if (!interpreterPathNode.getTemplateNode().isMulti()) {
                interpreterPathNode.getTemplateNode().setMulti(Interpreter.findRmAttributeInfo(curent, next).isMultipleValued());
            }
            interpreterOutput.getPathFromRootToValue().getNodeList().add(interpreterPathNode);
            curent = next;
        }
        return curent;
    }

    protected Set<List<InterpreterPathNode>> findPathToValue(WebTemplateNode parent, AqlPath path, WebTemplateNode node) {
        if (MatcherUtil.matches(path.getBaseNode(), node)) {
            InterpreterPathNode interpreterPathNode = new InterpreterPathNode();
            interpreterPathNode.setTemplateNode(new SimpleTemplateNode(node));
            if (!interpreterPathNode.getTemplateNode().isMulti()) {
                interpreterPathNode.getTemplateNode().setMulti(Interpreter.findRmAttributeInfo(parent, node).isMultipleValued());
            }
            interpreterPathNode.setOtherPredicate((PredicateDto)PredicateHelper.remove((PredicateLogicalAndOperation)path.getBaseNode().getOtherPredicate(), (String[])new String[]{"name/value", "archetype_node_id"}));
            interpreterPathNode.setNormalisedNode(node.getAqlPathDto().getLastNode());
            interpreterPathNode.setRepresentingObject(true);
            if (path.getNodeCount() == 1) {
                return Collections.singleton(new ArrayList<InterpreterPathNode>(List.of(interpreterPathNode)));
            }
            if (CollectionUtils.isEmpty(node.getChildren())) {
                Optional input = node.getInputs().stream().map(i -> this.findPathToValue(node, path.removeStart(1), (WebTemplateInput)i)).flatMap(Optional::stream).findAny();
                if (input.isEmpty()) {
                    return Collections.emptySet();
                }
                return Collections.singleton(new ArrayList<InterpreterPathNode>(List.of(interpreterPathNode, (InterpreterPathNode)input.get())));
            }
            LinkedHashSet<List<InterpreterPathNode>> result = new LinkedHashSet<List<InterpreterPathNode>>();
            node.getChildren().stream().map(c -> this.findPathToValue(node, path.removeStart(1), (WebTemplateNode)c)).flatMap(Collection::stream).forEach(l -> {
                l.add(0, interpreterPathNode);
                result.add((List<InterpreterPathNode>)l);
            });
            return result;
        }
        return Collections.emptySet();
    }

    protected Optional<InterpreterPathNode> findPathToValue(WebTemplateNode parent, AqlPath path, WebTemplateInput input) {
        if (MatcherUtil.matches(path.getBaseNode(), input)) {
            InterpreterPathNode interpreterPathNode = new InterpreterPathNode();
            interpreterPathNode.setNormalisedNode(new AqlPath.AqlNode(Optional.ofNullable(input.getSuffix()).orElse("value"), null, new PredicateLogicalAndOperation()));
            interpreterPathNode.setOtherPredicate((PredicateDto)new PredicateLogicalAndOperation());
            interpreterPathNode.setTemplateNode(new SimpleTemplateNode(input));
            interpreterPathNode.setRepresentingObject(false);
            return Optional.of(interpreterPathNode);
        }
        return Optional.empty();
    }

    private int findRootIndex(List<Containment> c, int i) {
        while (i >= 0) {
            if (this.resolveTo.contains(c.get(i).getType())) {
                return i;
            }
            --i;
        }
        throw new SdkException(String.format("No Element in %s  matches %s", c, this.resolveTo));
    }

    private int findContainmentIndex(List<Containment> c, Containment con) {
        for (int i = 0; i < c.size(); ++i) {
            if (!c.get(i).equals((Object)con)) continue;
            return i;
        }
        throw new SdkException(String.format("No Element in %s  matches %s", c, con));
    }

    protected Set<Pair<Containment[], Containment>> findContainment(Integer id, ContainmentExpresionDto containmentDto) {
        if (containmentDto instanceof ContainmentDto) {
            return this.findContainmentInContainmentDto(id, (ContainmentDto)containmentDto);
        }
        throw new UnsupportedOperationException(String.format("%s not supported", containmentDto.getClass().getName()));
    }

    private Set<Pair<Containment[], Containment>> findContainmentInContainmentDto(Integer id, ContainmentDto containmentDto) {
        if (containmentDto.getContains() == null) {
            if (id == null || id.equals(containmentDto.getId())) {
                LinkedHashSet<Pair<Containment[], Containment>> list = new LinkedHashSet<Pair<Containment[], Containment>>();
                list.add(Pair.of((Object)new Containment[]{containmentDto.getContainment()}, (Object)(id != null ? containmentDto.getContainment() : null)));
                return list;
            }
            return Collections.emptySortedSet();
        }
        if (id != null && id.equals(containmentDto.getId())) {
            return this.findContainment(null, containmentDto.getContains()).stream().map(a -> Pair.of((Object)((Containment[])ArrayUtils.addFirst((Object[])((Containment[])a.getLeft()), (Object)containmentDto.getContainment())), (Object)containmentDto.getContainment())).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.findContainment(id, containmentDto.getContains()).stream().map(a -> Pair.of((Object)((Containment[])ArrayUtils.addFirst((Object[])((Containment[])a.getLeft()), (Object)containmentDto.getContainment())), (Object)((Containment)a.getRight()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected static Set<List<Pair<WebTemplateNode, Deque<WebTemplateNode>>>> resolve(List<Containment> contains, WebTemplateNode node) {
        if (contains.size() == 1 && MatcherUtil.matches(contains.get(0), node)) {
            ArrayDeque<WebTemplateNode> right = new ArrayDeque<WebTemplateNode>();
            right.add(node);
            return Collections.singleton(new ArrayList<Pair>(Collections.singletonList(Pair.of((Object)node, right))));
        }
        if (CollectionUtils.isEmpty(node.getChildren())) {
            return Collections.emptySet();
        }
        if (MatcherUtil.matches(contains.get(0), node)) {
            LinkedHashSet<List<Pair<WebTemplateNode, Deque<WebTemplateNode>>>> result = new LinkedHashSet<List<Pair<WebTemplateNode, Deque<WebTemplateNode>>>>();
            node.getChildren().stream().map(c -> {
                ArrayList<Containment> nextContains = new ArrayList<Containment>(contains);
                nextContains.remove(0);
                return Interpreter.resolve(nextContains, c);
            }).flatMap(Collection::stream).map(a -> {
                ArrayDeque<WebTemplateNode> right = new ArrayDeque<WebTemplateNode>();
                right.add(node);
                a.add(0, Pair.of((Object)node, right));
                return a;
            }).forEach(result::add);
            return result;
        }
        LinkedHashSet<List<Pair<WebTemplateNode, Deque<WebTemplateNode>>>> result = new LinkedHashSet<List<Pair<WebTemplateNode, Deque<WebTemplateNode>>>>();
        node.getChildren().stream().map(c -> Interpreter.resolve(contains, c)).flatMap(Collection::stream).map(p -> {
            ((Deque)((Pair)p.get(0)).getValue()).addFirst(node);
            return p;
        }).forEach(result::add);
        return result;
    }

    public static RMAttributeInfo findRmAttributeInfo(WebTemplateNode parent, WebTemplateNode child) {
        String attributeName = child.getAqlPathDto().removeStart(parent.getAqlPathDto()).getBaseNode().getName();
        return ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parent.getRmType(), attributeName);
    }
}

