/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CTypeValidate;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.CINTEGER;
import org.openehr.schemas.v1.CPRIMITIVE;
import org.openehr.schemas.v1.IntervalOfInteger;

public class CInteger
extends CConstraint
implements I_CTypeValidate {
    CInteger(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, CPRIMITIVE cprimitive) throws IllegalArgumentException {
        CINTEGER cinteger = (CINTEGER)cprimitive;
        Integer integer = null;
        if (aValue instanceof Integer) {
            integer = (Integer)aValue;
        } else if (aValue instanceof Long) {
            integer = ((Long)aValue).intValue();
        } else {
            ValidationException.raise(path, "Value is not a supported type for Integer:" + aValue.getClass().getSimpleName(), "INT02");
        }
        IntervalOfInteger intervalOfInteger = cinteger.getRange();
        if (intervalOfInteger != null) {
            IntervalComparator.isWithinBoundaries(integer, intervalOfInteger);
        }
        if (cinteger.sizeOfListArray() > 0 && !ArrayUtils.contains((int[])cinteger.getListArray(), (int)integer)) {
            ValidationException.raise(path, "Integer value does not match any values in constraint:" + integer, "INT01");
        }
    }
}

