/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rm.datavalues.quantity.DvQuantity;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CArchetypeConstraintValidate;
import org.ehrbase.validation.constraints.wrappers.IntervalComparator;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.openehr.schemas.v1.CDVQUANTITY;
import org.openehr.schemas.v1.CQUANTITYITEM;
import org.openehr.schemas.v1.IntervalOfReal;

public class CDvQuantity
extends CConstraint
implements I_CArchetypeConstraintValidate {
    CDvQuantity(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, ARCHETYPECONSTRAINT archetypeconstraint) throws IllegalArgumentException {
        block7: {
            DvQuantity quantity = (DvQuantity)aValue;
            if (quantity.getMagnitude() == null) {
                ValidationException.raise(path, "DvQuantity requires a non null magnitude", "DV_QUANTITY_01");
            }
            CDVQUANTITY constraint = (CDVQUANTITY)archetypeconstraint;
            if (quantity.getUnits() == null) {
                ValidationException.raise(path, "No units specified for item:" + quantity + " at path:" + path, "DV_QUANTITY_02");
            }
            ArrayList<String> stringBuffer = new ArrayList<String>();
            if (constraint.sizeOfListArray() != 0) {
                for (CQUANTITYITEM cquantityitem : constraint.getListArray()) {
                    if (cquantityitem.getUnits().equals(quantity.getUnits())) {
                        Long precision;
                        if (cquantityitem.isSetMagnitude()) {
                            IntervalOfReal magnitudes = cquantityitem.getMagnitude();
                            IntervalComparator.isWithinBoundaries(Float.valueOf(quantity.getMagnitude().floatValue()), magnitudes);
                        }
                        if (cquantityitem.isSetMagnitude() && quantity.getMagnitude() != null && (precision = quantity.getPrecision()) != null) {
                            IntervalComparator.isWithinPrecision(precision.intValue(), cquantityitem.getPrecision());
                        }
                        break block7;
                    }
                    stringBuffer.add(cquantityitem.getUnits());
                }
                ValidationException.raise(path, "No matching units for:" + (StringUtils.isNotEmpty((CharSequence)quantity.getUnits()) ? quantity.getUnits() : "*undef*") + ", expected units:" + String.join((CharSequence)",", stringBuffer), "DV_QUANTITY_03");
            }
        }
    }
}

