/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import java.util.Map;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CAttribute;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CArchetypeConstraintValidate;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;

public class CComplexObject
extends CConstraint
implements I_CArchetypeConstraintValidate {
    CComplexObject(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object value, ARCHETYPECONSTRAINT constraint) {
        CCOMPLEXOBJECT ccomplexobject = (CCOMPLEXOBJECT)constraint;
        int attributeCount = ccomplexobject.sizeOfAttributesArray();
        int failCount = 0;
        Throwable lastException = null;
        for (CATTRIBUTE cattribute : ccomplexobject.getAttributesArray()) {
            try {
                new CAttribute(this.localTerminologyLookup, this.externalTerminologyValidator).validate(path, value, (ARCHETYPECONSTRAINT)cattribute);
            }
            catch (ValidationException e) {
                lastException = e;
                ++failCount;
            }
        }
        if (attributeCount > 0 && failCount > 0) {
            ValidationException.raise(path, lastException.getMessage(), "ELT01");
        }
    }
}

